/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.db;

import java.io.Flushable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.config.Configuration;

public abstract class AbstractDatabaseManager
extends AbstractManager
implements Flushable {
    private final ArrayList<LogEvent> buffer;
    private final int bufferSize;
    private final Layout<? extends Serializable> layout;
    private boolean running;

    /*
     * WARNING - void declaration
     */
    protected static <M extends AbstractDatabaseManager, T extends AbstractFactoryData> M getManager(String name, T data, ManagerFactory<M, T> factory) {
        void var1_1;
        void var2_2;
        return (M)((AbstractDatabaseManager)AbstractManager.getManager(name, var2_2, var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected AbstractDatabaseManager(String name, int bufferSize) {
        this((String)var1_1, (int)var2_2, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected AbstractDatabaseManager(String name, int bufferSize, Layout<? extends Serializable> layout) {
        this((String)var1_1, (int)var2_2, (Layout<? extends Serializable>)var3_3, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractDatabaseManager(String name, int bufferSize, Layout<? extends Serializable> layout, Configuration configuration) {
        super(configuration != null ? configuration.getLoggerContext() : null, (String)var1_1);
        void var3_3;
        void var2_2;
        void var1_1;
        this.bufferSize = bufferSize;
        this.buffer = new ArrayList((int)(var2_2 + true));
        this.layout = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    protected void buffer(LogEvent event) {
        void var1_1;
        this.buffer.add(event.toImmutable());
        if (this.buffer.size() >= this.bufferSize || var1_1.isEndOfBatch()) {
            this.flush();
        }
    }

    protected abstract boolean commitAndClose();

    protected abstract void connectAndStart();

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized void flush() {
        if (this.isRunning() && this.isBuffered()) {
            this.connectAndStart();
            try {
                for (LogEvent event : this.buffer) {
                    void var2_3;
                    this.writeInternal(event, this.layout != null ? this.layout.toSerializable((LogEvent)var2_3) : null);
                }
                return;
            }
            finally {
                this.commitAndClose();
                this.buffer.clear();
            }
        }
    }

    protected boolean isBuffered() {
        return this.bufferSize > 0;
    }

    public final boolean isRunning() {
        return this.running;
    }

    @Override
    public final boolean releaseSub(long timeout, TimeUnit timeUnit) {
        return this.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized boolean shutdown() {
        boolean bl;
        boolean closed = true;
        this.flush();
        if (this.isRunning()) {
            try {
                closed = true & this.shutdownInternal();
            }
            catch (Exception e) {
                void var1_2;
                this.logWarn("Caught exception while performing database shutdown operations", (Throwable)var1_2);
                bl = false;
            }
            finally {
                this.running = false;
            }
        }
        return bl;
    }

    protected abstract boolean shutdownInternal() throws Exception;

    /*
     * WARNING - void declaration
     */
    public final synchronized void startup() {
        if (!this.isRunning()) {
            try {
                this.startupInternal();
                this.running = true;
                return;
            }
            catch (Exception e) {
                void var1_1;
                this.logError("Could not perform database startup operations", (Throwable)var1_1);
            }
        }
    }

    protected abstract void startupInternal() throws Exception;

    public final String toString() {
        return this.getName();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public final synchronized void write(LogEvent event) {
        void var1_1;
        this.write((LogEvent)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void write(LogEvent event, Serializable serializable) {
        void var2_2;
        void var1_1;
        if (this.isBuffered()) {
            this.buffer(event);
            return;
        }
        this.writeThrough((LogEvent)var1_1, (Serializable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected void writeInternal(LogEvent event) {
        void var1_1;
        this.writeInternal((LogEvent)var1_1, null);
    }

    protected abstract void writeInternal(LogEvent var1, Serializable var2);

    /*
     * WARNING - void declaration
     */
    protected void writeThrough(LogEvent event, Serializable serializable) {
        this.connectAndStart();
        try {
            void var2_3;
            void var1_1;
            this.writeInternal((LogEvent)var1_1, (Serializable)var2_3);
            return;
        }
        finally {
            this.commitAndClose();
        }
    }

    protected static abstract class AbstractFactoryData
    extends AbstractManager.AbstractFactoryData {
        private final int bufferSize;
        private final Layout<? extends Serializable> layout;

        /*
         * WARNING - void declaration
         */
        protected AbstractFactoryData(int bufferSize, Layout<? extends Serializable> layout) {
            this(null, (int)var1_1, (Layout<? extends Serializable>)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        protected AbstractFactoryData(Configuration configuration, int bufferSize, Layout<? extends Serializable> layout) {
            super((Configuration)var1_1);
            void var3_3;
            void var2_2;
            void var1_1;
            this.bufferSize = var2_2;
            this.layout = var3_3;
        }

        public int getBufferSize() {
            return this.bufferSize;
        }

        public Layout<? extends Serializable> getLayout() {
            return this.layout;
        }
    }
}

