/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.StringLayout;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.appender.ManagerFactory;

public class WriterManager
extends AbstractManager {
    protected final StringLayout layout;
    private volatile Writer writer;

    /*
     * WARNING - void declaration
     */
    public static <T> WriterManager getManager(String name, T data, ManagerFactory<? extends WriterManager, T> factory) {
        void var1_1;
        void var2_2;
        return (WriterManager)AbstractManager.getManager(name, var2_2, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public WriterManager(Writer writer, String streamName, StringLayout layout, boolean writeHeader) {
        super(null, (String)var2_3);
        byte[] header;
        void var2_3;
        this.writer = writer;
        this.layout = layout;
        if (writeHeader && layout != null && (header = layout.getHeader()) != null) {
            try {
                void var3_4;
                this.writer.write(new String(header, var3_4.getCharset()));
                return;
            }
            catch (IOException e) {
                void var1_2;
                this.logError("Unable to write header", (Throwable)var1_2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected synchronized void closeWriter() {
        Writer w = this.writer;
        try {
            w.close();
            return;
        }
        catch (IOException ex) {
            void var1_2;
            this.logError("Unable to close stream", (Throwable)var1_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void flush() {
        try {
            this.writer.flush();
            return;
        }
        catch (IOException ex) {
            void var1_1;
            void var2_2;
            String msg = "Error flushing stream " + this.getName();
            throw new AppenderLoggingException((String)var2_2, (Throwable)var1_1);
        }
    }

    protected Writer getWriter() {
        return this.writer;
    }

    public boolean isOpen() {
        return this.getCount() > 0;
    }

    @Override
    public boolean releaseSub(long timeout, TimeUnit timeUnit) {
        this.writeFooter();
        this.closeWriter();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected void setWriter(Writer writer) {
        void var1_1;
        byte[] header = this.layout.getHeader();
        if (header != null) {
            try {
                void var2_3;
                writer.write(new String((byte[])var2_3, this.layout.getCharset()));
                this.writer = writer;
                return;
            }
            catch (IOException ioe) {
                void var1_2;
                this.logError("Unable to write header", (Throwable)var1_2);
                return;
            }
        }
        this.writer = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected synchronized void write(String str) {
        try {
            this.writer.write(str);
            return;
        }
        catch (IOException ex) {
            void var1_2;
            void var2_3;
            String msg = "Error writing to stream " + this.getName();
            throw new AppenderLoggingException((String)var2_3, (Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void writeFooter() {
        if (this.layout == null) {
            return;
        }
        byte[] footer = this.layout.getFooter();
        if (footer != null && footer.length > 0) {
            void var1_1;
            this.write(new String((byte[])var1_1, this.layout.getCharset()));
        }
    }
}

