/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAliases;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.ValidHost;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.ValidPort;
import org.apache.logging.log4j.core.net.AbstractSocketManager;
import org.apache.logging.log4j.core.net.Advertiser;
import org.apache.logging.log4j.core.net.DatagramSocketManager;
import org.apache.logging.log4j.core.net.Protocol;
import org.apache.logging.log4j.core.net.SocketOptions;
import org.apache.logging.log4j.core.net.SslSocketManager;
import org.apache.logging.log4j.core.net.TcpSocketManager;
import org.apache.logging.log4j.core.net.ssl.SslConfiguration;
import org.apache.logging.log4j.core.util.Booleans;

@Plugin(name="Socket", category="Core", elementType="appender", printObject=true)
public class SocketAppender
extends AbstractOutputStreamAppender<AbstractSocketManager> {
    private final Object advertisement;
    private final Advertiser advertiser;

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    /*
     * WARNING - void declaration
     */
    protected SocketAppender(String name, Layout<? extends Serializable> layout, Filter filter, AbstractSocketManager manager, boolean ignoreExceptions, boolean immediateFlush, Advertiser advertiser, Property[] properties) {
        super(name, layout, filter, ignoreExceptions, immediateFlush, properties, manager);
        if (advertiser != null) {
            void var3_3;
            void var1_1;
            void var2_2;
            HashMap<String, String> configuration = new HashMap<String, String>(layout.getContentFormat());
            configuration.putAll(((AbstractManager)manager).getContentFormat());
            configuration.put("contentType", var2_2.getContentType());
            configuration.put("name", (String)var1_1);
            this.advertisement = advertiser.advertise((Map<String, String>)var3_3);
        } else {
            this.advertisement = null;
        }
        this.advertiser = advertiser;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected SocketAppender(String name, Layout<? extends Serializable> layout, Filter filter, AbstractSocketManager manager, boolean ignoreExceptions, boolean immediateFlush, Advertiser advertiser) {
        this((String)var1_1, (Layout<? extends Serializable>)var2_2, (Filter)var3_3, manager, ignoreExceptions, immediateFlush, advertiser, Property.EMPTY_ARRAY);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean stop(long timeout, TimeUnit timeUnit) {
        void var3_2;
        void var1_1;
        this.setStopping();
        super.stop((long)var1_1, (TimeUnit)var3_2, false);
        if (this.advertiser != null) {
            this.advertiser.unadvertise(this.advertisement);
        }
        this.setStopped();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @PluginFactory
    public static SocketAppender createAppender(String host, int port, Protocol protocol, SslConfiguration sslConfig, int connectTimeoutMillis, int reconnectDelayMillis, boolean immediateFail, String name, boolean immediateFlush, boolean ignoreExceptions, Layout<? extends Serializable> layout, Filter filter, boolean advertise, Configuration configuration) {
        void var3_3;
        void var2_2;
        void var1_1;
        String string;
        return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)SocketAppender.newBuilder().setAdvertise(advertise)).setConfiguration(configuration)).setConnectTimeoutMillis(connectTimeoutMillis)).setFilter(filter)).setHost(string)).setIgnoreExceptions(ignoreExceptions)).setImmediateFail(immediateFail)).setLayout(layout)).setName(name)).setPort((int)var1_1)).setProtocol((Protocol)var2_2)).setReconnectDelayMillis(reconnectDelayMillis)).setSslConfiguration((SslConfiguration)var3_3)).build();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static SocketAppender createAppender(String host, String portNum, String protocolIn, SslConfiguration sslConfig, int connectTimeoutMillis, String delayMillis, String immediateFail, String name, String immediateFlush, String ignore, Layout<? extends Serializable> layout, Filter filter, String advertise, Configuration config) {
        void var3_4;
        void var2_3;
        void var1_2;
        String string;
        boolean isFlush = Booleans.parseBoolean(immediateFlush, true);
        boolean isAdvertise = Boolean.parseBoolean(advertise);
        boolean ignoreExceptions = Booleans.parseBoolean(ignore, true);
        boolean fail = Booleans.parseBoolean(immediateFail, true);
        int reconnectDelayMillis = AbstractAppender.parseInt(delayMillis, 0);
        int port = AbstractAppender.parseInt(portNum, 0);
        Protocol p = protocolIn == null ? Protocol.UDP : Protocol.valueOf(protocolIn);
        return SocketAppender.createAppender(string, (int)var1_2, (Protocol)var2_3, (SslConfiguration)var3_4, connectTimeoutMillis, reconnectDelayMillis, fail, name, isFlush, ignoreExceptions, layout, filter, isAdvertise, config);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected static AbstractSocketManager createSocketManager(String name, Protocol protocol, String host, int port, int connectTimeoutMillis, SslConfiguration sslConfig, int reconnectDelayMillis, boolean immediateFail, Layout<? extends Serializable> layout, int bufferSize) {
        void var3_3;
        void var2_2;
        void var1_1;
        return SocketAppender.createSocketManager(name, (Protocol)var1_1, (String)var2_2, (int)var3_3, connectTimeoutMillis, sslConfig, reconnectDelayMillis, immediateFail, layout, bufferSize, null);
    }

    /*
     * WARNING - void declaration
     */
    protected static AbstractSocketManager createSocketManager(String name, Protocol protocol, String host, int port, int connectTimeoutMillis, SslConfiguration sslConfig, int reconnectDelayMillis, boolean immediateFail, Layout<? extends Serializable> layout, int bufferSize, SocketOptions socketOptions) {
        void var1_1;
        if (protocol == Protocol.TCP && sslConfig != null) {
            protocol = Protocol.SSL;
        }
        if (protocol != Protocol.SSL && sslConfig != null) {
            String string;
            LOGGER.info("Appender {} ignoring SSL configuration for {} protocol", (Object)string, (Object)protocol);
        }
        switch (protocol) {
            case TCP: {
                return TcpSocketManager.getSocketManager(host, port, connectTimeoutMillis, reconnectDelayMillis, immediateFail, layout, bufferSize, socketOptions);
            }
            case UDP: {
                return DatagramSocketManager.getSocketManager(host, port, layout, bufferSize);
            }
            case SSL: {
                void var3_3;
                void var2_2;
                return SslSocketManager.getSocketManager(sslConfig, (String)var2_2, (int)var3_3, connectTimeoutMillis, reconnectDelayMillis, immediateFail, layout, bufferSize, socketOptions);
            }
        }
        throw new IllegalArgumentException(var1_1.toString());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void directEncodeEvent(LogEvent event) {
        void var1_1;
        this.writeByteArrayToManager((LogEvent)var1_1);
    }

    public static class Builder
    extends AbstractBuilder<Builder>
    implements org.apache.logging.log4j.core.util.Builder<SocketAppender> {
        /*
         * WARNING - void declaration
         */
        @Override
        public SocketAppender build() {
            void var1_1;
            void var2_2;
            void var3_3;
            boolean immediateFlush = this.isImmediateFlush();
            boolean bufferedIo = this.isBufferedIo();
            Layout<Serializable> layout = this.getLayout();
            if (layout == null) {
                LOGGER.error("No layout provided for SocketAppender");
                return null;
            }
            String name = this.getName();
            if (name == null) {
                LOGGER.error("No name provided for SocketAppender");
                return null;
            }
            Protocol protocol = this.getProtocol();
            Protocol actualProtocol = protocol != null ? protocol : Protocol.TCP;
            if (actualProtocol == Protocol.UDP) {
                immediateFlush = true;
            }
            AbstractSocketManager manager = SocketAppender.createSocketManager(name, actualProtocol, this.getHost(), this.getPort(), this.getConnectTimeoutMillis(), this.getSslConfiguration(), this.getReconnectDelayMillis(), this.getImmediateFail(), layout, this.getBufferSize(), this.getSocketOptions());
            return new SocketAppender(name, (Layout<? extends Serializable>)var3_3, this.getFilter(), manager, this.isIgnoreExceptions(), var2_2 == false || var1_1 != false, this.getAdvertise() ? this.getConfiguration().getAdvertiser() : null, this.getPropertyArray());
        }
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder<B>>
    extends AbstractOutputStreamAppender.Builder<B> {
        @PluginBuilderAttribute
        private boolean advertise;
        @PluginBuilderAttribute
        private int connectTimeoutMillis;
        @PluginBuilderAttribute
        @ValidHost
        private String host = "localhost";
        @PluginBuilderAttribute
        private boolean immediateFail = true;
        @PluginBuilderAttribute
        @ValidPort
        private int port;
        @PluginBuilderAttribute
        private Protocol protocol = Protocol.TCP;
        @PluginBuilderAttribute
        @PluginAliases(value={"reconnectDelay", "reconnectionDelay", "delayMillis", "reconnectionDelayMillis"})
        private int reconnectDelayMillis;
        @PluginElement(value="SocketOptions")
        private SocketOptions socketOptions;
        @PluginElement(value="SslConfiguration")
        @PluginAliases(value={"SslConfig"})
        private SslConfiguration sslConfiguration;

        public boolean getAdvertise() {
            return this.advertise;
        }

        public int getConnectTimeoutMillis() {
            return this.connectTimeoutMillis;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public Protocol getProtocol() {
            return this.protocol;
        }

        public SslConfiguration getSslConfiguration() {
            return this.sslConfiguration;
        }

        public boolean getImmediateFail() {
            return this.immediateFail;
        }

        /*
         * WARNING - void declaration
         */
        public B setAdvertise(boolean advertise) {
            void var1_1;
            this.advertise = var1_1;
            return (B)((AbstractBuilder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setConnectTimeoutMillis(int connectTimeoutMillis) {
            void var1_1;
            this.connectTimeoutMillis = var1_1;
            return (B)((AbstractBuilder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setHost(String host) {
            void var1_1;
            this.host = var1_1;
            return (B)((AbstractBuilder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setImmediateFail(boolean immediateFail) {
            void var1_1;
            this.immediateFail = var1_1;
            return (B)((AbstractBuilder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setPort(int port) {
            void var1_1;
            this.port = var1_1;
            return (B)((AbstractBuilder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setProtocol(Protocol protocol) {
            void var1_1;
            this.protocol = var1_1;
            return (B)((AbstractBuilder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setReconnectDelayMillis(int reconnectDelayMillis) {
            void var1_1;
            this.reconnectDelayMillis = var1_1;
            return (B)((AbstractBuilder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setSocketOptions(SocketOptions socketOptions) {
            void var1_1;
            this.socketOptions = var1_1;
            return (B)((AbstractBuilder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setSslConfiguration(SslConfiguration sslConfiguration) {
            void var1_1;
            this.sslConfiguration = var1_1;
            return (B)((AbstractBuilder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public B withAdvertise(boolean advertise) {
            void var1_1;
            this.advertise = var1_1;
            return (B)((AbstractBuilder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public B withConnectTimeoutMillis(int connectTimeoutMillis) {
            void var1_1;
            this.connectTimeoutMillis = var1_1;
            return (B)((AbstractBuilder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public B withHost(String host) {
            void var1_1;
            this.host = var1_1;
            return (B)((AbstractBuilder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public B withImmediateFail(boolean immediateFail) {
            void var1_1;
            this.immediateFail = var1_1;
            return (B)((AbstractBuilder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public B withPort(int port) {
            void var1_1;
            this.port = var1_1;
            return (B)((AbstractBuilder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public B withProtocol(Protocol protocol) {
            void var1_1;
            this.protocol = var1_1;
            return (B)((AbstractBuilder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public B withReconnectDelayMillis(int reconnectDelayMillis) {
            void var1_1;
            this.reconnectDelayMillis = var1_1;
            return (B)((AbstractBuilder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public B withSocketOptions(SocketOptions socketOptions) {
            void var1_1;
            this.socketOptions = var1_1;
            return (B)((AbstractBuilder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public B withSslConfiguration(SslConfiguration sslConfiguration) {
            void var1_1;
            this.sslConfiguration = var1_1;
            return (B)((AbstractBuilder)this.asBuilder());
        }

        public int getReconnectDelayMillis() {
            return this.reconnectDelayMillis;
        }

        public SocketOptions getSocketOptions() {
            return this.socketOptions;
        }
    }
}

