/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.ValidPort;
import org.apache.logging.log4j.core.filter.ThresholdFilter;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.layout.HtmlLayout;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.net.MailManager;
import org.apache.logging.log4j.core.net.MailManagerFactory;
import org.apache.logging.log4j.core.net.SmtpManager;
import org.apache.logging.log4j.core.net.ssl.SslConfiguration;
import org.apache.logging.log4j.core.util.Booleans;
import org.apache.logging.log4j.core.util.Integers;
import org.apache.logging.log4j.util.ServiceLoaderUtil;
import org.apache.logging.log4j.util.Strings;

@Plugin(name="SMTP", category="Core", elementType="appender", printObject=true)
public final class SmtpAppender
extends AbstractAppender {
    private static final int DEFAULT_BUFFER_SIZE = 512;
    private final MailManager manager;

    /*
     * WARNING - void declaration
     */
    private SmtpAppender(String name, Filter filter, Layout<? extends Serializable> layout, MailManager manager, boolean ignoreExceptions, Property[] properties) {
        super((String)var1_1, (Filter)var2_2, (Layout<? extends Serializable>)var3_3, ignoreExceptions, properties);
        void var3_3;
        void var2_2;
        void var1_1;
        this.manager = manager;
    }

    public final MailManager getManager() {
        return this.manager;
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    @Deprecated
    public static SmtpAppender createAppender(@PluginConfiguration Configuration config, @PluginAttribute(value="name") @Required String name, @PluginAttribute(value="to") String to, @PluginAttribute(value="cc") String cc, @PluginAttribute(value="bcc") String bcc, @PluginAttribute(value="from") String from, @PluginAttribute(value="replyTo") String replyTo, @PluginAttribute(value="subject") String subject, @PluginAttribute(value="smtpProtocol") String smtpProtocol, @PluginAttribute(value="smtpHost") String smtpHost, @PluginAttribute(value="smtpPort", defaultString="0") @ValidPort String smtpPortStr, @PluginAttribute(value="smtpUsername") String smtpUsername, @PluginAttribute(value="smtpPassword", sensitive=true) String smtpPassword, @PluginAttribute(value="smtpDebug") String smtpDebug, @PluginAttribute(value="bufferSize") String bufferSizeStr, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter, @PluginAttribute(value="ignoreExceptions") String ignore) {
        Configuration configuration;
        if (name == null) {
            LOGGER.error("No name provided for SmtpAppender");
            return null;
        }
        return ((Builder)((Builder)((Builder)SmtpAppender.newBuilder().setIgnoreExceptions(Booleans.parseBoolean(ignore, true))).setSmtpPort(AbstractAppender.parseInt(smtpPortStr, 0)).setSmtpDebug(Boolean.parseBoolean(smtpDebug)).setBufferSize(bufferSizeStr == null ? 512 : Integers.parseInt(bufferSizeStr)).setLayout((Layout)layout)).setFilter(filter).setConfiguration(config != null ? configuration : new DefaultConfiguration())).build();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean isFiltered(LogEvent event) {
        void var2_2;
        boolean filtered = super.isFiltered(event);
        if (filtered) {
            void var1_1;
            this.manager.add((LogEvent)var1_1);
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void append(LogEvent event) {
        void var1_1;
        this.manager.sendEvents(this.getLayout(), (LogEvent)var1_1);
    }

    public static class Builder
    extends AbstractAppender.Builder<Builder>
    implements org.apache.logging.log4j.core.util.Builder<SmtpAppender> {
        @PluginBuilderAttribute
        private String to;
        @PluginBuilderAttribute
        private String cc;
        @PluginBuilderAttribute
        private String bcc;
        @PluginBuilderAttribute
        private String from;
        @PluginBuilderAttribute
        private String replyTo;
        @PluginBuilderAttribute
        private String subject;
        @PluginBuilderAttribute
        private String smtpProtocol = "smtp";
        @PluginBuilderAttribute
        private String smtpHost;
        @PluginBuilderAttribute
        @ValidPort
        private int smtpPort;
        @PluginBuilderAttribute
        private String smtpUsername;
        @PluginBuilderAttribute(sensitive=true)
        private String smtpPassword;
        @PluginBuilderAttribute
        private boolean smtpDebug;
        @PluginBuilderAttribute
        private int bufferSize = 512;
        @PluginElement(value="SSL")
        private SslConfiguration sslConfiguration;

        /*
         * WARNING - void declaration
         */
        public Builder setTo(String to) {
            void var1_1;
            this.to = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setCc(String cc) {
            void var1_1;
            this.cc = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setBcc(String bcc) {
            void var1_1;
            this.bcc = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setFrom(String from) {
            void var1_1;
            this.from = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setReplyTo(String replyTo) {
            void var1_1;
            this.replyTo = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setSubject(String subject) {
            void var1_1;
            this.subject = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setSmtpProtocol(String smtpProtocol) {
            void var1_1;
            this.smtpProtocol = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setSmtpHost(String smtpHost) {
            void var1_1;
            this.smtpHost = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setSmtpPort(int smtpPort) {
            void var1_1;
            this.smtpPort = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setSmtpUsername(String smtpUsername) {
            void var1_1;
            this.smtpUsername = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setSmtpPassword(String smtpPassword) {
            void var1_1;
            this.smtpPassword = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setSmtpDebug(boolean smtpDebug) {
            void var1_1;
            this.smtpDebug = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setBufferSize(int bufferSize) {
            void var1_1;
            this.bufferSize = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setSslConfiguration(SslConfiguration sslConfiguration) {
            void var1_1;
            this.sslConfiguration = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Builder setLayout(Layout<? extends Serializable> layout) {
            void var1_1;
            return (Builder)super.setLayout((Layout<Serializable>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Builder setFilter(Filter filter) {
            void var1_1;
            return (Builder)super.setFilter((Filter)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SmtpAppender build() {
            void var1_1;
            void var2_2;
            if (this.getLayout() == null) {
                this.setLayout((Layout)HtmlLayout.createDefaultLayout());
            }
            if (this.getFilter() == null) {
                this.setFilter(ThresholdFilter.createFilter(null, null, null));
            }
            if (Strings.isEmpty((CharSequence)this.smtpProtocol)) {
                this.smtpProtocol = "smtp";
            }
            AbstractStringLayout.Serializer subjectSerializer = PatternLayout.newSerializerBuilder().setConfiguration(this.getConfiguration()).setPattern(this.subject).build();
            MailManager.FactoryData data = new MailManager.FactoryData(this.to, this.cc, this.bcc, this.from, this.replyTo, this.subject, subjectSerializer, this.smtpProtocol, this.smtpHost, this.smtpPort, this.smtpUsername, this.smtpPassword, this.smtpDebug, this.bufferSize, this.sslConfiguration, this.getFilter().toString());
            MailManagerFactory factory = ServiceLoaderUtil.loadServices(MailManagerFactory.class, (MethodHandles.Lookup)MethodHandles.lookup()).findAny().orElseGet(() -> SmtpManager.FACTORY);
            MailManager smtpManager = (MailManager)AbstractManager.getManager(data.getManagerName(), var2_2, data);
            if (smtpManager == null) {
                LOGGER.error("Unabled to instantiate SmtpAppender named {}", (Object)this.getName());
                return null;
            }
            return new SmtpAppender(this.getName(), this.getFilter(), this.getLayout(), (MailManager)var1_1, this.isIgnoreExceptions(), this.getPropertyArray());
        }
    }
}

