/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.Serializable;
import java.util.Objects;
import javax.script.Bindings;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.AppenderSet;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.script.AbstractScript;
import org.apache.logging.log4j.core.script.ScriptManager;

@Plugin(name="ScriptAppenderSelector", category="Core", elementType="appender", printObject=true)
public class ScriptAppenderSelector
extends AbstractAppender {
    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    /*
     * WARNING - void declaration
     */
    private ScriptAppenderSelector(String name, Filter filter, Layout<? extends Serializable> layout, Property[] properties) {
        super((String)var1_1, (Filter)var2_2, (Layout<? extends Serializable>)var3_3, true, Property.EMPTY_ARRAY);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    @Override
    public void append(LogEvent event) {
    }

    public static final class Builder
    implements org.apache.logging.log4j.core.util.Builder<Appender> {
        @PluginElement(value="AppenderSet")
        @Required
        private AppenderSet appenderSet;
        @PluginConfiguration
        @Required
        private Configuration configuration;
        @PluginBuilderAttribute
        @Required
        private String name;
        @PluginElement(value="Script")
        @Required
        private AbstractScript script;

        /*
         * WARNING - void declaration
         */
        @Override
        public final Appender build() {
            void var1_1;
            void var2_2;
            if (this.name == null) {
                LOGGER.error("Name missing.");
                return null;
            }
            if (this.script == null) {
                LOGGER.error("Script missing for ScriptAppenderSelector appender {}", (Object)this.name);
                return null;
            }
            if (this.appenderSet == null) {
                LOGGER.error("AppenderSet missing for ScriptAppenderSelector appender {}", (Object)this.name);
                return null;
            }
            if (this.configuration == null) {
                LOGGER.error("Configuration missing for ScriptAppenderSelector appender {}", (Object)this.name);
                return null;
            }
            Object scriptManager = this.configuration.getScriptManager();
            if (scriptManager == null) {
                LOGGER.error("Script support is not enabled");
                return null;
            }
            if (!((ScriptManager)scriptManager).addScript(this.script)) {
                return null;
            }
            Bindings bindings = ((ScriptManager)scriptManager).createBindings(this.script);
            LOGGER.debug("ScriptAppenderSelector '{}' executing {} '{}': {}", (Object)this.name, (Object)this.script.getLanguage(), (Object)this.script.getName(), (Object)this.script.getScriptText());
            scriptManager = ((ScriptManager)scriptManager).execute(this.script.getName(), (Bindings)var2_2);
            String actualAppenderName = Objects.toString(scriptManager, null);
            LOGGER.debug("ScriptAppenderSelector '{}' selected '{}'", (Object)this.name, (Object)actualAppenderName);
            return this.appenderSet.createAppender((String)var1_1, this.name);
        }

        public final AppenderSet getAppenderSet() {
            return this.appenderSet;
        }

        public final Configuration getConfiguration() {
            return this.configuration;
        }

        public final String getName() {
            return this.name;
        }

        public final AbstractScript getScript() {
            return this.script;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder withAppenderNodeSet(AppenderSet appenderSet) {
            void var1_1;
            this.appenderSet = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder withConfiguration(Configuration configuration) {
            void var1_1;
            this.configuration = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder withName(String name) {
            void var1_1;
            this.name = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder withScript(AbstractScript script) {
            void var1_1;
            this.script = var1_1;
            return this;
        }
    }
}

