/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.appender.ConfigurationFactoryData;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.util.FileUtils;
import org.apache.logging.log4j.core.util.NullOutputStream;

public class RandomAccessFileManager
extends OutputStreamManager {
    static final int DEFAULT_BUFFER_SIZE = 262144;
    private static final RandomAccessFileManagerFactory FACTORY = new RandomAccessFileManagerFactory();
    private final String advertiseURI;
    private final RandomAccessFile randomAccessFile;

    /*
     * WARNING - void declaration
     */
    protected RandomAccessFileManager(LoggerContext loggerContext, RandomAccessFile file, String fileName, OutputStream os, int bufferSize, String advertiseURI, Layout<? extends Serializable> layout, boolean writeHeader) {
        super((LoggerContext)var1_1, os, (String)var3_3, false, layout, writeHeader, ByteBuffer.wrap(new byte[bufferSize]));
        void var2_2;
        void var3_3;
        void var1_1;
        this.randomAccessFile = var2_2;
        this.advertiseURI = advertiseURI;
    }

    /*
     * WARNING - void declaration
     */
    public static RandomAccessFileManager getFileManager(String fileName, boolean append, boolean immediateFlush, int bufferSize, String advertiseURI, Layout<? extends Serializable> layout, Configuration configuration) {
        void var3_3;
        void var2_2;
        void var1_1;
        String string;
        return RandomAccessFileManager.narrow(RandomAccessFileManager.class, RandomAccessFileManager.getManager(string, new FactoryData((boolean)var1_1, (boolean)var2_2, (int)var3_3, advertiseURI, layout, configuration), FACTORY));
    }

    @Deprecated
    public Boolean isEndOfBatch() {
        return Boolean.FALSE;
    }

    @Deprecated
    public void setEndOfBatch(boolean endOfBatch) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void writeToDestination(byte[] bytes, int offset, int length) {
        try {
            void var3_5;
            this.randomAccessFile.write(bytes, offset, (int)var3_5);
            return;
        }
        catch (IOException ex) {
            void var1_2;
            void var2_4;
            String msg = "Error writing to RandomAccessFile " + this.getName();
            throw new AppenderLoggingException((String)var2_4, (Throwable)var1_2);
        }
    }

    @Override
    public synchronized void flush() {
        RandomAccessFileManager randomAccessFileManager = this;
        randomAccessFileManager.flushBuffer(randomAccessFileManager.byteBuffer);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized boolean closeOutputStream() {
        ((OutputStreamManager)this).flush();
        try {
            this.randomAccessFile.close();
            return true;
        }
        catch (IOException ex) {
            void var1_1;
            this.logError("Unable to close RandomAccessFile", (Throwable)var1_1);
            return false;
        }
    }

    public String getFileName() {
        return this.getName();
    }

    public int getBufferSize() {
        return this.byteBuffer.capacity();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map<String, String> getContentFormat() {
        void var1_1;
        HashMap<String, String> result = new HashMap<String, String>(super.getContentFormat());
        result.put("fileURI", this.advertiseURI);
        return var1_1;
    }

    private static class RandomAccessFileManagerFactory
    implements ManagerFactory<RandomAccessFileManager, FactoryData> {
        private RandomAccessFileManagerFactory() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public RandomAccessFileManager createManager(String name, FactoryData data) {
            File file = new File(name);
            if (!data.append) {
                file.delete();
            }
            boolean writeHeader = !data.append || !file.exists();
            NullOutputStream os = NullOutputStream.getInstance();
            try {
                void var3_4;
                FileUtils.makeParentDirs(file);
                RandomAccessFile raf = new RandomAccessFile(name, "rw");
                if (data.append) {
                    RandomAccessFile randomAccessFile = raf;
                    randomAccessFile.seek(randomAccessFile.length());
                } else {
                    raf.setLength(0L);
                }
                return new RandomAccessFileManager(data.getLoggerContext(), (RandomAccessFile)var3_4, name, os, data.bufferSize, data.advertiseURI, data.layout, writeHeader);
            }
            catch (Exception ex) {
                void var2_3;
                void var1_1;
                AbstractManager.LOGGER.error("RandomAccessFileManager (" + (String)var1_1 + ") " + ex, (Throwable)var2_3);
                return null;
            }
        }
    }

    private static class FactoryData
    extends ConfigurationFactoryData {
        private final boolean append;
        private final boolean immediateFlush;
        private final int bufferSize;
        private final String advertiseURI;
        private final Layout<? extends Serializable> layout;

        /*
         * WARNING - void declaration
         */
        public FactoryData(boolean append, boolean immediateFlush, int bufferSize, String advertiseURI, Layout<? extends Serializable> layout, Configuration configuration) {
            super(configuration);
            void var3_3;
            void var2_2;
            void var1_1;
            this.append = var1_1;
            this.immediateFlush = var2_2;
            this.bufferSize = var3_3;
            this.advertiseURI = advertiseURI;
            this.layout = layout;
        }
    }
}

