/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.RandomAccessFileManager;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.filter.AbstractFilterable;
import org.apache.logging.log4j.core.net.Advertiser;
import org.apache.logging.log4j.core.util.Booleans;
import org.apache.logging.log4j.core.util.Integers;

@Plugin(name="RandomAccessFile", category="Core", elementType="appender", printObject=true)
public final class RandomAccessFileAppender
extends AbstractOutputStreamAppender<RandomAccessFileManager> {
    private final String fileName;
    private Object advertisement;
    private final Advertiser advertiser;

    /*
     * WARNING - void declaration
     */
    private RandomAccessFileAppender(String name, Layout<? extends Serializable> layout, Filter filter, RandomAccessFileManager manager, String filename, boolean ignoreExceptions, boolean immediateFlush, Advertiser advertiser, Property[] properties) {
        super(name, layout, filter, ignoreExceptions, immediateFlush, properties, manager);
        if (advertiser != null) {
            void var3_3;
            void var1_1;
            void var2_2;
            HashMap<String, String> configuration = new HashMap<String, String>(layout.getContentFormat());
            configuration.putAll(((AbstractManager)manager).getContentFormat());
            configuration.put("contentType", var2_2.getContentType());
            configuration.put("name", (String)var1_1);
            this.advertisement = advertiser.advertise((Map<String, String>)var3_3);
        }
        this.fileName = filename;
        this.advertiser = advertiser;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean stop(long timeout, TimeUnit timeUnit) {
        void var3_2;
        void var1_1;
        this.setStopping();
        super.stop((long)var1_1, (TimeUnit)var3_2, false);
        if (this.advertiser != null) {
            this.advertiser.unadvertise(this.advertisement);
        }
        this.setStopped();
        return true;
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final int getBufferSize() {
        return ((RandomAccessFileManager)this.getManager()).getBufferSize();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static <B extends Builder<B>> RandomAccessFileAppender createAppender(String fileName, String append, String name, String immediateFlush, String bufferSizeStr, String ignore, Layout<? extends Serializable> layout, Filter filter, String advertise, String advertiseURI, Configuration configuration) {
        void var2_3;
        void var3_5;
        String string;
        void var1_2;
        boolean isAppend = Booleans.parseBoolean(append, true);
        boolean isFlush = Booleans.parseBoolean(immediateFlush, true);
        boolean ignoreExceptions = Booleans.parseBoolean(ignore, true);
        boolean isAdvertise = Boolean.parseBoolean(advertise);
        int bufferSize = Integers.parseInt(bufferSizeStr, 262144);
        return ((Builder)((Builder)((Builder)((Builder)((Builder)((AbstractFilterable.Builder)((Builder)((Builder)((AbstractOutputStreamAppender.Builder)((Builder)((Builder)((Builder)RandomAccessFileAppender.newBuilder()).setAdvertise(isAdvertise)).setAdvertiseURI(advertiseURI)).setAppend((boolean)var1_2)).withBufferSize(bufferSize)).setConfiguration(configuration)).setFileName(string)).setFilter(filter)).setIgnoreExceptions(ignoreExceptions)).withImmediateFlush((boolean)var3_5)).setLayout(layout)).setName((String)var2_3)).build();
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Builder)new Builder().asBuilder());
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractOutputStreamAppender.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<RandomAccessFileAppender> {
        @PluginBuilderAttribute(value="fileName")
        private String fileName;
        @PluginBuilderAttribute(value="append")
        private boolean append = true;
        @PluginBuilderAttribute(value="advertise")
        private boolean advertise;
        @PluginBuilderAttribute(value="advertiseURI")
        private String advertiseURI;

        public Builder() {
            this.withBufferSize(262144);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public RandomAccessFileAppender build() {
            void var3_3;
            void var2_2;
            void var1_1;
            String name = this.getName();
            if (name == null) {
                LOGGER.error("No name provided for RandomAccessFileAppender");
                return null;
            }
            if (this.fileName == null) {
                LOGGER.error("No filename provided for RandomAccessFileAppender with name {}", (Object)name);
                return null;
            }
            Layout<Serializable> layout = this.getOrCreateLayout();
            boolean immediateFlush = this.isImmediateFlush();
            RandomAccessFileManager manager = RandomAccessFileManager.getFileManager(this.fileName, this.append, immediateFlush, this.getBufferSize(), this.advertiseURI, layout, null);
            if (manager == null) {
                return null;
            }
            return new RandomAccessFileAppender((String)var1_1, (Layout)var2_2, this.getFilter(), manager, this.fileName, this.isIgnoreExceptions(), (boolean)var3_3, this.advertise ? this.getConfiguration().getAdvertiser() : null, this.getPropertyArray());
        }

        /*
         * WARNING - void declaration
         */
        public B setFileName(String fileName) {
            void var1_1;
            this.fileName = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setAppend(boolean append) {
            void var1_1;
            this.append = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setAdvertise(boolean advertise) {
            void var1_1;
            this.advertise = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setAdvertiseURI(String advertiseURI) {
            void var1_1;
            this.advertiseURI = var1_1;
            return (B)((Builder)this.asBuilder());
        }
    }
}

