/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.core.layout.ByteBufferDestinationHelper;
import org.apache.logging.log4j.core.util.Constants;

public class OutputStreamManager
extends AbstractManager
implements ByteBufferDestination {
    protected final Layout<?> layout;
    protected ByteBuffer byteBuffer;
    private volatile OutputStream outputStream;
    private boolean skipFooter;

    /*
     * WARNING - void declaration
     */
    protected OutputStreamManager(OutputStream os, String streamName, Layout<?> layout, boolean writeHeader) {
        this((OutputStream)var1_1, (String)var2_2, (Layout<?>)var3_3, writeHeader, Constants.ENCODER_BYTE_BUFFER_SIZE);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected OutputStreamManager(OutputStream os, String streamName, Layout<?> layout, boolean writeHeader, int bufferSize) {
        this((OutputStream)var1_1, (String)var2_2, (Layout<?>)var3_3, writeHeader, ByteBuffer.wrap(new byte[bufferSize]));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected OutputStreamManager(OutputStream os, String streamName, Layout<?> layout, boolean writeHeader, ByteBuffer byteBuffer) {
        super(null, (String)var2_2);
        void var3_3;
        void var2_2;
        this.outputStream = os;
        this.layout = var3_3;
        if (writeHeader) {
            void var1_1;
            this.writeHeader((OutputStream)var1_1);
        }
        this.byteBuffer = Objects.requireNonNull(byteBuffer, "byteBuffer");
    }

    /*
     * WARNING - void declaration
     */
    protected OutputStreamManager(LoggerContext loggerContext, OutputStream os, String streamName, boolean createOnDemand, Layout<? extends Serializable> layout, boolean writeHeader, ByteBuffer byteBuffer) {
        super((LoggerContext)var1_1, streamName);
        void var1_1;
        if (createOnDemand && os != null) {
            void var3_3;
            LOGGER.error("Invalid OutputStreamManager configuration for '{}': You cannot both set the OutputStream and request on-demand.", (Object)var3_3);
        }
        this.layout = layout;
        this.byteBuffer = Objects.requireNonNull(byteBuffer, "byteBuffer");
        this.outputStream = os;
        if (writeHeader) {
            void var2_2;
            this.writeHeader((OutputStream)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <T> OutputStreamManager getManager(String name, T data, ManagerFactory<? extends OutputStreamManager, T> factory) {
        void var1_1;
        void var2_2;
        return (OutputStreamManager)AbstractManager.getManager(name, var2_2, var1_1);
    }

    protected OutputStream createOutputStream() throws IOException {
        throw new IllegalStateException(this.getClass().getCanonicalName() + " must implement createOutputStream()");
    }

    /*
     * WARNING - void declaration
     */
    public void skipFooter(boolean skipFooter) {
        void var1_1;
        this.skipFooter = var1_1;
    }

    @Override
    public boolean releaseSub(long timeout, TimeUnit timeUnit) {
        this.writeFooter();
        return this.closeOutputStream();
    }

    /*
     * WARNING - void declaration
     */
    protected void writeHeader(OutputStream os) {
        byte[] header;
        if (this.layout != null && os != null && (header = this.layout.getHeader()) != null) {
            try {
                void var2_3;
                os.write(header, 0, ((void)var2_3).length);
                return;
            }
            catch (IOException e) {
                void var1_2;
                this.logError("Unable to write header", (Throwable)var1_2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void writeFooter() {
        if (this.layout == null || this.skipFooter) {
            return;
        }
        byte[] footer = this.layout.getFooter();
        if (footer != null) {
            void var1_1;
            this.write((byte[])var1_1);
        }
    }

    public boolean isOpen() {
        return this.getCount() > 0;
    }

    public boolean hasOutputStream() {
        return this.outputStream != null;
    }

    protected OutputStream getOutputStream() throws IOException {
        if (this.outputStream == null) {
            this.outputStream = this.createOutputStream();
        }
        return this.outputStream;
    }

    /*
     * WARNING - void declaration
     */
    protected void setOutputStream(OutputStream os) {
        void var1_1;
        this.outputStream = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected void write(byte[] bytes) {
        void var1_1;
        this.write(bytes, 0, ((void)var1_1).length, false);
    }

    /*
     * WARNING - void declaration
     */
    protected void write(byte[] bytes, boolean immediateFlush) {
        void var2_2;
        void var1_1;
        this.write(bytes, 0, ((void)var1_1).length, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeBytes(byte[] data, int offset, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.write((byte[])var1_1, (int)var2_2, (int)var3_3, false);
    }

    /*
     * WARNING - void declaration
     */
    protected void write(byte[] bytes, int offset, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.writeBytes((byte[])var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected synchronized void write(byte[] bytes, int offset, int length, boolean immediateFlush) {
        if (immediateFlush && this.byteBuffer.position() == 0) {
            this.writeToDestination(bytes, offset, length);
            this.flushDestination();
            return;
        }
        if (length >= this.byteBuffer.capacity()) {
            this.flush();
            this.writeToDestination(bytes, offset, length);
        } else {
            void var3_3;
            void var2_2;
            void var1_1;
            if (length > this.byteBuffer.remaining()) {
                this.flush();
            }
            this.byteBuffer.put((byte[])var1_1, (int)var2_2, (int)var3_3);
        }
        if (immediateFlush) {
            this.flush();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected synchronized void writeToDestination(byte[] bytes, int offset, int length) {
        try {
            void var3_4;
            void var2_3;
            this.getOutputStream().write(bytes, (int)var2_3, (int)var3_4);
            return;
        }
        catch (IOException ex) {
            void var1_2;
            throw new AppenderLoggingException("Error writing to stream " + this.getName(), (Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected synchronized void flushDestination() {
        OutputStream stream = this.outputStream;
        if (stream != null) {
            try {
                stream.flush();
                return;
            }
            catch (IOException ex) {
                void var1_2;
                throw new AppenderLoggingException("Error flushing stream " + this.getName(), (Throwable)var1_2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected synchronized void flushBuffer(ByteBuffer buf) {
        ((Buffer)buf).flip();
        try {
            if (buf.remaining() > 0) {
                this.writeToDestination(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining());
            }
            buf.clear();
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.clear();
            throw throwable;
        }
    }

    public synchronized void flush() {
        OutputStreamManager outputStreamManager = this;
        outputStreamManager.flushBuffer(outputStreamManager.byteBuffer);
        this.flushDestination();
    }

    /*
     * WARNING - void declaration
     */
    protected synchronized boolean closeOutputStream() {
        this.flush();
        OutputStream stream = this.outputStream;
        if (stream == null || stream == System.out || stream == System.err) {
            return true;
        }
        try {
            stream.close();
            LOGGER.debug("OutputStream closed");
        }
        catch (IOException ex) {
            void var1_2;
            this.logError("Unable to close stream", (Throwable)var1_2);
            return false;
        }
        return true;
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuffer drain(ByteBuffer buf) {
        void var1_1;
        this.flushBuffer(buf);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeBytes(ByteBuffer data) {
        if (data.remaining() == 0) {
            return;
        }
        OutputStreamManager outputStreamManager = this;
        synchronized (outputStreamManager) {
            void var1_1;
            ByteBufferDestinationHelper.writeToUnsynchronized((ByteBuffer)var1_1, this);
            return;
        }
    }
}

