/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.OutputStream;
import java.io.Serializable;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.util.CloseShieldOutputStream;
import org.apache.logging.log4j.core.util.NullOutputStream;

@Plugin(name="OutputStream", category="Core", elementType="appender", printObject=true)
public final class OutputStreamAppender
extends AbstractOutputStreamAppender<OutputStreamManager> {
    private static OutputStreamManagerFactory factory = new OutputStreamManagerFactory();

    /*
     * WARNING - void declaration
     */
    @PluginFactory
    public static OutputStreamAppender createAppender(Layout<? extends Serializable> layout, Filter filter, OutputStream target, String name, boolean follow, boolean ignore) {
        Layout<? extends Serializable> layout2;
        void var2_2;
        void var1_1;
        void var3_3;
        if (name == null) {
            LOGGER.error("No name provided for OutputStreamAppender");
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        return new OutputStreamAppender((String)var3_3, (Layout<? extends Serializable>)layout, (Filter)var1_1, OutputStreamAppender.getManager((OutputStream)var2_2, follow, layout2), ignore, null);
    }

    /*
     * WARNING - void declaration
     */
    private static OutputStreamManager getManager(OutputStream target, boolean follow, Layout<? extends Serializable> layout) {
        void var2_2;
        String string;
        void var3_3;
        void var1_1;
        String targetRef;
        OutputStream os = target == null ? NullOutputStream.getInstance() : new CloseShieldOutputStream(target);
        targetRef = target == null ? os : targetRef;
        String managerName = targetRef.getClass().getName() + "@" + Integer.toHexString(targetRef.hashCode()) + '.' + (boolean)var1_1;
        return OutputStreamManager.getManager(managerName, new FactoryData((OutputStream)var3_3, string, (Layout<? extends Serializable>)var2_2), factory);
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Builder)new Builder().asBuilder());
    }

    /*
     * WARNING - void declaration
     */
    private OutputStreamAppender(String name, Layout<? extends Serializable> layout, Filter filter, OutputStreamManager manager, boolean ignoreExceptions, Property[] properties) {
        super((String)var1_1, (Layout<? extends Serializable>)var2_2, (Filter)var3_3, ignoreExceptions, true, properties, manager);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ OutputStreamManager access$000(OutputStream x0, boolean x1, Layout x2) {
        void var2_2;
        void var1_1;
        return OutputStreamAppender.getManager(x0, (boolean)var1_1, (Layout<? extends Serializable>)var2_2);
    }

    private static class OutputStreamManagerFactory
    implements ManagerFactory<OutputStreamManager, FactoryData> {
        private OutputStreamManagerFactory() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public OutputStreamManager createManager(String name, FactoryData data) {
            void var2_2;
            return new OutputStreamManager(data.os, data.name, ((FactoryData)var2_2).layout, true);
        }
    }

    private static class FactoryData {
        private final Layout<? extends Serializable> layout;
        private final String name;
        private final OutputStream os;

        /*
         * WARNING - void declaration
         */
        public FactoryData(OutputStream os, String type, Layout<? extends Serializable> layout) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.os = var1_1;
            this.name = var2_2;
            this.layout = var3_3;
        }
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractOutputStreamAppender.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<OutputStreamAppender> {
        private boolean follow = false;
        private final boolean ignoreExceptions = true;
        private OutputStream target;

        /*
         * WARNING - void declaration
         */
        @Override
        public OutputStreamAppender build() {
            void var1_1;
            Layout<Serializable> layout = this.getOrCreateLayout();
            return new OutputStreamAppender(this.getName(), layout, this.getFilter(), OutputStreamAppender.access$000(this.target, this.follow, (Layout)var1_1), true, this.getPropertyArray());
        }

        /*
         * WARNING - void declaration
         */
        public B setFollow(boolean shouldFollow) {
            void var1_1;
            this.follow = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setTarget(OutputStream aTarget) {
            void var1_1;
            this.target = var1_1;
            return (B)((Builder)this.asBuilder());
        }
    }
}

