/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.MemoryMappedFileManager;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.filter.AbstractFilterable;
import org.apache.logging.log4j.core.net.Advertiser;
import org.apache.logging.log4j.core.util.Booleans;
import org.apache.logging.log4j.core.util.Integers;

@Plugin(name="MemoryMappedFile", category="Core", elementType="appender", printObject=true)
public final class MemoryMappedFileAppender
extends AbstractOutputStreamAppender<MemoryMappedFileManager> {
    private static final int BIT_POSITION_1GB = 30;
    private static final int MAX_REGION_LENGTH = 0x40000000;
    private static final int MIN_REGION_LENGTH = 256;
    private final String fileName;
    private Object advertisement;
    private final Advertiser advertiser;

    /*
     * WARNING - void declaration
     */
    private MemoryMappedFileAppender(String name, Layout<? extends Serializable> layout, Filter filter, MemoryMappedFileManager manager, String filename, boolean ignoreExceptions, boolean immediateFlush, Advertiser advertiser, Property[] properties) {
        super(name, layout, filter, ignoreExceptions, immediateFlush, properties, manager);
        if (advertiser != null) {
            void var3_3;
            void var1_1;
            void var2_2;
            HashMap<String, String> configuration = new HashMap<String, String>(layout.getContentFormat());
            configuration.putAll(((AbstractManager)manager).getContentFormat());
            configuration.put("contentType", var2_2.getContentType());
            configuration.put("name", (String)var1_1);
            this.advertisement = advertiser.advertise((Map<String, String>)var3_3);
        }
        this.fileName = filename;
        this.advertiser = advertiser;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean stop(long timeout, TimeUnit timeUnit) {
        void var3_2;
        void var1_1;
        this.setStopping();
        super.stop((long)var1_1, (TimeUnit)var3_2, false);
        if (this.advertiser != null) {
            this.advertiser.unadvertise(this.advertisement);
        }
        this.setStopped();
        return true;
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final int getRegionLength() {
        return ((MemoryMappedFileManager)this.getManager()).getRegionLength();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static <B extends Builder<B>> MemoryMappedFileAppender createAppender(String fileName, String append, String name, String immediateFlush, String regionLengthStr, String ignore, Layout<? extends Serializable> layout, Filter filter, String advertise, String advertiseURI, Configuration config) {
        void var2_3;
        void var3_5;
        String string;
        void var1_2;
        boolean isAppend = Booleans.parseBoolean(append, true);
        boolean isImmediateFlush = Booleans.parseBoolean(immediateFlush, false);
        boolean ignoreExceptions = Booleans.parseBoolean(ignore, true);
        boolean isAdvertise = Boolean.parseBoolean(advertise);
        int regionLength = Integers.parseInt(regionLengthStr, 0x2000000);
        return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((AbstractFilterable.Builder)((Builder)((AbstractAppender.Builder)((Builder)((Builder)((Builder)MemoryMappedFileAppender.newBuilder()).setAdvertise(isAdvertise)).setAdvertiseURI(advertiseURI)).setAppend((boolean)var1_2)).setConfiguration(config)).setFileName(string)).setFilter(filter)).setIgnoreExceptions(ignoreExceptions)).withImmediateFlush((boolean)var3_5)).setLayout(layout)).setName((String)var2_3)).setRegionLength(regionLength)).build();
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Builder)new Builder().asBuilder());
    }

    /*
     * WARNING - void declaration
     */
    private static int determineValidRegionLength(String name, int regionLength) {
        void var2_2;
        if (regionLength > 0x40000000) {
            LOGGER.info("MemoryMappedAppender[{}] Reduced region length from {} to max length: {}", (Object)name, (Object)regionLength, (Object)0x40000000);
            return 0x40000000;
        }
        if (regionLength < 256) {
            LOGGER.info("MemoryMappedAppender[{}] Expanded region length from {} to min length: {}", (Object)name, (Object)regionLength, (Object)256);
            return 256;
        }
        int result = Integers.ceilingNextPowerOfTwo(regionLength);
        if (regionLength != result) {
            void var1_1;
            String string;
            LOGGER.info("MemoryMappedAppender[{}] Rounded up region length from {} to next power of two: {}", (Object)string, (Object)((int)var1_1), (Object)result);
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$000(String x0, int x1) {
        void var1_1;
        return MemoryMappedFileAppender.determineValidRegionLength(x0, (int)var1_1);
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractOutputStreamAppender.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<MemoryMappedFileAppender> {
        @PluginBuilderAttribute(value="fileName")
        private String fileName;
        @PluginBuilderAttribute(value="append")
        private boolean append = true;
        @PluginBuilderAttribute(value="regionLength")
        private int regionLength = 0x2000000;
        @PluginBuilderAttribute(value="advertise")
        private boolean advertise;
        @PluginBuilderAttribute(value="advertiseURI")
        private String advertiseURI;

        /*
         * WARNING - void declaration
         */
        @Override
        public MemoryMappedFileAppender build() {
            void var2_3;
            void var3_4;
            void var1_1;
            String name = this.getName();
            int actualRegionLength = MemoryMappedFileAppender.access$000(name, this.regionLength);
            if (name == null) {
                LOGGER.error("No name provided for MemoryMappedFileAppender");
                return null;
            }
            if (this.fileName == null) {
                LOGGER.error("No filename provided for MemoryMappedFileAppender with name " + name);
                return null;
            }
            Layout<Serializable> layout = this.getOrCreateLayout();
            MemoryMappedFileManager manager = MemoryMappedFileManager.getFileManager(this.fileName, this.append, this.isImmediateFlush(), actualRegionLength, this.advertiseURI, layout);
            if (manager == null) {
                return null;
            }
            return new MemoryMappedFileAppender((String)var1_1, (Layout)var3_4, this.getFilter(), (MemoryMappedFileManager)var2_3, this.fileName, this.isIgnoreExceptions(), false, this.advertise ? this.getConfiguration().getAdvertiser() : null, this.getPropertyArray());
        }

        /*
         * WARNING - void declaration
         */
        public B setFileName(String fileName) {
            void var1_1;
            this.fileName = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setAppend(boolean append) {
            void var1_1;
            this.append = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setRegionLength(int regionLength) {
            void var1_1;
            this.regionLength = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setAdvertise(boolean advertise) {
            void var1_1;
            this.advertise = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setAdvertiseURI(String advertiseURI) {
            void var1_1;
            this.advertiseURI = var1_1;
            return (B)((Builder)this.asBuilder());
        }
    }
}

