/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Objects;
import javax.net.ssl.HttpsURLConnection;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.HttpManager;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.net.ssl.LaxHostnameVerifier;
import org.apache.logging.log4j.core.net.ssl.SslConfiguration;

public class HttpURLConnectionManager
extends HttpManager {
    private static final Charset CHARSET = Charset.forName("US-ASCII");
    private final URL url;
    private final boolean isHttps;
    private final String method;
    private final int connectTimeoutMillis;
    private final int readTimeoutMillis;
    private final Property[] headers;
    private final SslConfiguration sslConfiguration;
    private final boolean verifyHostname;

    /*
     * WARNING - void declaration
     */
    public HttpURLConnectionManager(Configuration configuration, LoggerContext loggerContext, String name, URL url, String method, int connectTimeoutMillis, int readTimeoutMillis, Property[] headers, SslConfiguration sslConfiguration, boolean verifyHostname) {
        super((Configuration)var1_1, (LoggerContext)var2_2, (String)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
        this.url = url;
        if (!url.getProtocol().equalsIgnoreCase("http") && !url.getProtocol().equalsIgnoreCase("https")) {
            throw new ConfigurationException("URL must have scheme http or https");
        }
        this.isHttps = this.url.getProtocol().equalsIgnoreCase("https");
        this.method = Objects.requireNonNull(method, "method");
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.readTimeoutMillis = readTimeoutMillis;
        this.headers = headers != null ? headers : Property.EMPTY_ARRAY;
        this.sslConfiguration = sslConfiguration;
        if (this.sslConfiguration != null && !this.isHttps) {
            throw new ConfigurationException("SSL configuration can only be specified with URL scheme https");
        }
        this.verifyHostname = verifyHostname;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void send(Layout<?> layout2, LogEvent event) throws IOException {
        Throwable throwable;
        Object header;
        HttpURLConnection urlConnection2;
        block33: {
            urlConnection2 = (HttpURLConnection)this.url.openConnection();
            urlConnection2.setAllowUserInteraction(false);
            urlConnection2.setDoOutput(true);
            urlConnection2.setDoInput(true);
            urlConnection2.setRequestMethod(this.method);
            if (this.connectTimeoutMillis > 0) {
                urlConnection2.setConnectTimeout(this.connectTimeoutMillis);
            }
            if (this.readTimeoutMillis > 0) {
                urlConnection2.setReadTimeout(this.readTimeoutMillis);
            }
            if (layout2.getContentType() != null) {
                urlConnection2.setRequestProperty("Content-Type", layout2.getContentType());
            }
            Property[] propertyArray = this.headers;
            int n = this.headers.length;
            for (int i = 0; i < n; ++i) {
                header = propertyArray[i];
                urlConnection2.setRequestProperty(((Property)header).getName(), ((Property)header).evaluate(this.getConfiguration().getStrSubstitutor()));
            }
            if (this.sslConfiguration != null) {
                ((HttpsURLConnection)urlConnection2).setSSLSocketFactory(this.sslConfiguration.getSslSocketFactory());
            }
            if (this.isHttps && !this.verifyHostname) {
                ((HttpsURLConnection)urlConnection2).setHostnameVerifier(LaxHostnameVerifier.INSTANCE);
            }
            byte[] byArray = layout2.toByteArray((LogEvent)((Object)throwable));
            urlConnection2.setFixedLengthStreamingMode(byArray.length);
            urlConnection2.connect();
            OutputStream os = urlConnection2.getOutputStream();
            Throwable throwable2 = null;
            try {
                os.write(byArray);
                if (os == null) break block33;
            }
            catch (Throwable throwable3) {
                try {
                    header = throwable3;
                    throwable2 = throwable3;
                    throw header;
                }
                catch (Throwable layout2) {
                    if (os == null) throw layout2;
                    if (throwable2 == null) {
                        os.close();
                        throw layout2;
                    }
                    try {
                        os.close();
                        throw layout2;
                    }
                    catch (Throwable throwable4) {
                        throwable2.addSuppressed(throwable4);
                        throw layout2;
                    }
                }
            }
            os.close();
        }
        byte[] buffer = new byte[1024];
        try {
            InputStream is = urlConnection2.getInputStream();
            header = null;
            try {
                while (-1 != is.read(buffer)) {
                }
                if (is == null) return;
            }
            catch (Throwable throwable5) {
                try {
                    Object layout2 = throwable5;
                    header = throwable5;
                    throw layout2;
                }
                catch (Throwable throwable6) {
                    if (is == null) throw throwable6;
                    if (header == null) {
                        is.close();
                        throw throwable6;
                    }
                    try {
                        is.close();
                        throw throwable6;
                    }
                    catch (Throwable layout2) {
                        ((Throwable)header).addSuppressed(layout2);
                        throw throwable6;
                    }
                }
            }
            is.close();
            return;
        }
        catch (IOException e) {
            void var3_7;
            StringBuilder errorMessage;
            block34: {
                errorMessage = new StringBuilder();
                InputStream es2 = urlConnection2.getErrorStream();
                throwable = null;
                try {
                    errorMessage.append(urlConnection2.getResponseCode());
                    if (urlConnection2.getResponseMessage() != null) {
                        errorMessage.append(' ').append(urlConnection2.getResponseMessage());
                    }
                    if (es2 != null) {
                        int n;
                        errorMessage.append(" - ");
                        while (-1 != (n = es2.read(buffer))) {
                            errorMessage.append(new String(buffer, 0, n, CHARSET));
                        }
                    }
                    if (es2 == null) break block34;
                }
                catch (Throwable throwable7) {
                    try {
                        Throwable throwable8 = throwable7;
                        throwable = throwable7;
                        throw throwable8;
                    }
                    catch (Throwable urlConnection2) {
                        if (es2 == null) throw urlConnection2;
                        if (throwable == null) {
                            void var1_1;
                            var1_1.close();
                            throw urlConnection2;
                        }
                        try {
                            es2.close();
                            throw urlConnection2;
                        }
                        catch (Throwable es2) {
                            throwable.addSuppressed(es2);
                            throw urlConnection2;
                        }
                    }
                }
                es2.close();
            }
            if (var3_7.getResponseCode() < 0) throw e;
            throw new IOException(errorMessage.toString());
        }
    }
}

