/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.Serializable;
import java.net.URL;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.HttpManager;
import org.apache.logging.log4j.core.appender.HttpURLConnectionManager;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.net.ssl.SslConfiguration;

@Plugin(name="Http", category="Core", elementType="appender", printObject=true)
public final class HttpAppender
extends AbstractAppender {
    private final HttpManager manager;

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Builder)new Builder().asBuilder());
    }

    /*
     * WARNING - void declaration
     */
    private HttpAppender(String name, Layout<? extends Serializable> layout, Filter filter, boolean ignoreExceptions, HttpManager manager, Property[] properties) {
        super((String)var1_1, (Filter)var3_3, layout, ignoreExceptions, properties);
        void var2_2;
        void var3_3;
        void var1_1;
        Objects.requireNonNull(var2_2, "layout");
        this.manager = Objects.requireNonNull(manager, "manager");
    }

    @Override
    public final void start() {
        super.start();
        this.manager.startup();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void append(LogEvent event) {
        try {
            this.manager.send(this.getLayout(), event);
            return;
        }
        catch (Exception e) {
            void var2_2;
            void var1_1;
            this.error("Unable to send HTTP in appender [" + this.getName() + "]", (LogEvent)var1_1, (Throwable)var2_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean stop(long timeout, TimeUnit timeUnit) {
        void var3_2;
        void var1_1;
        this.setStopping();
        boolean bl = super.stop(timeout, timeUnit, false);
        boolean stopped = bl & this.manager.stop((long)var1_1, (TimeUnit)var3_2);
        this.setStopped();
        return stopped;
    }

    @Override
    public final String toString() {
        return "HttpAppender{name=" + this.getName() + ", state=" + (Object)((Object)this.getState()) + '}';
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractAppender.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<HttpAppender> {
        @PluginBuilderAttribute
        @Required(message="No URL provided for HttpAppender")
        private URL url;
        @PluginBuilderAttribute
        private String method = "POST";
        @PluginBuilderAttribute
        private int connectTimeoutMillis = 0;
        @PluginBuilderAttribute
        private int readTimeoutMillis = 0;
        @PluginElement(value="Headers")
        private Property[] headers;
        @PluginElement(value="SslConfiguration")
        private SslConfiguration sslConfiguration;
        @PluginBuilderAttribute
        private boolean verifyHostname = true;

        /*
         * WARNING - void declaration
         */
        @Override
        public HttpAppender build() {
            void var1_1;
            HttpURLConnectionManager httpManager = new HttpURLConnectionManager(this.getConfiguration(), this.getConfiguration().getLoggerContext(), this.getName(), this.url, this.method, this.connectTimeoutMillis, this.readTimeoutMillis, this.headers, this.sslConfiguration, this.verifyHostname);
            return new HttpAppender(this.getName(), this.getLayout(), this.getFilter(), this.isIgnoreExceptions(), (HttpManager)var1_1, this.getPropertyArray());
        }

        public URL getUrl() {
            return this.url;
        }

        public String getMethod() {
            return this.method;
        }

        public int getConnectTimeoutMillis() {
            return this.connectTimeoutMillis;
        }

        public int getReadTimeoutMillis() {
            return this.readTimeoutMillis;
        }

        public Property[] getHeaders() {
            return this.headers;
        }

        public SslConfiguration getSslConfiguration() {
            return this.sslConfiguration;
        }

        public boolean isVerifyHostname() {
            return this.verifyHostname;
        }

        /*
         * WARNING - void declaration
         */
        public B setUrl(URL url) {
            void var1_1;
            this.url = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setMethod(String method) {
            void var1_1;
            this.method = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setConnectTimeoutMillis(int connectTimeoutMillis) {
            void var1_1;
            this.connectTimeoutMillis = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setReadTimeoutMillis(int readTimeoutMillis) {
            void var1_1;
            this.readTimeoutMillis = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setHeaders(Property[] headers) {
            void var1_1;
            this.headers = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setSslConfiguration(SslConfiguration sslConfiguration) {
            void var1_1;
            this.sslConfiguration = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setVerifyHostname(boolean verifyHostname) {
            void var1_1;
            this.verifyHostname = var1_1;
            return (B)((Builder)this.asBuilder());
        }
    }
}

