/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.appender.ConfigurationFactoryData;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.util.Constants;
import org.apache.logging.log4j.core.util.FileUtils;

public class FileManager
extends OutputStreamManager {
    private static final FileManagerFactory FACTORY = new FileManagerFactory();
    private final boolean isAppend;
    private final boolean createOnDemand;
    private final boolean isLocking;
    private final String advertiseURI;
    private final int bufferSize;
    private final Set<PosixFilePermission> filePermissions;
    private final String fileOwner;
    private final String fileGroup;
    private final boolean attributeViewEnabled;

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected FileManager(String fileName, OutputStream os, boolean append, boolean locking, String advertiseURI, Layout<? extends Serializable> layout, int bufferSize, boolean writeHeader) {
        this((String)var1_1, (OutputStream)var2_2, (boolean)var3_3, locking, advertiseURI, layout, writeHeader, ByteBuffer.wrap(new byte[bufferSize]));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected FileManager(String fileName, OutputStream os, boolean append, boolean locking, String advertiseURI, Layout<? extends Serializable> layout, boolean writeHeader, ByteBuffer buffer) {
        super((OutputStream)var2_2, (String)var1_1, layout, writeHeader, buffer);
        void var3_3;
        void var1_1;
        void var2_2;
        this.isAppend = var3_3;
        this.createOnDemand = false;
        this.isLocking = locking;
        this.advertiseURI = advertiseURI;
        this.bufferSize = buffer.capacity();
        this.filePermissions = null;
        this.fileOwner = null;
        this.fileGroup = null;
        this.attributeViewEnabled = false;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected FileManager(LoggerContext loggerContext, String fileName, OutputStream os, boolean append, boolean locking, boolean createOnDemand, String advertiseURI, Layout<? extends Serializable> layout, boolean writeHeader, ByteBuffer buffer) {
        super((LoggerContext)var1_1, (OutputStream)var3_3, (String)var2_2, createOnDemand, layout, writeHeader, buffer);
        void var2_2;
        void var3_3;
        void var1_1;
        this.isAppend = append;
        this.createOnDemand = createOnDemand;
        this.isLocking = locking;
        this.advertiseURI = advertiseURI;
        this.bufferSize = buffer.capacity();
        this.filePermissions = null;
        this.fileOwner = null;
        this.fileGroup = null;
        this.attributeViewEnabled = false;
    }

    /*
     * WARNING - void declaration
     */
    protected FileManager(LoggerContext loggerContext, String fileName, OutputStream os, boolean append, boolean locking, boolean createOnDemand, String advertiseURI, Layout<? extends Serializable> layout, String filePermissions, String fileOwner, String fileGroup, boolean writeHeader, ByteBuffer buffer) {
        super(loggerContext, (OutputStream)var3_3, (String)var2_2, createOnDemand, layout, writeHeader, buffer);
        void var1_1;
        void var2_2;
        void var3_3;
        this.isAppend = append;
        this.createOnDemand = createOnDemand;
        this.isLocking = locking;
        this.advertiseURI = advertiseURI;
        this.bufferSize = buffer.capacity();
        Set<String> views = FileSystems.getDefault().supportedFileAttributeViews();
        if (views.contains("posix")) {
            this.filePermissions = filePermissions != null ? PosixFilePermissions.fromString(filePermissions) : null;
            this.fileGroup = fileGroup;
        } else {
            this.filePermissions = null;
            this.fileGroup = null;
            if (filePermissions != null) {
                LOGGER.warn("Posix file attribute permissions defined but it is not supported by this files system.");
            }
            if (fileGroup != null) {
                LOGGER.warn("Posix file attribute group defined but it is not supported by this files system.");
            }
        }
        if (var1_1.contains("owner")) {
            this.fileOwner = fileOwner;
        } else {
            this.fileOwner = null;
            if (fileOwner != null) {
                LOGGER.warn("Owner file attribute defined but it is not supported by this files system.");
            }
        }
        this.attributeViewEnabled = this.filePermissions != null || this.fileOwner != null || this.fileGroup != null;
    }

    /*
     * WARNING - void declaration
     */
    public static FileManager getFileManager(String fileName, boolean append, boolean locking, boolean bufferedIo, boolean createOnDemand, String advertiseUri, Layout<? extends Serializable> layout, int bufferSize, String filePermissions, String fileOwner, String fileGroup, Configuration configuration) {
        void var3_3;
        void var2_2;
        void var1_1;
        String string;
        if (locking && bufferedIo) {
            locking = false;
        }
        return FileManager.narrow(FileManager.class, FileManager.getManager(string, new FactoryData((boolean)var1_1, (boolean)var2_2, (boolean)var3_3, bufferSize, createOnDemand, advertiseUri, layout, filePermissions, fileOwner, fileGroup, configuration), FACTORY));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected OutputStream createOutputStream() throws IOException {
        void var3_3;
        void var1_1;
        String filename = this.getFileName();
        LOGGER.debug("Now writing to {} at {}", (Object)filename, (Object)new Date());
        File file = new File(filename);
        this.createParentDir(file);
        FileOutputStream fos = new FileOutputStream(file, this.isAppend);
        if (file.exists() && file.length() == 0L) {
            try {
                void var2_2;
                FileTime now = FileTime.fromMillis(System.currentTimeMillis());
                Files.setAttribute(var2_2.toPath(), "creationTime", now, new LinkOption[0]);
            }
            catch (Exception exception) {
                LOGGER.warn("Unable to set current file time for {}", (Object)filename);
            }
            this.writeHeader(fos);
        }
        this.defineAttributeView(Paths.get((String)var1_1, new String[0]));
        return var3_3;
    }

    protected void createParentDir(File file) {
    }

    /*
     * WARNING - void declaration
     */
    protected void defineAttributeView(Path path) {
        if (this.attributeViewEnabled) {
            try {
                path.toFile().createNewFile();
                FileUtils.defineFilePosixAttributeView(path, this.filePermissions, this.fileOwner, this.fileGroup);
                return;
            }
            catch (Exception e) {
                void var2_2;
                void var1_1;
                LOGGER.error("Could not define attribute view on path \"{}\" got {}", (Object)var1_1, (Object)e.getMessage(), (Object)var2_2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected synchronized void write(byte[] bytes2, int offset2, int length, boolean immediateFlush) {
        void var3_5;
        void var2_3;
        void var1_1;
        block12: {
            if (!this.isLocking) break block12;
            try {
                FileLock lock;
                block13: {
                    block11: {
                        FileChannel fileChannel = ((FileOutputStream)this.getOutputStream()).getChannel();
                        lock = fileChannel.lock(0L, Long.MAX_VALUE, false);
                        Throwable throwable = null;
                        try {
                            super.write((byte[])bytes2, offset2, length, immediateFlush);
                            if (lock == null) break block11;
                        }
                        catch (Throwable throwable2) {
                            try {
                                bytes2 = throwable2;
                                throwable = throwable2;
                                throw bytes2;
                            }
                            catch (Throwable bytes2) {
                                if (lock != null) {
                                    if (throwable != null) {
                                        try {
                                            lock.close();
                                        }
                                        catch (Throwable offset2) {
                                            throwable.addSuppressed(offset2);
                                        }
                                    } else {
                                        lock.close();
                                    }
                                }
                                throw bytes2;
                            }
                        }
                        break block13;
                    }
                    return;
                }
                lock.close();
            }
            catch (IOException ex) {
                throw new AppenderLoggingException("Unable to obtain lock on " + this.getName(), ex);
            }
        }
        super.write((byte[])var1_1, (int)var2_3, (int)var3_5, immediateFlush);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected synchronized void writeToDestination(byte[] bytes2, int offset2, int length) {
        void var3_5;
        void var2_3;
        void var1_1;
        block12: {
            if (!this.isLocking) break block12;
            try {
                FileLock lock;
                block13: {
                    block11: {
                        FileChannel fileChannel = ((FileOutputStream)this.getOutputStream()).getChannel();
                        lock = fileChannel.lock(0L, Long.MAX_VALUE, false);
                        Throwable throwable = null;
                        try {
                            super.writeToDestination((byte[])bytes2, offset2, length);
                            if (lock == null) break block11;
                        }
                        catch (Throwable throwable2) {
                            try {
                                bytes2 = throwable2;
                                throwable = throwable2;
                                throw bytes2;
                            }
                            catch (Throwable bytes2) {
                                if (lock != null) {
                                    if (throwable != null) {
                                        try {
                                            lock.close();
                                        }
                                        catch (Throwable offset2) {
                                            throwable.addSuppressed(offset2);
                                        }
                                    } else {
                                        lock.close();
                                    }
                                }
                                throw bytes2;
                            }
                        }
                        break block13;
                    }
                    return;
                }
                lock.close();
            }
            catch (IOException ex) {
                throw new AppenderLoggingException("Unable to obtain lock on " + this.getName(), ex);
            }
        }
        super.writeToDestination((byte[])var1_1, (int)var2_3, (int)var3_5);
    }

    public String getFileName() {
        return this.getName();
    }

    public boolean isAppend() {
        return this.isAppend;
    }

    public boolean isCreateOnDemand() {
        return this.createOnDemand;
    }

    public boolean isLocking() {
        return this.isLocking;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public Set<PosixFilePermission> getFilePermissions() {
        return this.filePermissions;
    }

    public String getFileOwner() {
        return this.fileOwner;
    }

    public String getFileGroup() {
        return this.fileGroup;
    }

    public boolean isAttributeViewEnabled() {
        return this.attributeViewEnabled;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map<String, String> getContentFormat() {
        void var1_1;
        HashMap<String, String> result = new HashMap<String, String>(super.getContentFormat());
        result.put("fileURI", this.advertiseURI);
        return var1_1;
    }

    private static class FileManagerFactory
    implements ManagerFactory<FileManager, FactoryData> {
        private FileManagerFactory() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public FileManager createManager(String name, FactoryData data) {
            Objects.requireNonNull(name, "filename is missing");
            File file = new File(name);
            try {
                void var2_2;
                FileUtils.makeParentDirs(file);
                boolean writeHeader = !data.append || !file.exists();
                int n = data.bufferedIo ? data.bufferSize : Constants.ENCODER_BYTE_BUFFER_SIZE;
                ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[n]);
                FileOutputStream fos = data.createOnDemand ? null : new FileOutputStream(file, data.append);
                FileManager fm = new FileManager(data.getLoggerContext(), name, fos, data.append, data.locking, data.createOnDemand, data.advertiseURI, data.layout, data.filePermissions, data.fileOwner, data.fileGroup, writeHeader, byteBuffer);
                if (fos != null && fm.attributeViewEnabled) {
                    void var3_3;
                    fm.defineAttributeView(var3_3.toPath());
                }
                return var2_2;
            }
            catch (IOException ex) {
                void var1_1;
                AbstractManager.LOGGER.error("FileManager (" + (String)var1_1 + ") " + ex, (Throwable)ex);
                return null;
            }
        }
    }

    private static class FactoryData
    extends ConfigurationFactoryData {
        private final boolean append;
        private final boolean locking;
        private final boolean bufferedIo;
        private final int bufferSize;
        private final boolean createOnDemand;
        private final String advertiseURI;
        private final Layout<? extends Serializable> layout;
        private final String filePermissions;
        private final String fileOwner;
        private final String fileGroup;

        /*
         * WARNING - void declaration
         */
        public FactoryData(boolean append, boolean locking, boolean bufferedIo, int bufferSize, boolean createOnDemand, String advertiseURI, Layout<? extends Serializable> layout, String filePermissions, String fileOwner, String fileGroup, Configuration configuration) {
            super(configuration);
            void var3_3;
            void var2_2;
            void var1_1;
            this.append = var1_1;
            this.locking = var2_2;
            this.bufferedIo = var3_3;
            this.bufferSize = bufferSize;
            this.createOnDemand = createOnDemand;
            this.advertiseURI = advertiseURI;
            this.layout = layout;
            this.filePermissions = filePermissions;
            this.fileOwner = fileOwner;
            this.fileGroup = fileGroup;
        }
    }
}

