/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LoggingException;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.AppenderControl;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAliases;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.util.Booleans;

@Plugin(name="Failover", category="Core", elementType="appender", printObject=true)
public final class FailoverAppender
extends AbstractAppender {
    private static final int DEFAULT_INTERVAL_SECONDS = 60;
    private final String primaryRef;
    private final String[] failovers;
    private final Configuration config;
    private AppenderControl primary;
    private final List<AppenderControl> failoverAppenders = new ArrayList<AppenderControl>();
    private final long intervalNanos;
    private volatile long nextCheckNanos;

    /*
     * WARNING - void declaration
     */
    private FailoverAppender(String name, Filter filter, String primary, String[] failovers, int intervalMillis, Configuration config, boolean ignoreExceptions, Property[] properties) {
        super((String)var1_1, (Filter)var2_2, null, ignoreExceptions, properties);
        void var3_3;
        void var2_2;
        void var1_1;
        this.primaryRef = var3_3;
        this.failovers = failovers;
        this.config = config;
        this.intervalNanos = TimeUnit.MILLISECONDS.toNanos(intervalMillis);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void start() {
        void var2_2;
        String[] stringArray;
        Map<String, Appender> map = this.config.getAppenders();
        int errors = 0;
        Appender appender = map.get(this.primaryRef);
        if (appender != null) {
            this.primary = new AppenderControl((Appender)stringArray, null, null);
        } else {
            LOGGER.error("Unable to locate primary Appender " + this.primaryRef);
            ++errors;
        }
        stringArray = this.failovers;
        int n = this.failovers.length;
        for (int i = 0; i < n; ++i) {
            String name = stringArray[i];
            Appender foAppender = map.get(name);
            if (foAppender != null) {
                this.failoverAppenders.add(new AppenderControl(foAppender, null, null));
                continue;
            }
            LOGGER.error("Failover appender " + name + " is not configured");
        }
        if (this.failoverAppenders.isEmpty()) {
            LOGGER.error("No failover appenders are available");
            ++errors;
        }
        if (var2_2 == false) {
            super.start();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void append(LogEvent event) {
        void var1_1;
        void var2_2;
        if (!this.isStarted()) {
            this.error("FailoverAppender " + this.getName() + " did not start successfully");
            return;
        }
        long localCheckNanos = this.nextCheckNanos;
        if (localCheckNanos == 0L || System.nanoTime() - var2_2 > 0L) {
            this.callAppender(event);
            return;
        }
        this.failover((LogEvent)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    private void callAppender(LogEvent event) {
        try {
            this.primary.callAppender(event);
            this.nextCheckNanos = 0L;
            return;
        }
        catch (Exception ex) {
            void var2_2;
            void var1_1;
            this.nextCheckNanos = System.nanoTime() + this.intervalNanos;
            this.failover((LogEvent)var1_1, (Exception)var2_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void failover(LogEvent event, Exception ex) {
        void var3_3;
        LoggingException re = ex != null ? (ex instanceof LoggingException ? (LoggingException)ex : new LoggingException((Throwable)ex)) : null;
        boolean written = false;
        Exception failoverException = null;
        for (AppenderControl control : this.failoverAppenders) {
            try {
                control.callAppender(event);
                written = true;
                break;
            }
            catch (Exception fex) {
                if (failoverException != null) continue;
                failoverException = fex;
            }
        }
        if (var3_3 == false && !this.ignoreExceptions()) {
            if (re != null) {
                void var2_2;
                throw var2_2;
            }
            throw new LoggingException("Unable to write to failover appenders", (Throwable)failoverException);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String toString() {
        void var1_1;
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append(" primary=").append(this.primary).append(", failover={");
        boolean first = true;
        String[] stringArray = this.failovers;
        int n = this.failovers.length;
        for (int i = 0; i < n; ++i) {
            String str = stringArray[i];
            if (!first) {
                sb.append(", ");
            }
            sb.append(str);
            first = false;
        }
        sb.append('}');
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    @PluginFactory
    public static FailoverAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="primary") String primary, @PluginElement(value="Failovers") String[] failovers, @PluginAliases(value={"retryInterval"}) @PluginAttribute(value="retryIntervalSeconds") String retryIntervalSeconds, @PluginConfiguration Configuration config, @PluginElement(value="Filter") Filter filter, @PluginAttribute(value="ignoreExceptions") String ignore) {
        void var3_4;
        void var2_2;
        void var1_1;
        String string;
        int retryIntervalMillis22;
        if (name == null) {
            LOGGER.error("A name for the Appender must be specified");
            return null;
        }
        if (primary == null) {
            LOGGER.error("A primary Appender must be specified");
            return null;
        }
        if (failovers == null || failovers.length == 0) {
            LOGGER.error("At least one failover Appender must be specified");
            return null;
        }
        int seconds = FailoverAppender.parseInt(retryIntervalSeconds, 60);
        if (seconds >= 0) {
            retryIntervalMillis22 = seconds * 1000;
        } else {
            void retryIntervalMillis22;
            LOGGER.warn("Interval " + (String)retryIntervalMillis22 + " is less than zero. Using default");
            retryIntervalMillis22 = 60000;
        }
        boolean ignoreExceptions = Booleans.parseBoolean(ignore, true);
        return new FailoverAppender(string, filter, (String)var1_1, (String[])var2_2, (int)var3_4, config, ignoreExceptions, null);
    }
}

