/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.ErrorHandler;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.status.StatusLogger;

public class DefaultErrorHandler
implements ErrorHandler {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final int MAX_EXCEPTION_COUNT = 3;
    private static final long EXCEPTION_INTERVAL_NANOS = TimeUnit.MINUTES.toNanos(5L);
    private int exceptionCount = 0;
    private long lastExceptionInstantNanos = System.nanoTime() - EXCEPTION_INTERVAL_NANOS - 1L;
    private final Appender appender;

    /*
     * WARNING - void declaration
     */
    public DefaultErrorHandler(Appender appender) {
        void var1_1;
        this.appender = (Appender)Objects.requireNonNull(var1_1, "appender");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(String msg) {
        boolean bl = this.acquirePermit();
        if (bl) {
            void var1_1;
            LOGGER.error((String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(String msg, Throwable error) {
        boolean bl = this.acquirePermit();
        if (bl) {
            LOGGER.error(msg, error);
        }
        if (!this.appender.ignoreExceptions() && error != null && !(error instanceof AppenderLoggingException)) {
            void var2_2;
            void var1_1;
            throw new AppenderLoggingException((String)var1_1, (Throwable)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(String msg, LogEvent event, Throwable error) {
        boolean bl = this.acquirePermit();
        if (bl) {
            LOGGER.error(msg, error);
        }
        if (!this.appender.ignoreExceptions() && error != null && !(error instanceof AppenderLoggingException)) {
            void var3_4;
            void var1_1;
            throw new AppenderLoggingException((String)var1_1, (Throwable)var3_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean acquirePermit() {
        long currentInstantNanos = System.nanoTime();
        DefaultErrorHandler defaultErrorHandler = this;
        synchronized (defaultErrorHandler) {
            if (currentInstantNanos - this.lastExceptionInstantNanos > EXCEPTION_INTERVAL_NANOS) {
                this.lastExceptionInstantNanos = currentInstantNanos;
                return true;
            }
            if (this.exceptionCount < 3) {
                void var1_1;
                ++this.exceptionCount;
                this.lastExceptionInstantNanos = var1_1;
                return true;
            }
            return false;
        }
    }

    public Appender getAppender() {
        return this.appender;
    }
}

