/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.util.Booleans;
import org.apache.logging.log4j.core.util.CloseShieldOutputStream;
import org.apache.logging.log4j.core.util.Loader;
import org.apache.logging.log4j.core.util.Throwables;
import org.apache.logging.log4j.util.PropertiesUtil;

@Plugin(name="Console", category="Core", elementType="appender", printObject=true)
public final class ConsoleAppender
extends AbstractOutputStreamAppender<OutputStreamManager> {
    public static final String PLUGIN_NAME = "Console";
    private static final String JANSI_CLASS = "org.fusesource.jansi.WindowsAnsiOutputStream";
    private static ConsoleManagerFactory factory = new ConsoleManagerFactory();
    private static final Target DEFAULT_TARGET = Target.SYSTEM_OUT;
    private static final AtomicInteger COUNT = new AtomicInteger();
    private final Target target;

    /*
     * WARNING - void declaration
     */
    private ConsoleAppender(String name, Layout<? extends Serializable> layout, Filter filter, OutputStreamManager manager, boolean ignoreExceptions, Target target, Property[] properties) {
        super((String)var1_1, (Layout<? extends Serializable>)var2_2, (Filter)var3_3, ignoreExceptions, true, properties, manager);
        void var3_3;
        void var2_2;
        void var1_1;
        this.target = target;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static ConsoleAppender createAppender(Layout<? extends Serializable> layout, Filter filter, String targetStr, String name, String follow, String ignore) {
        void var2_2;
        Layout<? extends Serializable> layout2;
        void var1_1;
        void var3_3;
        if (name == null) {
            LOGGER.error("No name provided for ConsoleAppender");
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        boolean isFollow = Boolean.parseBoolean(follow);
        boolean ignoreExceptions = Booleans.parseBoolean(ignore, true);
        Target target = targetStr == null ? DEFAULT_TARGET : Target.valueOf(targetStr);
        return new ConsoleAppender((String)var3_3, (Layout<? extends Serializable>)layout, (Filter)var1_1, ConsoleAppender.getManager(target, isFollow, false, layout2), ignoreExceptions, (Target)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static ConsoleAppender createAppender(Layout<? extends Serializable> layout, Filter filter, Target target, String name, boolean follow, boolean direct, boolean ignoreExceptions) {
        void var2_2;
        Layout<? extends Serializable> layout2;
        void var1_1;
        void var3_3;
        if (name == null) {
            LOGGER.error("No name provided for ConsoleAppender");
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        Target target2 = target = target == null ? Target.SYSTEM_OUT : target;
        if (follow && direct) {
            LOGGER.error("Cannot use both follow and direct on ConsoleAppender");
            return null;
        }
        return new ConsoleAppender((String)var3_3, (Layout<? extends Serializable>)layout, (Filter)var1_1, ConsoleAppender.getManager(target, follow, direct, layout2), ignoreExceptions, (Target)var2_2, null);
    }

    public static ConsoleAppender createDefaultAppenderForLayout(Layout<? extends Serializable> layout) {
        Layout<? extends Serializable> layout2;
        return new ConsoleAppender("DefaultConsole-" + COUNT.incrementAndGet(), layout, null, ConsoleAppender.getDefaultManager(DEFAULT_TARGET, false, false, layout2), true, DEFAULT_TARGET, null);
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Builder)new Builder().asBuilder());
    }

    /*
     * WARNING - void declaration
     */
    private static OutputStreamManager getDefaultManager(Target target, boolean follow, boolean direct, Layout<? extends Serializable> layout) {
        void var3_3;
        Object object;
        void var2_2;
        void var1_1;
        OutputStream os = ConsoleAppender.getOutputStream(follow, direct, target);
        Object managerName = target.name() + '.' + (boolean)var1_1 + '.' + (boolean)var2_2 + "-" + COUNT.get();
        return OutputStreamManager.getManager((String)managerName, new FactoryData(os, (String)object, (Layout<? extends Serializable>)var3_3), factory);
    }

    /*
     * WARNING - void declaration
     */
    private static OutputStreamManager getManager(Target target, boolean follow, boolean direct, Layout<? extends Serializable> layout) {
        void var3_3;
        Object object;
        void var2_2;
        void var1_1;
        OutputStream os = ConsoleAppender.getOutputStream(follow, direct, target);
        Object managerName = target.name() + '.' + (boolean)var1_1 + '.' + (boolean)var2_2;
        return OutputStreamManager.getManager((String)managerName, new FactoryData(os, (String)object, (Layout<? extends Serializable>)var3_3), factory);
    }

    /*
     * WARNING - void declaration
     */
    private static OutputStream getOutputStream(boolean follow, boolean direct2, Target target) {
        void var0_1;
        void var2_5;
        OutputStream outputStream;
        String enc = Charset.defaultCharset().name();
        try {
            outputStream = target == Target.SYSTEM_OUT ? (direct2 ? new FileOutputStream(FileDescriptor.out) : (follow ? new PrintStream((OutputStream)new SystemOutStream(), true, enc) : System.out)) : (direct2 ? new FileOutputStream(FileDescriptor.err) : (follow ? new PrintStream((OutputStream)new SystemErrStream(), true, enc) : System.err));
            outputStream = new CloseShieldOutputStream(outputStream);
        }
        catch (UnsupportedEncodingException ex) {
            void var3_7;
            throw new IllegalStateException("Unsupported default encoding " + (String)var3_7, ex);
        }
        PropertiesUtil propsUtil = PropertiesUtil.getProperties();
        if (!propsUtil.isOsWindows() || var2_5.getBooleanProperty("log4j.skipJansi", true) || direct2) {
            return outputStream;
        }
        try {
            Class<?> direct2 = Loader.loadClass(JANSI_CLASS);
            Constructor<?> constructor = direct2.getConstructor(OutputStream.class);
            return new CloseShieldOutputStream((OutputStream)constructor.newInstance(outputStream));
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOGGER.debug("Jansi is not installed, cannot find {}", (Object)JANSI_CLASS);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LOGGER.warn("{} is missing the proper constructor", (Object)JANSI_CLASS);
        }
        catch (Exception ex) {
            void var1_4;
            LOGGER.warn("Unable to instantiate {} due to {}", (Object)JANSI_CLASS, (Object)ConsoleAppender.clean(Throwables.getRootCause((Throwable)var1_4).toString()).trim());
        }
        return var0_1;
    }

    private static String clean(String string) {
        return string.replace('\u0000', ' ');
    }

    public final Target getTarget() {
        return this.target;
    }

    static /* synthetic */ Target access$200() {
        return DEFAULT_TARGET;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ OutputStreamManager access$300(Target x0, boolean x1, boolean x2, Layout x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        return ConsoleAppender.getManager(x0, (boolean)var1_1, (boolean)var2_2, (Layout<? extends Serializable>)var3_3);
    }

    private static class ConsoleManagerFactory
    implements ManagerFactory<OutputStreamManager, FactoryData> {
        private ConsoleManagerFactory() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public OutputStreamManager createManager(String name, FactoryData data) {
            void var2_2;
            return new OutputStreamManager(data.os, data.name, ((FactoryData)var2_2).layout, true);
        }
    }

    private static class FactoryData {
        private final OutputStream os;
        private final String name;
        private final Layout<? extends Serializable> layout;

        /*
         * WARNING - void declaration
         */
        public FactoryData(OutputStream os, String type, Layout<? extends Serializable> layout) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.os = var1_1;
            this.name = var2_2;
            this.layout = var3_3;
        }
    }

    private static class SystemOutStream
    extends OutputStream {
        @Override
        public void close() {
        }

        @Override
        public void flush() {
            System.out.flush();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(byte[] b) throws IOException {
            void var1_1;
            System.out.write((byte[])var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            System.out.write((byte[])var1_1, (int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(int b) throws IOException {
            void var1_1;
            System.out.write((int)var1_1);
        }
    }

    private static class SystemErrStream
    extends OutputStream {
        @Override
        public void close() {
        }

        @Override
        public void flush() {
            System.err.flush();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(byte[] b) throws IOException {
            void var1_1;
            System.err.write((byte[])var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            System.err.write((byte[])var1_1, (int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void write(int b) {
            void var1_1;
            System.err.write((int)var1_1);
        }
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractOutputStreamAppender.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<ConsoleAppender> {
        @PluginBuilderAttribute
        @Required
        private Target target = ConsoleAppender.access$200();
        @PluginBuilderAttribute
        private boolean follow;
        @PluginBuilderAttribute
        private boolean direct;

        /*
         * WARNING - void declaration
         */
        public B setTarget(Target aTarget) {
            void var1_1;
            this.target = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setFollow(boolean shouldFollow) {
            void var1_1;
            this.follow = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setDirect(boolean shouldDirect) {
            void var1_1;
            this.direct = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ConsoleAppender build() {
            void var1_1;
            if (!this.isValid()) {
                return null;
            }
            if (this.follow && this.direct) {
                throw new IllegalArgumentException("Cannot use both follow and direct on ConsoleAppender '" + this.getName() + "'");
            }
            Builder builder = this;
            Layout<Serializable> layout = builder.getOrCreateLayout(builder.target.getDefaultCharset());
            return new ConsoleAppender(this.getName(), layout, this.getFilter(), ConsoleAppender.access$300(this.target, this.follow, this.direct, (Layout)var1_1), this.isIgnoreExceptions(), this.target, this.getPropertyArray());
        }
    }

    public static enum Target {
        SYSTEM_OUT{

            @Override
            public final Charset getDefaultCharset() {
                return this.getCharset("sun.stdout.encoding", Charset.defaultCharset());
            }
        }
        ,
        SYSTEM_ERR{

            @Override
            public final Charset getDefaultCharset() {
                return this.getCharset("sun.stderr.encoding", Charset.defaultCharset());
            }
        };


        public abstract Charset getDefaultCharset();

        /*
         * WARNING - void declaration
         */
        protected Charset getCharset(String property, Charset defaultCharset) {
            void var2_2;
            void var1_1;
            return new PropertiesUtil(PropertiesUtil.getSystemProperties()).getCharsetProperty((String)var1_1, (Charset)var2_2);
        }
    }
}

