/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.AppenderControl;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.util.Log4jThread;
import org.apache.logging.log4j.status.StatusLogger;

class AsyncAppenderEventDispatcher
extends Log4jThread {
    private static final LogEvent STOP_EVENT = new Log4jLogEvent();
    private static final AtomicLong THREAD_COUNTER = new AtomicLong(0L);
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final AppenderControl errorAppender;
    private final List<AppenderControl> appenders;
    private final BlockingQueue<LogEvent> queue;
    private final AtomicBoolean stoppedRef;

    /*
     * WARNING - void declaration
     */
    AsyncAppenderEventDispatcher(String name, AppenderControl errorAppender, List<AppenderControl> appenders, BlockingQueue<LogEvent> queue) {
        super("AsyncAppenderEventDispatcher-" + THREAD_COUNTER.incrementAndGet() + "-" + (String)var1_1);
        void var3_3;
        void var2_2;
        void var1_1;
        this.setDaemon(true);
        this.errorAppender = var2_2;
        this.appenders = var3_3;
        this.queue = queue;
        this.stoppedRef = new AtomicBoolean();
    }

    List<Appender> getAppenders() {
        return this.appenders.stream().map(AppenderControl::getAppender).collect(Collectors.toList());
    }

    @Override
    public void run() {
        LOGGER.trace("{} has started.", (Object)this.getName());
        this.dispatchAll();
        this.dispatchRemaining();
    }

    /*
     * WARNING - void declaration
     */
    private void dispatchAll() {
        while (!this.stoppedRef.get()) {
            void var1_1;
            LogEvent event;
            try {
                event = this.queue.take();
            }
            catch (InterruptedException interruptedException) {
                this.interrupt();
                break;
            }
            if (event == STOP_EVENT) break;
            event.setEndOfBatch(this.queue.isEmpty());
            this.dispatch((LogEvent)var1_1);
        }
        LOGGER.trace("{} has stopped.", (Object)this.getName());
    }

    /*
     * WARNING - void declaration
     */
    private void dispatchRemaining() {
        void var1_1;
        LogEvent event;
        int eventCount = 0;
        while ((event = (LogEvent)this.queue.poll()) != null) {
            void var2_2;
            if (event == STOP_EVENT) continue;
            event.setEndOfBatch(this.queue.isEmpty());
            this.dispatch((LogEvent)var2_2);
            ++eventCount;
        }
        LOGGER.trace("{} has processed the last {} remaining event(s).", (Object)this.getName(), (Object)((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    void dispatch(LogEvent event) {
        void var2_2;
        boolean succeeded = false;
        for (int appenderIndex = 0; appenderIndex < this.appenders.size(); ++appenderIndex) {
            AppenderControl control = this.appenders.get(appenderIndex);
            try {
                control.callAppender(event);
                succeeded = true;
                continue;
            }
            catch (Throwable error) {
                LOGGER.trace("{} has failed to call appender {}", (Object)this.getName(), (Object)control.getAppenderName(), (Object)error);
            }
        }
        if (var2_2 == false && this.errorAppender != null) {
            try {
                void var1_1;
                this.errorAppender.callAppender((LogEvent)var1_1);
                return;
            }
            catch (Throwable error) {
                void var3_4;
                LOGGER.trace("{} has failed to call the error appender {}", (Object)this.getName(), (Object)this.errorAppender.getAppenderName(), (Object)var3_4);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    void stop(long timeoutMillis) throws InterruptedException {
        void var1_1;
        boolean bl = this.stoppedRef.compareAndSet(false, true);
        if (bl) {
            LOGGER.trace("{} is signaled to stop.", (Object)this.getName());
        }
        while (Thread.State.NEW.equals((Object)this.getState())) {
        }
        bl = this.queue.offer(STOP_EVENT);
        if (!bl) {
            this.interrupt();
        }
        this.join((long)var1_1);
    }
}

