/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TransferQueue;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.AsyncAppenderEventDispatcher;
import org.apache.logging.log4j.core.async.ArrayBlockingQueueFactory;
import org.apache.logging.log4j.core.async.AsyncQueueFullMessageUtil;
import org.apache.logging.log4j.core.async.AsyncQueueFullPolicy;
import org.apache.logging.log4j.core.async.AsyncQueueFullPolicyFactory;
import org.apache.logging.log4j.core.async.BlockingQueueFactory;
import org.apache.logging.log4j.core.async.DiscardingAsyncQueueFullPolicy;
import org.apache.logging.log4j.core.async.EventRoute;
import org.apache.logging.log4j.core.async.InternalAsyncUtil;
import org.apache.logging.log4j.core.config.AppenderControl;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAliases;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.filter.AbstractFilterable;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.spi.AbstractLogger;

@Plugin(name="Async", category="Core", elementType="appender", printObject=true)
public final class AsyncAppender
extends AbstractAppender {
    private static final int DEFAULT_QUEUE_SIZE = 1024;
    private final BlockingQueue<LogEvent> queue;
    private final int queueSize;
    private final boolean blocking;
    private final long shutdownTimeout;
    private final Configuration config;
    private final AppenderRef[] appenderRefs;
    private final String errorRef;
    private final boolean includeLocation;
    private AppenderControl errorAppender;
    private AsyncAppenderEventDispatcher dispatcher;
    private AsyncQueueFullPolicy asyncQueueFullPolicy;

    /*
     * WARNING - void declaration
     */
    private AsyncAppender(String name, Filter filter, AppenderRef[] appenderRefs, String errorRef, int queueSize, boolean blocking, boolean ignoreExceptions, long shutdownTimeout, Configuration config, boolean includeLocation, BlockingQueueFactory<LogEvent> blockingQueueFactory, Property[] properties) {
        super((String)var1_1, (Filter)var2_2, null, ignoreExceptions, properties);
        void var3_3;
        void var2_2;
        void var1_1;
        this.queue = blockingQueueFactory.create(queueSize);
        this.queueSize = queueSize;
        this.blocking = blocking;
        this.shutdownTimeout = shutdownTimeout;
        this.config = config;
        this.appenderRefs = var3_3;
        this.errorRef = errorRef;
        this.includeLocation = includeLocation;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void start() {
        Map<String, Appender> map = this.config.getAppenders();
        ArrayList<AppenderControl> appenders = new ArrayList<AppenderControl>();
        AppenderRef[] appenderRefArray = this.appenderRefs;
        int n = this.appenderRefs.length;
        for (int i = 0; i < n; ++i) {
            AppenderRef appenderRef = appenderRefArray[i];
            Appender appender = map.get(appenderRef.getRef());
            if (appender != null) {
                appenders.add(new AppenderControl(appender, appenderRef.getLevel(), appenderRef.getFilter()));
                continue;
            }
            LOGGER.error("No appender named {} was configured", (Object)appenderRef);
        }
        if (this.errorRef != null) {
            void var1_1;
            Appender appender = (Appender)var1_1.get(this.errorRef);
            if (appender != null) {
                this.errorAppender = new AppenderControl((Appender)appenderRefArray, null, null);
            } else {
                LOGGER.error("Unable to set up error Appender. No appender named {} was configured", (Object)this.errorRef);
            }
        }
        if (appenders.size() > 0) {
            void var2_2;
            this.dispatcher = new AsyncAppenderEventDispatcher(this.getName(), this.errorAppender, (List<AppenderControl>)var2_2, this.queue);
        } else if (this.errorRef == null) {
            throw new ConfigurationException("No appenders are available for AsyncAppender " + this.getName());
        }
        this.asyncQueueFullPolicy = AsyncQueueFullPolicyFactory.create();
        this.dispatcher.start();
        super.start();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean stop(long timeout, TimeUnit timeUnit) {
        void var3_2;
        void var1_1;
        this.setStopping();
        super.stop((long)var1_1, (TimeUnit)var3_2, false);
        LOGGER.trace("AsyncAppender stopping. Queue still has {} events.", (Object)this.queue.size());
        try {
            this.dispatcher.stop(this.shutdownTimeout);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            LOGGER.warn("Interrupted while stopping AsyncAppender {}", (Object)this.getName());
        }
        LOGGER.trace("AsyncAppender stopped. Queue has {} events.", (Object)this.queue.size());
        if (DiscardingAsyncQueueFullPolicy.getDiscardCount(this.asyncQueueFullPolicy) > 0L) {
            LOGGER.trace("AsyncAppender: {} discarded {} events.", (Object)this.asyncQueueFullPolicy, (Object)DiscardingAsyncQueueFullPolicy.getDiscardCount(this.asyncQueueFullPolicy));
        }
        this.setStopped();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void append(LogEvent logEvent) {
        if (!this.isStarted()) {
            throw new IllegalStateException("AsyncAppender " + this.getName() + " is not active");
        }
        Log4jLogEvent memento = Log4jLogEvent.createMemento(logEvent, this.includeLocation);
        InternalAsyncUtil.makeMessageImmutable(logEvent.getMessage());
        if (!this.transfer(memento)) {
            void var2_2;
            if (this.blocking) {
                EventRoute eventRoute;
                if (AbstractLogger.getRecursionDepth() > 1) {
                    AsyncQueueFullMessageUtil.logWarningToStatusLogger();
                    this.logMessageInCurrentThread((LogEvent)((Object)eventRoute));
                    return;
                }
                eventRoute = this.asyncQueueFullPolicy.getRoute(this.dispatcher.getId(), memento.getLevel());
                eventRoute.logMessage(this, (LogEvent)memento);
                return;
            }
            this.error("Appender " + this.getName() + " is unable to write primary appenders. queue is full");
            this.logToErrorAppenderIfNecessary(false, (LogEvent)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean transfer(LogEvent memento) {
        void var1_1;
        if (this.queue instanceof TransferQueue) {
            return ((TransferQueue)this.queue).tryTransfer(memento);
        }
        return this.queue.offer((LogEvent)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void logMessageInCurrentThread(LogEvent logEvent) {
        void var1_1;
        logEvent.setEndOfBatch(this.queue.isEmpty());
        this.dispatcher.dispatch((LogEvent)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void logMessageInBackgroundThread(LogEvent logEvent) {
        try {
            this.queue.put(logEvent);
            return;
        }
        catch (InterruptedException interruptedException) {
            void var1_1;
            void var2_2;
            boolean appendSuccessful = this.handleInterruptedException(logEvent);
            this.logToErrorAppenderIfNecessary((boolean)var2_2, (LogEvent)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean handleInterruptedException(LogEvent memento) {
        void var1_2;
        boolean appendSuccessful = this.queue.offer(memento);
        if (!appendSuccessful) {
            LOGGER.warn("Interrupted while waiting for a free slot in the AsyncAppender LogEvent-queue {}", (Object)this.getName());
        }
        Thread.currentThread().interrupt();
        return (boolean)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    private void logToErrorAppenderIfNecessary(boolean appendSuccessful, LogEvent logEvent) {
        if (!appendSuccessful && this.errorAppender != null) {
            void var2_2;
            this.errorAppender.callAppender((LogEvent)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static AsyncAppender createAppender(AppenderRef[] appenderRefs, String errorRef, boolean blocking, long shutdownTimeout, int size, String name, boolean includeLocation, Filter filter, Configuration config, boolean ignoreExceptions) {
        void var3_3;
        void var2_2;
        void var1_1;
        AppenderRef[] appenderRefArray;
        if (name == null) {
            LOGGER.error("No name provided for AsyncAppender");
            return null;
        }
        if (appenderRefs == null) {
            LOGGER.error("No appender references provided to AsyncAppender {}", (Object)name);
        }
        return new AsyncAppender(name, filter, appenderRefArray, (String)var1_1, size, (boolean)var2_2, ignoreExceptions, (long)var3_3, config, includeLocation, new ArrayBlockingQueueFactory<LogEvent>(), null);
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    /*
     * WARNING - void declaration
     */
    public final String[] getAppenderRefStrings() {
        void var1_1;
        String[] result = new String[this.appenderRefs.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.appenderRefs[i].getRef();
        }
        return var1_1;
    }

    public final boolean isIncludeLocation() {
        return this.includeLocation;
    }

    public final boolean isBlocking() {
        return this.blocking;
    }

    public final List<Appender> getAppenders() {
        return this.dispatcher.getAppenders();
    }

    public final String getErrorRef() {
        return this.errorRef;
    }

    public final int getQueueCapacity() {
        return this.queueSize;
    }

    public final int getQueueRemainingCapacity() {
        return this.queue.remainingCapacity();
    }

    public final int getQueueSize() {
        return this.queue.size();
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractFilterable.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<AsyncAppender> {
        @PluginElement(value="AppenderRef")
        @Required(message="No appender references provided to AsyncAppender")
        private AppenderRef[] appenderRefs;
        @PluginBuilderAttribute
        @PluginAliases(value={"error-ref"})
        private String errorRef;
        @PluginBuilderAttribute
        private boolean blocking = true;
        @PluginBuilderAttribute
        private long shutdownTimeout = 0L;
        @PluginBuilderAttribute
        private int bufferSize = 1024;
        @PluginBuilderAttribute
        @Required(message="No name provided for AsyncAppender")
        private String name;
        @PluginBuilderAttribute
        private boolean includeLocation = false;
        @PluginConfiguration
        private Configuration configuration;
        @PluginBuilderAttribute
        private boolean ignoreExceptions = true;
        @PluginElement(value="BlockingQueueFactory")
        private BlockingQueueFactory<LogEvent> blockingQueueFactory = new ArrayBlockingQueueFactory<LogEvent>();

        /*
         * WARNING - void declaration
         */
        public Builder setAppenderRefs(AppenderRef[] appenderRefs) {
            void var1_1;
            this.appenderRefs = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setErrorRef(String errorRef) {
            void var1_1;
            this.errorRef = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setBlocking(boolean blocking) {
            void var1_1;
            this.blocking = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setShutdownTimeout(long shutdownTimeout) {
            void var1_1;
            this.shutdownTimeout = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setBufferSize(int bufferSize) {
            void var1_1;
            this.bufferSize = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setName(String name) {
            void var1_1;
            this.name = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setIncludeLocation(boolean includeLocation) {
            void var1_1;
            this.includeLocation = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setConfiguration(Configuration configuration) {
            void var1_1;
            this.configuration = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setIgnoreExceptions(boolean ignoreExceptions) {
            void var1_1;
            this.ignoreExceptions = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setBlockingQueueFactory(BlockingQueueFactory<LogEvent> blockingQueueFactory) {
            void var1_1;
            this.blockingQueueFactory = var1_1;
            return this;
        }

        @Override
        public AsyncAppender build() {
            return new AsyncAppender(this.name, this.getFilter(), this.appenderRefs, this.errorRef, this.bufferSize, this.blocking, this.ignoreExceptions, this.shutdownTimeout, this.configuration, this.includeLocation, this.blockingQueueFactory, this.getPropertyArray());
        }
    }
}

