/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Node;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginNode;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="AppenderSet", category="Core", printObject=true, deferChildren=true)
public class AppenderSet {
    private static final StatusLogger LOGGER = StatusLogger.getLogger();
    private final Configuration configuration;
    private final Map<String, Node> nodeMap;

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    /*
     * WARNING - void declaration
     */
    private AppenderSet(Configuration configuration, Map<String, Node> appenders) {
        void var2_2;
        void var1_1;
        this.configuration = var1_1;
        this.nodeMap = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Appender createAppender(String actualAppenderName, String sourceAppenderName) {
        void var1_1;
        void var2_2;
        Node node = this.nodeMap.get(actualAppenderName);
        if (node == null) {
            LOGGER.error("No node named {} in {}", (Object)actualAppenderName, (Object)this);
            return null;
        }
        node.getAttributes().put("name", (String)var2_2);
        if (node.getType().getElementName().equals("appender")) {
            void var3_3;
            Node appNode = new Node(node);
            this.configuration.createConfiguration(appNode, null);
            if (appNode.getObject() instanceof Appender) {
                Appender app = (Appender)appNode.getObject();
                app.start();
                return var1_1;
            }
            LOGGER.error("Unable to create Appender of type " + var3_3.getName());
            return null;
        }
        LOGGER.error("No Appender was configured for name {} " + (String)var1_1);
        return null;
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<AppenderSet> {
        @PluginNode
        private Node node;
        @PluginConfiguration
        @Required
        private Configuration configuration;

        /*
         * WARNING - void declaration
         */
        @Override
        public AppenderSet build() {
            void var2_2;
            if (this.configuration == null) {
                LOGGER.error("Configuration is missing from AppenderSet {}", (Object)this);
                return null;
            }
            if (this.node == null) {
                LOGGER.error("No node in AppenderSet {}", (Object)this);
                return null;
            }
            List<Node> children = this.node.getChildren();
            if (children == null) {
                LOGGER.error("No children node in AppenderSet {}", (Object)this);
                return null;
            }
            HashMap<String, Node> map = new HashMap<String, Node>(children.size());
            for (Node childNode : children) {
                String key = childNode.getAttributes().get("name");
                if (key == null) {
                    LOGGER.error("The attribute 'name' is missing from the node {} in AppenderSet {}", (Object)childNode, children);
                    continue;
                }
                map.put(key, childNode);
            }
            return new AppenderSet(this.configuration, (Map)var2_2);
        }

        public Node getNode() {
            return this.node;
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withNode(Node node) {
            void var1_1;
            this.node = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withConfiguration(Configuration configuration) {
            void var1_1;
            this.configuration = var1_1;
            return this;
        }

        public String toString() {
            return this.getClass().getName() + " [node=" + this.node + ", configuration=" + this.configuration + "]";
        }
    }
}

