/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.StringLayout;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.appender.WriterManager;
import org.apache.logging.log4j.core.config.Property;

public abstract class AbstractWriterAppender<M extends WriterManager>
extends AbstractAppender {
    protected final boolean immediateFlush;
    private final M manager;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();

    /*
     * WARNING - void declaration
     */
    protected AbstractWriterAppender(String name, StringLayout layout, Filter filter, boolean ignoreExceptions, boolean immediateFlush, Property[] properties, M manager) {
        super((String)var1_1, (Filter)var3_3, (Layout<? extends Serializable>)var2_2, ignoreExceptions, properties);
        void var2_2;
        void var3_3;
        void var1_1;
        this.manager = manager;
        this.immediateFlush = immediateFlush;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected AbstractWriterAppender(String name, StringLayout layout, Filter filter, boolean ignoreExceptions, boolean immediateFlush, M manager) {
        super((String)var1_1, (Filter)var3_3, (Layout<? extends Serializable>)var2_2, ignoreExceptions, Property.EMPTY_ARRAY);
        void var2_2;
        void var3_3;
        void var1_1;
        this.manager = manager;
        this.immediateFlush = immediateFlush;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void append(LogEvent event) {
        this.readLock.lock();
        try {
            String str = (String)this.getStringLayout().toSerializable(event);
            if (str.length() > 0) {
                ((WriterManager)this.manager).write(str);
                if (this.immediateFlush || event.isEndOfBatch()) {
                    ((WriterManager)this.manager).flush();
                }
            }
            return;
        }
        catch (AppenderLoggingException ex) {
            void var2_4;
            void var1_1;
            this.error("Unable to write " + ((AbstractManager)this.manager).getName() + " for appender " + this.getName(), (LogEvent)var1_1, (Throwable)((Object)ex));
            throw var2_4;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public M getManager() {
        return this.manager;
    }

    public StringLayout getStringLayout() {
        return (StringLayout)this.getLayout();
    }

    @Override
    public void start() {
        if (this.getLayout() == null) {
            LOGGER.error("No layout set for the appender named [{}].", (Object)this.getName());
        }
        if (this.manager == null) {
            LOGGER.error("No OutputStreamManager set for the appender named [{}].", (Object)this.getName());
        }
        super.start();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean stop(long timeout, TimeUnit timeUnit) {
        void var3_2;
        void var1_1;
        this.setStopping();
        boolean bl = super.stop(timeout, timeUnit, false);
        boolean stopped = bl & ((AbstractManager)this.manager).stop((long)var1_1, (TimeUnit)var3_2);
        this.setStopped();
        return stopped;
    }
}

