/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.core.util.Constants;

public abstract class AbstractOutputStreamAppender<M extends OutputStreamManager>
extends AbstractAppender {
    private final boolean immediateFlush;
    private final M manager;

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected AbstractOutputStreamAppender(String name, Layout<? extends Serializable> layout, Filter filter, boolean ignoreExceptions, boolean immediateFlush, M manager) {
        super((String)var1_1, (Filter)var3_3, (Layout<? extends Serializable>)var2_2, ignoreExceptions, Property.EMPTY_ARRAY);
        void var2_2;
        void var3_3;
        void var1_1;
        this.manager = manager;
        this.immediateFlush = immediateFlush;
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractOutputStreamAppender(String name, Layout<? extends Serializable> layout, Filter filter, boolean ignoreExceptions, boolean immediateFlush, Property[] properties, M manager) {
        super((String)var1_1, (Filter)var3_3, (Layout<? extends Serializable>)var2_2, ignoreExceptions, properties);
        void var2_2;
        void var3_3;
        void var1_1;
        this.manager = manager;
        this.immediateFlush = immediateFlush;
    }

    public boolean getImmediateFlush() {
        return this.immediateFlush;
    }

    public M getManager() {
        return this.manager;
    }

    @Override
    public void start() {
        if (this.getLayout() == null) {
            LOGGER.error("No layout set for the appender named [" + this.getName() + "].");
        }
        if (this.manager == null) {
            LOGGER.error("No OutputStreamManager set for the appender named [" + this.getName() + "].");
        }
        super.start();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean stop(long timeout, TimeUnit timeUnit) {
        void var3_2;
        void var1_1;
        return this.stop((long)var1_1, (TimeUnit)var3_2, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean stop(long timeout, TimeUnit timeUnit, boolean changeLifeCycleState) {
        void var3_2;
        void var1_1;
        boolean bl = super.stop(timeout, timeUnit, changeLifeCycleState);
        boolean stopped = bl & ((AbstractManager)this.manager).stop((long)var1_1, (TimeUnit)var3_2);
        if (changeLifeCycleState) {
            this.setStopped();
        }
        LOGGER.debug("Appender {} stopped with status {}", (Object)this.getName(), (Object)stopped);
        return stopped;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void append(LogEvent event) {
        try {
            this.tryAppend(event);
            return;
        }
        catch (AppenderLoggingException ex) {
            void var2_2;
            void var1_1;
            this.error("Unable to write to stream " + ((AbstractManager)this.manager).getName() + " for appender " + this.getName(), (LogEvent)var1_1, (Throwable)((Object)ex));
            throw var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void tryAppend(LogEvent event) {
        void var1_1;
        if (Constants.ENABLE_DIRECT_ENCODERS) {
            this.directEncodeEvent(event);
            return;
        }
        this.writeByteArrayToManager((LogEvent)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void directEncodeEvent(LogEvent event) {
        void var1_1;
        this.getLayout().encode(event, (ByteBufferDestination)this.manager);
        if (this.immediateFlush || var1_1.isEndOfBatch()) {
            ((OutputStreamManager)this.manager).flush();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void writeByteArrayToManager(LogEvent event) {
        byte[] bytes = this.getLayout().toByteArray(event);
        if (bytes != null && bytes.length > 0) {
            void var1_1;
            void var2_2;
            ((OutputStreamManager)this.manager).write((byte[])var2_2, this.immediateFlush || var1_1.isEndOfBatch());
        }
    }

    public static abstract class Builder<B extends Builder<B>>
    extends AbstractAppender.Builder<B> {
        @PluginBuilderAttribute
        private boolean bufferedIo = true;
        @PluginBuilderAttribute
        private int bufferSize = Constants.ENCODER_BYTE_BUFFER_SIZE;
        @PluginBuilderAttribute
        private boolean immediateFlush = true;

        public int getBufferSize() {
            return this.bufferSize;
        }

        public boolean isBufferedIo() {
            return this.bufferedIo;
        }

        public boolean isImmediateFlush() {
            return this.immediateFlush;
        }

        /*
         * WARNING - void declaration
         */
        public B setImmediateFlush(boolean immediateFlush) {
            void var1_1;
            this.immediateFlush = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setBufferedIo(boolean bufferedIo) {
            void var1_1;
            this.bufferedIo = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setBufferSize(int bufferSize) {
            void var1_1;
            this.bufferSize = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public B withImmediateFlush(boolean immediateFlush) {
            void var1_1;
            this.immediateFlush = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public B withBufferedIo(boolean bufferedIo) {
            void var1_1;
            this.bufferedIo = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public B withBufferSize(int bufferSize) {
            void var1_1;
            this.bufferSize = var1_1;
            return (B)((Builder)this.asBuilder());
        }
    }
}

