/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.AbstractLifeCycle;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.status.StatusLogger;

public abstract class AbstractManager
implements AutoCloseable {
    protected static final Logger LOGGER = StatusLogger.getLogger();
    private static final Map<String, AbstractManager> MAP = new HashMap<String, AbstractManager>();
    private static final Lock LOCK = new ReentrantLock();
    protected int count;
    private final String name;
    private final LoggerContext loggerContext;

    /*
     * WARNING - void declaration
     */
    protected AbstractManager(LoggerContext loggerContext, String name) {
        void var2_2;
        void var1_1;
        this.loggerContext = var1_1;
        this.name = name;
        LOGGER.debug("Starting {} {}", (Object)this.getClass().getSimpleName(), (Object)var2_2);
    }

    @Override
    public void close() {
        this.stop(0L, AbstractLifeCycle.DEFAULT_STOP_TIMEUNIT);
    }

    /*
     * WARNING - void declaration
     */
    public boolean stop(long timeout, TimeUnit timeUnit) {
        boolean stopped = true;
        LOCK.lock();
        try {
            --this.count;
            if (this.count <= 0) {
                void var3_3;
                void var1_1;
                MAP.remove(this.name);
                LOGGER.debug("Shutting down {} {}", (Object)this.getClass().getSimpleName(), (Object)this.getName());
                stopped = this.releaseSub((long)var1_1, (TimeUnit)var3_3);
                LOGGER.debug("Shut down {} {}, all resources released: {}", (Object)this.getClass().getSimpleName(), (Object)this.getName(), (Object)stopped);
            }
        }
        finally {
            LOCK.unlock();
        }
        return stopped;
    }

    /*
     * WARNING - void declaration
     */
    public static <M extends AbstractManager, T> M getManager(String name, ManagerFactory<M, T> factory, T data) {
        LOCK.lock();
        try {
            void var3_4;
            String string;
            AbstractManager manager = MAP.get(name);
            if (manager == null) {
                manager = (AbstractManager)Objects.requireNonNull(factory, "factory").createManager(name, data);
                if (manager == null) {
                    void var1_2;
                    throw new IllegalStateException("ManagerFactory [" + var1_2 + "] unable to create manager for [" + name + "] with data [" + data + "]");
                }
                MAP.put(string, manager);
            } else {
                void var2_3;
                manager.updateData(var2_3);
            }
            ++manager.count;
            string = var3_4;
            return (M)string;
        }
        finally {
            LOCK.unlock();
        }
    }

    public void updateData(Object data) {
    }

    public static boolean hasManager(String name) {
        LOCK.lock();
        try {
            String string;
            boolean bl = MAP.containsKey(string);
            return bl;
        }
        finally {
            LOCK.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected static <M extends AbstractManager> M narrow(Class<M> narrowClass, AbstractManager manager) {
        void var1_1;
        if (narrowClass.isAssignableFrom(manager.getClass())) {
            return (M)manager;
        }
        throw new ConfigurationException("Configuration has multiple incompatible Appenders pointing to the same resource '" + var1_1.getName() + "'");
    }

    protected static StatusLogger logger() {
        return StatusLogger.getLogger();
    }

    static int getManagerCount() {
        return MAP.size();
    }

    protected boolean releaseSub(long timeout, TimeUnit timeUnit) {
        return true;
    }

    protected int getCount() {
        return this.count;
    }

    public LoggerContext getLoggerContext() {
        return this.loggerContext;
    }

    @Deprecated
    public void release() {
        this.close();
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getContentFormat() {
        return new HashMap<String, String>();
    }

    /*
     * WARNING - void declaration
     */
    protected StrSubstitutor getStrSubstitutor() {
        void var1_1;
        if (this.loggerContext == null) {
            return null;
        }
        Configuration configuration = this.loggerContext.getConfiguration();
        if (configuration == null) {
            return null;
        }
        return var1_1.getStrSubstitutor();
    }

    /*
     * WARNING - void declaration
     */
    protected void log(Level level, String message, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        Message m = LOGGER.getMessageFactory().newMessage("{} {} {}: {}", new Object[]{this.getClass().getSimpleName(), this.getName(), message, throwable});
        LOGGER.log((Level)var1_1, (Message)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected void logDebug(String message, Throwable throwable) {
        void var2_2;
        void var1_1;
        this.log(Level.DEBUG, (String)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void logError(String message, Throwable throwable) {
        void var2_2;
        void var1_1;
        this.log(Level.ERROR, (String)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void logWarn(String message, Throwable throwable) {
        void var2_2;
        void var1_1;
        this.log(Level.WARN, (String)var1_1, (Throwable)var2_2);
    }

    protected static abstract class AbstractFactoryData {
        private final Configuration configuration;

        /*
         * WARNING - void declaration
         */
        protected AbstractFactoryData(Configuration configuration) {
            void var1_1;
            this.configuration = var1_1;
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }
    }
}

