/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.net.Advertiser;

public abstract class AbstractFileAppender<M extends OutputStreamManager>
extends AbstractOutputStreamAppender<M> {
    private final String fileName;
    private final Advertiser advertiser;
    private final Object advertisement;

    /*
     * WARNING - void declaration
     */
    private AbstractFileAppender(String name, Layout<? extends Serializable> layout, Filter filter, M manager, String filename, boolean ignoreExceptions, boolean immediateFlush, Advertiser advertiser, Property[] properties) {
        super(name, layout, filter, ignoreExceptions, immediateFlush, properties, manager);
        if (advertiser != null) {
            void var3_3;
            void var1_1;
            void var2_2;
            HashMap<String, String> configuration = new HashMap<String, String>(layout.getContentFormat());
            configuration.putAll(((AbstractManager)manager).getContentFormat());
            configuration.put("contentType", var2_2.getContentType());
            configuration.put("name", (String)var1_1);
            this.advertisement = advertiser.advertise((Map<String, String>)var3_3);
        } else {
            this.advertisement = null;
        }
        this.fileName = filename;
        this.advertiser = advertiser;
    }

    public String getFileName() {
        return this.fileName;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean stop(long timeout, TimeUnit timeUnit) {
        void var3_2;
        void var1_1;
        this.setStopping();
        super.stop((long)var1_1, (TimeUnit)var3_2, false);
        if (this.advertiser != null) {
            this.advertiser.unadvertise(this.advertisement);
        }
        this.setStopped();
        return true;
    }

    public static abstract class Builder<B extends Builder<B>>
    extends AbstractOutputStreamAppender.Builder<B> {
        @PluginBuilderAttribute
        @Required
        private String fileName;
        @PluginBuilderAttribute
        private boolean append = true;
        @PluginBuilderAttribute
        private boolean locking;
        @PluginBuilderAttribute
        private boolean advertise;
        @PluginBuilderAttribute
        private String advertiseUri;
        @PluginBuilderAttribute
        private boolean createOnDemand;
        @PluginBuilderAttribute
        private String filePermissions;
        @PluginBuilderAttribute
        private String fileOwner;
        @PluginBuilderAttribute
        private String fileGroup;

        public String getAdvertiseUri() {
            return this.advertiseUri;
        }

        public String getFileName() {
            return this.fileName;
        }

        public boolean isAdvertise() {
            return this.advertise;
        }

        public boolean isAppend() {
            return this.append;
        }

        public boolean isCreateOnDemand() {
            return this.createOnDemand;
        }

        public boolean isLocking() {
            return this.locking;
        }

        public String getFilePermissions() {
            return this.filePermissions;
        }

        public String getFileOwner() {
            return this.fileOwner;
        }

        public String getFileGroup() {
            return this.fileGroup;
        }

        /*
         * WARNING - void declaration
         */
        public B withAdvertise(boolean advertise) {
            void var1_1;
            this.advertise = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B withAdvertiseUri(String advertiseUri) {
            void var1_1;
            this.advertiseUri = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B withAppend(boolean append) {
            void var1_1;
            this.append = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B withFileName(String fileName) {
            void var1_1;
            this.fileName = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B withCreateOnDemand(boolean createOnDemand) {
            void var1_1;
            this.createOnDemand = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B withLocking(boolean locking) {
            void var1_1;
            this.locking = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B withFilePermissions(String filePermissions) {
            void var1_1;
            this.filePermissions = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B withFileOwner(String fileOwner) {
            void var1_1;
            this.fileOwner = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B withFileGroup(String fileGroup) {
            void var1_1;
            this.fileGroup = var1_1;
            return (B)((Builder)this.asBuilder());
        }
    }
}

