/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Objects;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.ErrorHandler;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.DefaultErrorHandler;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.filter.AbstractFilterable;
import org.apache.logging.log4j.core.impl.LocationAware;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.util.Integers;

public abstract class AbstractAppender
extends AbstractFilterable
implements Appender,
LocationAware {
    private final String name;
    private final boolean ignoreExceptions;
    private final Layout<? extends Serializable> layout;
    private ErrorHandler handler = new DefaultErrorHandler(this);

    /*
     * WARNING - void declaration
     */
    public static int parseInt(String s, int defaultValue) {
        try {
            return Integers.parseInt(s, defaultValue);
        }
        catch (NumberFormatException e) {
            void var1_1;
            void var2_2;
            String string;
            LOGGER.error("Could not parse \"{}\" as an integer,  using default value {}: {}", (Object)string, (Object)defaultValue, (Object)var2_2);
            return (int)var1_1;
        }
    }

    @Override
    public boolean requiresLocation() {
        return this.layout instanceof LocationAware && ((LocationAware)((Object)this.layout)).requiresLocation();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected AbstractAppender(String name, Filter filter, Layout<? extends Serializable> layout) {
        this((String)var1_1, (Filter)var2_2, (Layout<? extends Serializable>)var3_3, true, Property.EMPTY_ARRAY);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected AbstractAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions) {
        this((String)var1_1, (Filter)var2_2, (Layout<? extends Serializable>)var3_3, ignoreExceptions, Property.EMPTY_ARRAY);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, Property[] properties) {
        super((Filter)var2_2, properties);
        void var3_3;
        void var1_1;
        void var2_2;
        this.name = (String)Objects.requireNonNull(var1_1, "name");
        this.layout = var3_3;
        this.ignoreExceptions = ignoreExceptions;
    }

    /*
     * WARNING - void declaration
     */
    public void error(String msg) {
        void var1_1;
        this.handler.error((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void error(String msg, LogEvent event, Throwable t) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.handler.error((String)var1_1, (LogEvent)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void error(String msg, Throwable t) {
        void var2_2;
        void var1_1;
        this.handler.error((String)var1_1, (Throwable)var2_2);
    }

    @Override
    public ErrorHandler getHandler() {
        return this.handler;
    }

    @Override
    public Layout<? extends Serializable> getLayout() {
        return this.layout;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean ignoreExceptions() {
        return this.ignoreExceptions;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setHandler(ErrorHandler handler) {
        void var1_1;
        if (handler == null) {
            LOGGER.error("The handler cannot be set to null");
            return;
        }
        if (this.isStarted()) {
            LOGGER.error("The handler cannot be changed once the appender is started");
            return;
        }
        this.handler = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected Serializable toSerializable(LogEvent event) {
        if (this.layout != null) {
            void var1_1;
            return this.layout.toSerializable((LogEvent)var1_1);
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    public static abstract class Builder<B extends Builder<B>>
    extends AbstractFilterable.Builder<B> {
        @PluginBuilderAttribute
        private boolean ignoreExceptions = true;
        @PluginElement(value="Layout")
        private Layout<? extends Serializable> layout;
        @PluginBuilderAttribute
        @Required(message="No appender name provided")
        private String name;
        @PluginConfiguration
        private Configuration configuration;

        public Configuration getConfiguration() {
            return this.configuration;
        }

        public Layout<? extends Serializable> getLayout() {
            return this.layout;
        }

        public String getName() {
            return this.name;
        }

        public Layout<? extends Serializable> getOrCreateLayout() {
            if (this.layout == null) {
                return PatternLayout.createDefaultLayout(this.configuration);
            }
            return this.layout;
        }

        /*
         * WARNING - void declaration
         */
        public Layout<? extends Serializable> getOrCreateLayout(Charset charset) {
            if (this.layout == null) {
                void var1_1;
                return PatternLayout.newBuilder().withCharset((Charset)var1_1).withConfiguration(this.configuration).build();
            }
            return this.layout;
        }

        public boolean isIgnoreExceptions() {
            return this.ignoreExceptions;
        }

        /*
         * WARNING - void declaration
         */
        public B setConfiguration(Configuration configuration) {
            void var1_1;
            this.configuration = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setIgnoreExceptions(boolean ignoreExceptions) {
            void var1_1;
            this.ignoreExceptions = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setLayout(Layout<? extends Serializable> layout) {
            void var1_1;
            this.layout = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        public B setName(String name) {
            void var1_1;
            this.name = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public B withConfiguration(Configuration configuration) {
            void var1_1;
            this.configuration = var1_1;
            return (B)((Builder)this.asBuilder());
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public B withIgnoreExceptions(boolean ignoreExceptions) {
            void var1_1;
            return this.setIgnoreExceptions((boolean)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public B withLayout(Layout<? extends Serializable> layout) {
            void var1_1;
            return this.setLayout((Layout<Serializable>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public B withName(String name) {
            void var1_1;
            return this.setName((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public String getErrorPrefix() {
            void var1_1;
            Class<?> appenderClass = this.getClass().getEnclosingClass();
            String name = this.getName();
            StringBuilder sb = new StringBuilder(appenderClass != null ? appenderClass.getSimpleName() : "Appender");
            if (name != null) {
                void var2_2;
                sb.append(" '").append((String)var2_2).append("'");
            }
            return var1_1.toString();
        }
    }
}

