/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.AbstractLifeCycle;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LifeCycle2;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationListener;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.NullConfiguration;
import org.apache.logging.log4j.core.config.Reconfigurable;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.jmx.Server;
import org.apache.logging.log4j.core.util.Cancellable;
import org.apache.logging.log4j.core.util.ExecutorServices;
import org.apache.logging.log4j.core.util.NetUtils;
import org.apache.logging.log4j.core.util.ShutdownCallbackRegistry;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.apache.logging.log4j.spi.LoggerContextShutdownAware;
import org.apache.logging.log4j.spi.LoggerContextShutdownEnabled;
import org.apache.logging.log4j.spi.LoggerRegistry;
import org.apache.logging.log4j.spi.Terminable;
import org.apache.logging.log4j.spi.ThreadContextMapFactory;
import org.apache.logging.log4j.util.PropertiesUtil;

public class LoggerContext
extends AbstractLifeCycle
implements AutoCloseable,
ConfigurationListener,
org.apache.logging.log4j.spi.LoggerContext,
LoggerContextShutdownEnabled,
Terminable {
    public static final String PROPERTY_CONFIG = "config";
    private static final Configuration NULL_CONFIGURATION = new NullConfiguration();
    private final LoggerRegistry<Logger> loggerRegistry = new LoggerRegistry();
    private final CopyOnWriteArrayList<PropertyChangeListener> propertyChangeListeners = new CopyOnWriteArrayList();
    private volatile List<LoggerContextShutdownAware> listeners;
    private volatile Configuration configuration = new DefaultConfiguration();
    private static final String EXTERNAL_CONTEXT_KEY = "__EXTERNAL_CONTEXT_KEY__";
    private ConcurrentMap<String, Object> externalMap = new ConcurrentHashMap<String, Object>();
    private String contextName;
    private volatile URI configLocation;
    private Cancellable shutdownCallback;
    private final Lock configLock = new ReentrantLock();

    /*
     * WARNING - void declaration
     */
    public LoggerContext(String name) {
        this((String)var1_1, (Object)null, (URI)null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LoggerContext(String name, Object externalContext) {
        this((String)var1_1, (Object)var2_2, (URI)null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LoggerContext(String name, Object externalContext, URI configLocn) {
        void var3_3;
        void var1_1;
        this.contextName = var1_1;
        if (externalContext == null) {
            this.externalMap.remove(EXTERNAL_CONTEXT_KEY);
        } else {
            void var2_2;
            this.externalMap.put(EXTERNAL_CONTEXT_KEY, var2_2);
        }
        this.configLocation = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public LoggerContext(String name, Object externalContext, String configLocn) {
        this.contextName = name;
        if (externalContext == null) {
            this.externalMap.remove(EXTERNAL_CONTEXT_KEY);
        } else {
            void var2_2;
            this.externalMap.put(EXTERNAL_CONTEXT_KEY, var2_2);
        }
        if (configLocn != null) {
            void var1_1;
            URI uri;
            try {
                void var3_3;
                uri = new File((String)var3_3).toURI();
            }
            catch (Exception exception) {
                uri = null;
            }
            this.configLocation = var1_1;
            return;
        }
        this.configLocation = null;
    }

    /*
     * WARNING - void declaration
     */
    public void addShutdownListener(LoggerContextShutdownAware listener) {
        void var1_1;
        if (this.listeners == null) {
            LoggerContext loggerContext = this;
            synchronized (loggerContext) {
                if (this.listeners == null) {
                    this.listeners = new CopyOnWriteArrayList<LoggerContextShutdownAware>();
                }
            }
        }
        this.listeners.add((LoggerContextShutdownAware)var1_1);
    }

    public List<LoggerContextShutdownAware> getListeners() {
        return this.listeners;
    }

    public static LoggerContext getContext() {
        return (LoggerContext)LogManager.getContext();
    }

    public static LoggerContext getContext(boolean currentContext) {
        return (LoggerContext)LogManager.getContext((boolean)currentContext);
    }

    /*
     * WARNING - void declaration
     */
    public static LoggerContext getContext(ClassLoader loader, boolean currentContext, URI configLocation) {
        void var2_2;
        void var1_1;
        return (LoggerContext)LogManager.getContext((ClassLoader)loader, (boolean)var1_1, (URI)var2_2);
    }

    @Override
    public void start() {
        LOGGER.debug("Starting LoggerContext[name={}, {}]...", (Object)this.getName(), (Object)this);
        if (PropertiesUtil.getProperties().getBooleanProperty("log4j.LoggerContext.stacktrace.on.start", false)) {
            LOGGER.debug("Stack trace to locate invoker", (Throwable)new Exception("Not a real error, showing stack trace to locate invoker"));
        }
        if (this.configLock.tryLock()) {
            try {
                if (this.isInitialized() || this.isStopped()) {
                    this.setStarting();
                    this.reconfigure();
                    if (this.configuration.isShutdownHookEnabled()) {
                        this.setUpShutdownHook();
                    }
                    this.setStarted();
                }
            }
            finally {
                this.configLock.unlock();
            }
        }
        LOGGER.debug("LoggerContext[name={}, {}] started OK.", (Object)this.getName(), (Object)this);
    }

    /*
     * WARNING - void declaration
     */
    public void start(Configuration config) {
        void var1_1;
        LOGGER.debug("Starting LoggerContext[name={}, {}] with configuration {}...", (Object)this.getName(), (Object)this, (Object)config);
        if (this.configLock.tryLock()) {
            try {
                if (this.isInitialized() || this.isStopped()) {
                    if (this.configuration.isShutdownHookEnabled()) {
                        this.setUpShutdownHook();
                    }
                    this.setStarted();
                }
            }
            finally {
                this.configLock.unlock();
            }
        }
        this.setConfiguration(config);
        LOGGER.debug("LoggerContext[name={}, {}] started OK with configuration {}.", (Object)this.getName(), (Object)this, (Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void setUpShutdownHook() {
        LoggerContextFactory factory;
        if (this.shutdownCallback == null && (factory = LogManager.getFactory()) instanceof ShutdownCallbackRegistry) {
            LOGGER.debug(ShutdownCallbackRegistry.SHUTDOWN_HOOK_MARKER, "Shutdown hook enabled. Registering a new one.");
            ExecutorServices.ensureInitialized();
            try {
                void var1_1;
                long shutdownTimeoutMillis = this.configuration.getShutdownTimeoutMillis();
                this.shutdownCallback = ((ShutdownCallbackRegistry)var1_1).addShutdownCallback(new Runnable(this, shutdownTimeoutMillis){
                    final /* synthetic */ long val$shutdownTimeoutMillis;
                    final /* synthetic */ LoggerContext this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                        this.val$shutdownTimeoutMillis = l;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public void run() {
                        void var1_1;
                        LoggerContext context = this.this$0;
                        AbstractLifeCycle.LOGGER.debug(ShutdownCallbackRegistry.SHUTDOWN_HOOK_MARKER, "Stopping LoggerContext[name={}, {}]", (Object)context.getName(), (Object)context);
                        var1_1.stop(this.val$shutdownTimeoutMillis, TimeUnit.MILLISECONDS);
                    }

                    public String toString() {
                        return "Shutdown callback for LoggerContext[name=" + this.this$0.getName() + ']';
                    }
                });
                return;
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("Unable to register Log4j shutdown hook because JVM is shutting down.", e);
            }
            catch (SecurityException e) {
                void var2_4;
                LOGGER.error(ShutdownCallbackRegistry.SHUTDOWN_HOOK_MARKER, "Unable to register shutdown hook due to security restrictions", (Throwable)var2_4);
            }
        }
    }

    @Override
    public void close() {
        this.stop();
    }

    public void terminate() {
        this.stop();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean stop(long timeout, TimeUnit timeUnit) {
        LOGGER.debug("Stopping LoggerContext[name={}, {}]...", (Object)this.getName(), (Object)this);
        this.configLock.lock();
        try {
            if (this.isStopped()) {
                return true;
            }
            this.setStopping();
            try {
                Server.unregisterLoggerContext(this.getName());
            }
            catch (Exception | LinkageError e) {
                LOGGER.error("Unable to unregister MBeans", e);
            }
            if (this.shutdownCallback != null) {
                this.shutdownCallback.cancel();
                this.shutdownCallback = null;
            }
            Configuration prev = this.configuration;
            this.configuration = NULL_CONFIGURATION;
            this.updateLoggers();
            if (prev instanceof LifeCycle2) {
                void var3_4;
                ((LifeCycle2)((Object)prev)).stop(timeout, (TimeUnit)var3_4);
            } else {
                prev.stop();
            }
            this.externalMap.clear();
            LogManager.getFactory().removeContext((org.apache.logging.log4j.spi.LoggerContext)this);
        }
        finally {
            this.configLock.unlock();
            this.setStopped();
        }
        if (this.listeners != null) {
            for (LoggerContextShutdownAware listener : this.listeners) {
                try {
                    void var1_3;
                    var1_3.contextShutdown((org.apache.logging.log4j.spi.LoggerContext)this);
                }
                catch (Exception exception) {}
            }
        }
        LOGGER.debug("Stopped LoggerContext[name={}, {}] with status {}", (Object)this.getName(), (Object)this, (Object)Boolean.TRUE);
        return true;
    }

    public String getName() {
        return this.contextName;
    }

    public Logger getRootLogger() {
        return this.getLogger("");
    }

    /*
     * WARNING - void declaration
     */
    public void setName(String name) {
        void var1_1;
        this.contextName = (String)Objects.requireNonNull(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Object getObject(String key) {
        void var1_1;
        return this.externalMap.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Object putObject(String key, Object value) {
        void var2_2;
        void var1_1;
        return this.externalMap.put((String)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public Object putObjectIfAbsent(String key, Object value) {
        void var2_2;
        void var1_1;
        return this.externalMap.putIfAbsent((String)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public Object removeObject(String key) {
        void var1_1;
        return this.externalMap.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean removeObject(String key, Object value) {
        void var2_2;
        void var1_1;
        return this.externalMap.remove(var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void setExternalContext(Object context) {
        if (context != null) {
            void var1_1;
            this.externalMap.put(EXTERNAL_CONTEXT_KEY, var1_1);
            return;
        }
        this.externalMap.remove(EXTERNAL_CONTEXT_KEY);
    }

    public Object getExternalContext() {
        return this.externalMap.get(EXTERNAL_CONTEXT_KEY);
    }

    /*
     * WARNING - void declaration
     */
    public Logger getLogger(String name) {
        void var1_1;
        return this.getLogger((String)var1_1, null);
    }

    public Collection<Logger> getLoggers() {
        return this.loggerRegistry.getLoggers();
    }

    /*
     * WARNING - void declaration
     */
    public Logger getLogger(String name, MessageFactory messageFactory) {
        void var2_2;
        void var1_1;
        void var3_3;
        Logger logger = (Logger)this.loggerRegistry.getLogger(name, messageFactory);
        if (logger != null) {
            AbstractLogger.checkMessageFactory((ExtendedLogger)logger, (MessageFactory)messageFactory);
            return logger;
        }
        LoggerContext loggerContext = this;
        logger = loggerContext.newInstance(loggerContext, name, messageFactory);
        this.loggerRegistry.putIfAbsent(name, messageFactory, (ExtendedLogger)var3_3);
        return (Logger)this.loggerRegistry.getLogger((String)var1_1, (MessageFactory)var2_2);
    }

    public LoggerRegistry<Logger> getLoggerRegistry() {
        return this.loggerRegistry;
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasLogger(String name) {
        void var1_1;
        return this.loggerRegistry.hasLogger((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasLogger(String name, MessageFactory messageFactory) {
        void var2_2;
        void var1_1;
        return this.loggerRegistry.hasLogger((String)var1_1, (MessageFactory)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasLogger(String name, Class<? extends MessageFactory> messageFactoryClass) {
        void var2_2;
        void var1_1;
        return this.loggerRegistry.hasLogger((String)var1_1, (Class)var2_2);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - void declaration
     */
    public void addFilter(Filter filter) {
        void var1_1;
        this.configuration.addFilter((Filter)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void removeFilter(Filter filter) {
        void var1_1;
        this.configuration.removeFilter((Filter)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Configuration setConfiguration(Configuration config) {
        if (config == null) {
            LOGGER.error("No configuration found for context '{}'.", (Object)this.contextName);
            return this.configuration;
        }
        this.configLock.lock();
        try {
            void var2_3;
            void var1_1;
            void var3_4;
            Configuration prev = this.configuration;
            config.addListener(this);
            ConcurrentMap map = (ConcurrentMap)config.getComponent("ContextProperties");
            try {
                map.computeIfAbsent("hostName", s -> NetUtils.getLocalHostname());
            }
            catch (Exception ex) {
                LOGGER.debug("Ignoring {}, setting hostName to 'unknown'", (Object)ex.toString());
                map.putIfAbsent("hostName", "unknown");
            }
            var3_4.putIfAbsent("contextName", this.contextName);
            config.start();
            this.configuration = config;
            this.updateLoggers();
            if (prev != null) {
                prev.removeListener(this);
                prev.stop();
            }
            this.firePropertyChangeEvent(new PropertyChangeEvent(this, PROPERTY_CONFIG, prev, var1_1));
            try {
                Server.reregisterMBeansAfterReconfigure();
            }
            catch (Exception | LinkageError e) {
                LOGGER.error("Could not reconfigure JMX", e);
            }
            Log4jLogEvent.setNanoClock(this.configuration.getNanoClock());
            void var4_7 = var2_3;
            return var4_7;
        }
        finally {
            this.configLock.unlock();
        }
    }

    private void firePropertyChangeEvent(PropertyChangeEvent event) {
        for (PropertyChangeListener propertyChangeListener : this.propertyChangeListeners) {
            propertyChangeListener.propertyChange(event);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        void var1_1;
        this.propertyChangeListeners.add((PropertyChangeListener)Objects.requireNonNull(var1_1, "listener"));
    }

    /*
     * WARNING - void declaration
     */
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        void var1_1;
        this.propertyChangeListeners.remove(var1_1);
    }

    public URI getConfigLocation() {
        return this.configLocation;
    }

    /*
     * WARNING - void declaration
     */
    public void setConfigLocation(URI configLocation) {
        void var1_1;
        this.configLocation = configLocation;
        this.reconfigure((URI)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void reconfigure(URI configURI) {
        void var2_2;
        void var1_1;
        void var3_3;
        Object externalContext = this.externalMap.get(EXTERNAL_CONTEXT_KEY);
        ClassLoader cl = ClassLoader.class.isInstance(externalContext) ? (ClassLoader)externalContext : null;
        LOGGER.debug("Reconfiguration started for context[name={}] at URI {} ({}) with optional ClassLoader: {}", (Object)this.contextName, (Object)configURI, (Object)this, (Object)cl);
        LoggerContext loggerContext = this;
        Configuration instance = ConfigurationFactory.getInstance().getConfiguration(loggerContext, loggerContext.contextName, configURI, cl);
        if (instance == null) {
            LOGGER.error("Reconfiguration failed: No configuration found for '{}' at '{}' in '{}'", (Object)this.contextName, (Object)configURI, (Object)cl);
            return;
        }
        this.setConfiguration((Configuration)var3_3);
        String location = this.configuration == null ? "?" : String.valueOf(this.configuration.getConfigurationSource());
        LOGGER.debug("Reconfiguration complete for context[name={}] at URI {} ({}) with optional ClassLoader: {}", (Object)this.contextName, (Object)var1_1, (Object)this, (Object)var2_2);
    }

    public void reconfigure() {
        LoggerContext loggerContext = this;
        loggerContext.reconfigure(loggerContext.configLocation);
    }

    /*
     * WARNING - void declaration
     */
    public void reconfigure(Configuration configuration) {
        URI uri;
        this.setConfiguration(configuration);
        ConfigurationSource source = configuration.getConfigurationSource();
        if (source != null && (uri = source.getURI()) != null) {
            void var1_1;
            this.configLocation = var1_1;
        }
    }

    public void updateLoggers() {
        LoggerContext loggerContext = this;
        loggerContext.updateLoggers(loggerContext.configuration);
    }

    /*
     * WARNING - void declaration
     */
    public void updateLoggers(Configuration config) {
        void var1_1;
        void var2_2;
        Configuration old = this.configuration;
        for (Logger logger : this.loggerRegistry.getLoggers()) {
            logger.updateConfiguration(config);
        }
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, PROPERTY_CONFIG, var2_2, var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void onChange(Reconfigurable reconfigurable) {
        void var2_2;
        long startMillis = System.currentTimeMillis();
        LOGGER.debug("Reconfiguration started for context {} ({})", (Object)this.contextName, (Object)this);
        this.initApiModule();
        Configuration newConfig = reconfigurable.reconfigure();
        if (newConfig != null) {
            void var1_1;
            this.setConfiguration((Configuration)var1_1);
            LOGGER.debug("Reconfiguration completed for {} ({}) in {} milliseconds.", (Object)this.contextName, (Object)this, (Object)(System.currentTimeMillis() - startMillis));
            return;
        }
        LOGGER.debug("Reconfiguration failed for {} ({}) in {} milliseconds.", (Object)this.contextName, (Object)this, (Object)(System.currentTimeMillis() - var2_2));
    }

    private void initApiModule() {
        ThreadContextMapFactory.init();
    }

    /*
     * WARNING - void declaration
     */
    protected Logger newInstance(LoggerContext ctx, String name, MessageFactory messageFactory) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new Logger((LoggerContext)var1_1, (String)var2_2, (MessageFactory)var3_3);
    }
}

