/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogBuilder;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LocationAwareReliabilityStrategy;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.ReliabilityStrategy;
import org.apache.logging.log4j.core.filter.AbstractFilterable;
import org.apache.logging.log4j.core.filter.CompositeFilter;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.util.Supplier;

public class Logger
extends AbstractLogger
implements Supplier<LoggerConfig> {
    private static final long serialVersionUID = 1L;
    protected volatile PrivateConfig privateConfig;
    private final LoggerContext context;

    /*
     * WARNING - void declaration
     */
    protected Logger(LoggerContext context, String name, MessageFactory messageFactory) {
        super((String)var2_2, (MessageFactory)var3_3);
        void var1_1;
        void var3_3;
        void var2_2;
        this.context = context;
        this.privateConfig = new PrivateConfig(this, var1_1.getConfiguration(), this);
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new LoggerProxy(this.getName(), this.getMessageFactory());
    }

    /*
     * WARNING - void declaration
     */
    public Logger getParent() {
        void var2_2;
        void var1_1;
        MessageFactory messageFactory;
        LoggerConfig lc = this.privateConfig.loggerConfig.getName().equals(this.getName()) ? this.privateConfig.loggerConfig.getParent() : this.privateConfig.loggerConfig;
        if (lc == null) {
            return null;
        }
        String lcName = lc.getName();
        if (this.context.hasLogger(lcName, messageFactory = this.getMessageFactory())) {
            return this.context.getLogger(lcName, messageFactory);
        }
        return new Logger(this.context, (String)var1_1, (MessageFactory)var2_2);
    }

    public LoggerContext getContext() {
        return this.context;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setLevel(Level level) {
        void var1_1;
        Logger parent;
        if (level == this.getLevel()) {
            return;
        }
        Level actualLevel = level != null ? level : ((parent = this.getParent()) != null ? parent.getLevel() : this.privateConfig.loggerConfigLevel);
        Logger logger = this;
        this.privateConfig = new PrivateConfig(logger, logger.privateConfig, (Level)var1_1);
    }

    public LoggerConfig get() {
        return this.privateConfig.loggerConfig;
    }

    protected boolean requiresLocation() {
        return this.privateConfig.requiresLocation;
    }

    /*
     * WARNING - void declaration
     */
    public void logMessage(String fqcn, Level level, Marker marker, Message message, Throwable t) {
        void var2_2;
        void var3_3;
        void var1_1;
        Message msg = message == null ? new SimpleMessage("") : message;
        ReliabilityStrategy reliabilityStrategy = this.privateConfig.loggerConfig.getReliabilityStrategy();
        Logger logger = this;
        reliabilityStrategy.log(logger, logger.getName(), (String)var1_1, (Marker)var3_3, (Level)var2_2, msg, t);
    }

    /*
     * WARNING - void declaration
     */
    protected void log(Level level, Marker marker, String fqcn, StackTraceElement location, Message message, Throwable throwable) {
        void var1_1;
        void var2_2;
        void var3_3;
        ReliabilityStrategy strategy = this.privateConfig.loggerConfig.getReliabilityStrategy();
        if (strategy instanceof LocationAwareReliabilityStrategy) {
            Logger logger = this;
            ((LocationAwareReliabilityStrategy)((Object)strategy)).log(logger, logger.getName(), fqcn, location, marker, level, message, throwable);
            return;
        }
        Logger logger = this;
        strategy.log(logger, logger.getName(), (String)var3_3, (Marker)var2_2, (Level)var1_1, message, throwable);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isEnabled(Level level, Marker marker, String message, Throwable t) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.privateConfig.filter((Level)var1_1, (Marker)var2_2, (String)var3_3, t);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isEnabled(Level level, Marker marker, String message) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.privateConfig.filter((Level)var1_1, (Marker)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isEnabled(Level level, Marker marker, String message, Object ... params) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.privateConfig.filter((Level)var1_1, (Marker)var2_2, (String)var3_3, params);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isEnabled(Level level, Marker marker, String message, Object p0) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.privateConfig.filter((Level)var1_1, (Marker)var2_2, (String)var3_3, p0);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.privateConfig.filter((Level)var1_1, (Marker)var2_2, (String)var3_3, p0, p1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.privateConfig.filter((Level)var1_1, (Marker)var2_2, (String)var3_3, p0, p1, p2);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.privateConfig.filter((Level)var1_1, (Marker)var2_2, (String)var3_3, p0, p1, p2, p3);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.privateConfig.filter((Level)var1_1, (Marker)var2_2, (String)var3_3, p0, p1, p2, p3, p4);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.privateConfig.filter((Level)var1_1, (Marker)var2_2, (String)var3_3, p0, p1, p2, p3, p4, p5);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.privateConfig.filter((Level)var1_1, (Marker)var2_2, (String)var3_3, p0, p1, p2, p3, p4, p5, p6);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.privateConfig.filter((Level)var1_1, (Marker)var2_2, (String)var3_3, p0, p1, p2, p3, p4, p5, p6, p7);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.privateConfig.filter((Level)var1_1, (Marker)var2_2, (String)var3_3, p0, p1, p2, p3, p4, p5, p6, p7, p8);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isEnabled(Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.privateConfig.filter((Level)var1_1, (Marker)var2_2, (String)var3_3, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isEnabled(Level level, Marker marker, CharSequence message, Throwable t) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.privateConfig.filter((Level)var1_1, (Marker)var2_2, (CharSequence)var3_3, t);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isEnabled(Level level, Marker marker, Object message, Throwable t) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.privateConfig.filter((Level)var1_1, (Marker)var2_2, var3_3, t);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isEnabled(Level level, Marker marker, Message message, Throwable t) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.privateConfig.filter((Level)var1_1, (Marker)var2_2, (Message)var3_3, t);
    }

    /*
     * WARNING - void declaration
     */
    public void addAppender(Appender appender) {
        void var1_1;
        this.privateConfig.config.addLoggerAppender(this, (Appender)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void removeAppender(Appender appender) {
        void var1_1;
        this.privateConfig.loggerConfig.removeAppender(var1_1.getName());
    }

    public Map<String, Appender> getAppenders() {
        return this.privateConfig.loggerConfig.getAppenders();
    }

    /*
     * WARNING - void declaration
     */
    public Iterator<Filter> getFilters() {
        void var2_2;
        void var1_1;
        Filter filter = ((AbstractFilterable)this.privateConfig.loggerConfig).getFilter();
        if (filter == null) {
            return Collections.emptyIterator();
        }
        if (filter instanceof CompositeFilter) {
            return ((CompositeFilter)filter).iterator();
        }
        ArrayList<void> filters = new ArrayList<void>();
        filters.add(var1_1);
        return var2_2.iterator();
    }

    public Level getLevel() {
        return this.privateConfig.loggerConfigLevel;
    }

    /*
     * WARNING - void declaration
     */
    public int filterCount() {
        Filter filter = ((AbstractFilterable)this.privateConfig.loggerConfig).getFilter();
        if (filter == null) {
            return 0;
        }
        if (filter instanceof CompositeFilter) {
            void var1_1;
            return ((CompositeFilter)var1_1).size();
        }
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    public void addFilter(Filter filter) {
        void var1_1;
        this.privateConfig.config.addLoggerFilter(this, (Filter)var1_1);
    }

    public boolean isAdditive() {
        return this.privateConfig.loggerConfig.isAdditive();
    }

    /*
     * WARNING - void declaration
     */
    public void setAdditive(boolean additive) {
        void var1_1;
        this.privateConfig.config.setLoggerAdditive(this, (boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public LogBuilder atLevel(Level level) {
        void var1_1;
        if (this.privateConfig.hasFilter()) {
            return this.getLogBuilder(level);
        }
        return super.atLevel((Level)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void updateConfiguration(Configuration newConfig) {
        void var1_1;
        this.privateConfig = new PrivateConfig(this, (Configuration)var1_1, this);
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var2_2;
        void var1_1;
        String nameLevel = this.getName() + ':' + this.getLevel();
        if (this.context == null) {
            return nameLevel;
        }
        String contextName = this.context.getName();
        if (contextName == null) {
            return nameLevel;
        }
        return (String)var1_1 + " in " + (String)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        Logger that = (Logger)((Object)o);
        return this.getName().equals(var1_1.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    protected static class LoggerProxy
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final MessageFactory messageFactory;

        /*
         * WARNING - void declaration
         */
        public LoggerProxy(String name, MessageFactory messageFactory) {
            void var2_2;
            void var1_1;
            this.name = var1_1;
            this.messageFactory = var2_2;
        }

        protected Object readResolve() throws ObjectStreamException {
            return new Logger(LoggerContext.getContext(), this.name, this.messageFactory);
        }
    }

    protected class PrivateConfig {
        public final LoggerConfig loggerConfig;
        public final Configuration config;
        private final Level loggerConfigLevel;
        private final int intLevel;
        private final Logger logger;
        private final boolean requiresLocation;
        final /* synthetic */ Logger this$0;

        /*
         * WARNING - void declaration
         */
        public PrivateConfig(Logger this$0, Configuration config, Logger logger) {
            void var3_3;
            void var1_1;
            void var2_2;
            this.this$0 = this$0;
            this.config = config;
            this.loggerConfig = var2_2.getLoggerConfig(var1_1.getName());
            this.loggerConfigLevel = this.loggerConfig.getLevel();
            this.intLevel = this.loggerConfigLevel.intLevel();
            this.logger = var3_3;
            this.requiresLocation = this.loggerConfig.requiresLocation();
        }

        /*
         * WARNING - void declaration
         */
        public PrivateConfig(Logger this$0, PrivateConfig pc, Level level) {
            void var2_2;
            void var3_3;
            void var1_1;
            this.this$0 = var1_1;
            this.config = pc.config;
            this.loggerConfig = pc.loggerConfig;
            this.loggerConfigLevel = var3_3;
            this.intLevel = this.loggerConfigLevel.intLevel();
            this.logger = var2_2.logger;
            this.requiresLocation = this.loggerConfig.requiresLocation();
        }

        /*
         * WARNING - void declaration
         */
        public PrivateConfig(Logger this$0, PrivateConfig pc, LoggerConfig lc) {
            void var2_2;
            void var3_3;
            void var1_1;
            this.this$0 = var1_1;
            this.config = pc.config;
            this.loggerConfig = lc;
            this.loggerConfigLevel = var3_3.getLevel();
            this.intLevel = this.loggerConfigLevel.intLevel();
            this.logger = var2_2.logger;
            this.requiresLocation = this.loggerConfig.requiresLocation();
        }

        /*
         * WARNING - void declaration
         */
        public void logEvent(LogEvent event) {
            void var1_1;
            this.loggerConfig.log((LogEvent)var1_1);
        }

        boolean hasFilter() {
            return this.config.getFilter() != null;
        }

        /*
         * WARNING - void declaration
         */
        boolean filter(Level level, Marker marker, String msg) {
            void var1_1;
            void var3_3;
            Filter.Result r;
            Filter filter = this.config.getFilter();
            if (filter != null && (r = filter.filter(this.logger, level, marker, (String)var3_3)) != Filter.Result.NEUTRAL) {
                void var2_2;
                return var2_2 == Filter.Result.ACCEPT;
            }
            return level != null && this.intLevel >= var1_1.intLevel();
        }

        /*
         * WARNING - void declaration
         */
        boolean filter(Level level, Marker marker, String msg, Throwable t) {
            void var1_1;
            void var3_3;
            Filter.Result r;
            Filter filter = this.config.getFilter();
            if (filter != null && (r = filter.filter(this.logger, level, marker, var3_3, t)) != Filter.Result.NEUTRAL) {
                void var2_2;
                return var2_2 == Filter.Result.ACCEPT;
            }
            return level != null && this.intLevel >= var1_1.intLevel();
        }

        /*
         * WARNING - void declaration
         */
        boolean filter(Level level, Marker marker, String msg, Object ... p1) {
            void var1_1;
            void var3_3;
            Filter.Result r;
            Filter filter = this.config.getFilter();
            if (filter != null && (r = filter.filter(this.logger, level, marker, (String)var3_3, p1)) != Filter.Result.NEUTRAL) {
                void var2_2;
                return var2_2 == Filter.Result.ACCEPT;
            }
            return level != null && this.intLevel >= var1_1.intLevel();
        }

        /*
         * WARNING - void declaration
         */
        boolean filter(Level level, Marker marker, String msg, Object p0) {
            void var1_1;
            void var3_3;
            Filter.Result r;
            Filter filter = this.config.getFilter();
            if (filter != null && (r = filter.filter(this.logger, level, marker, (String)var3_3, p0)) != Filter.Result.NEUTRAL) {
                void var2_2;
                return var2_2 == Filter.Result.ACCEPT;
            }
            return level != null && this.intLevel >= var1_1.intLevel();
        }

        /*
         * WARNING - void declaration
         */
        boolean filter(Level level, Marker marker, String msg, Object p0, Object p1) {
            void var1_1;
            void var3_3;
            Filter.Result r;
            Filter filter = this.config.getFilter();
            if (filter != null && (r = filter.filter(this.logger, level, marker, (String)var3_3, p0, p1)) != Filter.Result.NEUTRAL) {
                void var2_2;
                return var2_2 == Filter.Result.ACCEPT;
            }
            return level != null && this.intLevel >= var1_1.intLevel();
        }

        /*
         * WARNING - void declaration
         */
        boolean filter(Level level, Marker marker, String msg, Object p0, Object p1, Object p2) {
            void var1_1;
            void var3_3;
            Filter.Result r;
            Filter filter = this.config.getFilter();
            if (filter != null && (r = filter.filter(this.logger, level, marker, (String)var3_3, p0, p1, p2)) != Filter.Result.NEUTRAL) {
                void var2_2;
                return var2_2 == Filter.Result.ACCEPT;
            }
            return level != null && this.intLevel >= var1_1.intLevel();
        }

        /*
         * WARNING - void declaration
         */
        boolean filter(Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3) {
            void var1_1;
            void var3_3;
            Filter.Result r;
            Filter filter = this.config.getFilter();
            if (filter != null && (r = filter.filter(this.logger, level, marker, (String)var3_3, p0, p1, p2, p3)) != Filter.Result.NEUTRAL) {
                void var2_2;
                return var2_2 == Filter.Result.ACCEPT;
            }
            return level != null && this.intLevel >= var1_1.intLevel();
        }

        /*
         * WARNING - void declaration
         */
        boolean filter(Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4) {
            void var1_1;
            void var3_3;
            Filter.Result r;
            Filter filter = this.config.getFilter();
            if (filter != null && (r = filter.filter(this.logger, level, marker, (String)var3_3, p0, p1, p2, p3, p4)) != Filter.Result.NEUTRAL) {
                void var2_2;
                return var2_2 == Filter.Result.ACCEPT;
            }
            return level != null && this.intLevel >= var1_1.intLevel();
        }

        /*
         * WARNING - void declaration
         */
        boolean filter(Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
            void var1_1;
            void var3_3;
            Filter.Result r;
            Filter filter = this.config.getFilter();
            if (filter != null && (r = filter.filter(this.logger, level, marker, (String)var3_3, p0, p1, p2, p3, p4, p5)) != Filter.Result.NEUTRAL) {
                void var2_2;
                return var2_2 == Filter.Result.ACCEPT;
            }
            return level != null && this.intLevel >= var1_1.intLevel();
        }

        /*
         * WARNING - void declaration
         */
        boolean filter(Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
            void var1_1;
            void var3_3;
            Filter.Result r;
            Filter filter = this.config.getFilter();
            if (filter != null && (r = filter.filter(this.logger, level, marker, (String)var3_3, p0, p1, p2, p3, p4, p5, p6)) != Filter.Result.NEUTRAL) {
                void var2_2;
                return var2_2 == Filter.Result.ACCEPT;
            }
            return level != null && this.intLevel >= var1_1.intLevel();
        }

        /*
         * WARNING - void declaration
         */
        boolean filter(Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
            void var1_1;
            void var3_3;
            Filter.Result r;
            Filter filter = this.config.getFilter();
            if (filter != null && (r = filter.filter(this.logger, level, marker, (String)var3_3, p0, p1, p2, p3, p4, p5, p6, p7)) != Filter.Result.NEUTRAL) {
                void var2_2;
                return var2_2 == Filter.Result.ACCEPT;
            }
            return level != null && this.intLevel >= var1_1.intLevel();
        }

        /*
         * WARNING - void declaration
         */
        boolean filter(Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
            void var1_1;
            void var3_3;
            Filter.Result r;
            Filter filter = this.config.getFilter();
            if (filter != null && (r = filter.filter(this.logger, level, marker, (String)var3_3, p0, p1, p2, p3, p4, p5, p6, p7, p8)) != Filter.Result.NEUTRAL) {
                void var2_2;
                return var2_2 == Filter.Result.ACCEPT;
            }
            return level != null && this.intLevel >= var1_1.intLevel();
        }

        /*
         * WARNING - void declaration
         */
        boolean filter(Level level, Marker marker, String msg, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
            void var1_1;
            void var3_3;
            Filter.Result r;
            Filter filter = this.config.getFilter();
            if (filter != null && (r = filter.filter(this.logger, level, marker, (String)var3_3, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9)) != Filter.Result.NEUTRAL) {
                void var2_2;
                return var2_2 == Filter.Result.ACCEPT;
            }
            return level != null && this.intLevel >= var1_1.intLevel();
        }

        /*
         * WARNING - void declaration
         */
        boolean filter(Level level, Marker marker, CharSequence msg, Throwable t) {
            void var1_1;
            void var3_3;
            Filter.Result r;
            Filter filter = this.config.getFilter();
            if (filter != null && (r = filter.filter(this.logger, level, marker, var3_3, t)) != Filter.Result.NEUTRAL) {
                void var2_2;
                return var2_2 == Filter.Result.ACCEPT;
            }
            return level != null && this.intLevel >= var1_1.intLevel();
        }

        /*
         * WARNING - void declaration
         */
        boolean filter(Level level, Marker marker, Object msg, Throwable t) {
            void var1_1;
            void var3_3;
            Filter.Result r;
            Filter filter = this.config.getFilter();
            if (filter != null && (r = filter.filter(this.logger, level, marker, var3_3, t)) != Filter.Result.NEUTRAL) {
                void var2_2;
                return var2_2 == Filter.Result.ACCEPT;
            }
            return level != null && this.intLevel >= var1_1.intLevel();
        }

        /*
         * WARNING - void declaration
         */
        boolean filter(Level level, Marker marker, Message msg, Throwable t) {
            void var1_1;
            void var3_3;
            Filter.Result r;
            Filter filter = this.config.getFilter();
            if (filter != null && (r = filter.filter(this.logger, level, marker, (Message)var3_3, t)) != Filter.Result.NEUTRAL) {
                void var2_2;
                return var2_2 == Filter.Result.ACCEPT;
            }
            return level != null && this.intLevel >= var1_1.intLevel();
        }

        /*
         * WARNING - void declaration
         */
        public String toString() {
            void var1_1;
            StringBuilder builder = new StringBuilder();
            builder.append("PrivateConfig [loggerConfig=");
            builder.append(this.loggerConfig);
            builder.append(", config=");
            builder.append(this.config);
            builder.append(", loggerConfigLevel=");
            builder.append(this.loggerConfigLevel);
            builder.append(", intLevel=");
            builder.append(this.intLevel);
            builder.append(", logger=");
            builder.append((Object)this.logger);
            builder.append("]");
            return var1_1.toString();
        }
    }
}

