/*
 * Decompiled with CFR 0.152.
 */
package me.him188.ani.app.tools.update;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.io.files.Path;
import me.him188.ani.app.platform.Context;
import me.him188.ani.app.platform.ExecutableDirectoryDetector;
import me.him188.ani.app.tools.update.DesktopUpdateInstaller;
import me.him188.ani.app.tools.update.InstallationFailureReason;
import me.him188.ani.app.tools.update.InstallationResult;
import me.him188.ani.utils.io.Path_jvmKt;
import me.him188.ani.utils.logging.LoggerKt;
import me.him188.ani.utils.logging.LoggerKt_jvmKt;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\f\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\n\u0010\b\u001a\u00060\u0006j\u0002`\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ?\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J7\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001c\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u0003J#\u0010!\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u000f2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u001eH\u0002\u00a2\u0006\u0004\b!\u0010\"R\u0018\u0010%\u001a\u00060#j\u0002`$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&"}, d2={"Lme/him188/ani/app/tools/update/MacOSUpdateInstaller;", "Lme/him188/ani/app/tools/update/DesktopUpdateInstaller;", "<init>", "()V", "Lme/him188/ani/utils/io/SystemPath;", "file", "Lme/him188/ani/app/platform/Context;", "Lme/him188/ani/app/platform/ContextMP;", "context", "Lme/him188/ani/app/tools/update/InstallationResult;", "install-LNMXN-E", "(Lkotlinx/io/files/Path;Lme/him188/ani/app/platform/Context;)Lme/him188/ani/app/tools/update/InstallationResult;", "install", "", "oldPid", "", "dmgFilePath", "convertedDmgFilePath", "mountPath", "appName", "targetParent", "generateShellScriptForDmg", "(JLjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "zipFilePath", "unzipPath", "generateShellScriptForZip", "(JLjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "", "deleteOldUpdater", "message", "Lme/him188/ani/app/tools/update/InstallationFailureReason;", "reason", "Lme/him188/ani/app/tools/update/InstallationResult$Failed;", "failed", "(Ljava/lang/String;Lme/him188/ani/app/tools/update/InstallationFailureReason;)Lme/him188/ani/app/tools/update/InstallationResult$Failed;", "Lorg/slf4j/Logger;", "Lme/him188/ani/utils/logging/Logger;", "logger", "Lorg/slf4j/Logger;"})
@SourceDebugExtension(value={"SMAP\nDesktopUpdateInstaller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesktopUpdateInstaller.kt\nme/him188/ani/app/tools/update/MacOSUpdateInstaller\n+ 2 LoggerKt.kt\nme/him188/ani/utils/logging/LoggerKt\n+ 3 LoggerKt.jvm.kt\nme/him188/ani/utils/logging/LoggerKt_jvmKt\n*L\n1#1,337:1\n86#2,4:338\n86#2,4:342\n86#2,4:346\n86#2,4:350\n86#2,4:354\n86#2,4:358\n110#2,2:362\n41#3:364\n*S KotlinDebug\n*F\n+ 1 DesktopUpdateInstaller.kt\nme/him188/ani/app/tools/update/MacOSUpdateInstaller\n*L\n49#1:338,4\n52#1:342,4\n77#1:346,4\n88#1:350,4\n116#1:354,4\n122#1:358,4\n274#1:362,2\n46#1:364\n*E\n"})
public final class MacOSUpdateInstaller
implements DesktopUpdateInstaller {
    public static final MacOSUpdateInstaller INSTANCE = new MacOSUpdateInstaller();
    private static final Logger logger;
    public static final int $stable;

    private MacOSUpdateInstaller() {
    }

    /*
     * WARNING - void declaration
     */
    public final InstallationResult install-LNMXN-E(Path path, Context context) {
        void var1_1;
        String string;
        Object object;
        Intrinsics.checkNotNullParameter((Object)path, (String)"$v$c$me-him188-ani-utils-io-SystemPath$-file$0");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Logger $this$info$iv = logger;
        if ($this$info$iv.isInfoEnabled()) {
            object = $this$info$iv;
            LoggerKt.info((Logger)object, (String)"Preparing to install update for macOS using external script.");
        }
        File contentsDir = ExecutableDirectoryDetector.Companion.getINSTANCE().getExecutableDirectory();
        Logger $this$info$iv2 = logger;
        if ($this$info$iv2.isInfoEnabled()) {
            object = $this$info$iv2;
            LoggerKt.info((Logger)object, (String)("contentsDir: " + contentsDir));
        }
        File file = contentsDir.getParentFile();
        if (file == null) {
            return (InstallationResult)this.failed("Cannot find .app dir", InstallationFailureReason.UNSUPPORTED_FILE_STRUCTURE);
        }
        File appDir = file;
        String string2 = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        if (!StringsKt.endsWith((String)string2, (String)".app", (boolean)true)) {
            return (InstallationResult)this.failed("Current directory is not inside a .app bundle: " + appDir, InstallationFailureReason.UNSUPPORTED_FILE_STRUCTURE);
        }
        File updateFile = Path_jvmKt.toFile-q3k9KfI((Path)path);
        if (!updateFile.exists()) {
            return (InstallationResult)MacOSUpdateInstaller.failed$default(this, "Update file does not exist: " + updateFile.getAbsolutePath(), null, 2, null);
        }
        String string3 = FilesKt.getExtension((File)updateFile).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        String extension = string3;
        if (!Intrinsics.areEqual((Object)string3, (Object)"dmg") && !Intrinsics.areEqual((Object)extension, (Object)"zip")) {
            return (InstallationResult)MacOSUpdateInstaller.failed$default(this, "Unsupported update file format: " + extension, null, 2, null);
        }
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        java.nio.file.Path path2 = Files.createTempDirectory("ani-macos-update-", Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"createTempDirectory(...)");
        File tempDir = path2.toFile();
        Logger $this$info$iv3 = logger;
        if ($this$info$iv3.isInfoEnabled()) {
            object = $this$info$iv3;
            LoggerKt.info((Logger)object, (String)("tempDir: " + tempDir.getAbsolutePath()));
        }
        File scriptFile = new File(tempDir, "macos-update.command");
        long oldPid = ProcessHandle.current().pid();
        String appName = appDir.getName();
        String targetParentDir = appDir.getParentFile().getAbsolutePath();
        object = extension;
        if (Intrinsics.areEqual((Object)object, (Object)"dmg")) {
            $this$info$iv = logger;
            if ($this$info$iv.isInfoEnabled()) {
                object = var2_2;
                LoggerKt.info((Logger)object, (String)("tempMountDir: " + tempDir.getAbsolutePath()));
            }
            String string4 = updateFile.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getAbsolutePath(...)");
            Intrinsics.checkNotNull((Object)tempDir);
            String string5 = FilesKt.resolve((File)tempDir, (String)"converted.dmg").getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getAbsolutePath(...)");
            String string6 = FilesKt.resolve((File)tempDir, (String)"mount").getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getAbsolutePath(...)");
            Intrinsics.checkNotNull((Object)appName);
            Intrinsics.checkNotNull((Object)targetParentDir);
            string = this.generateShellScriptForDmg(oldPid, string4, string5, string6, appName, targetParentDir);
        } else if (Intrinsics.areEqual((Object)object, (Object)"zip")) {
            void var3_4;
            String string7 = updateFile.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getAbsolutePath(...)");
            Intrinsics.checkNotNull((Object)tempDir);
            String string8 = FilesKt.resolve((File)tempDir, (String)"unzip").getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getAbsolutePath(...)");
            Intrinsics.checkNotNull((Object)appName);
            Intrinsics.checkNotNull((Object)targetParentDir);
            string = this.generateShellScriptForZip(oldPid, string7, string8, appName, (String)var3_4);
        } else {
            return (InstallationResult)MacOSUpdateInstaller.failed$default(this, "Unsupported file format: " + (String)var2_2, null, 2, null);
        }
        String scriptContent = string;
        FilesKt.writeText$default((File)scriptFile, (String)var1_1, null, (int)2, null);
        scriptFile.setExecutable(true);
        Logger $this$info$iv4 = logger;
        if ($this$info$iv4.isInfoEnabled()) {
            LoggerKt.info((Logger)$this$info$iv4, (String)("Launching update script: " + scriptFile.getAbsolutePath()));
        }
        Logger logger = new String[1];
        $this$info$iv4 = logger;
        logger[0] = scriptFile.getAbsolutePath();
        new ProcessBuilder((String[])$this$info$iv4).redirectOutput(new File(tempDir, "update-output.log")).redirectError(new File(tempDir, "update-error.log")).start();
        $this$info$iv4 = MacOSUpdateInstaller.logger;
        if ($this$info$iv4.isInfoEnabled()) {
            object = $this$info$iv4;
            LoggerKt.info((Logger)object, (String)"Exiting old instance.");
        }
        Thread.sleep(1000L);
        System.exit(0);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    /*
     * WARNING - void declaration
     */
    private final String generateShellScriptForDmg(long oldPid, String dmgFilePath, String convertedDmgFilePath, String mountPath, String appName, String targetParent) {
        void var1_1;
        void var3_2;
        return StringsKt.trimIndent((String)("\n            #!/usr/bin/env bash\n            set -euo pipefail\n\n            OLD_PID=" + oldPid + "\n            DMG_FILE=\"" + (String)var3_2 + "\"\n            MOUNT_DIR=\"" + mountPath + "\"\n            APP_NAME=\"" + appName + "\"\n            TARGET_PARENT=\"" + targetParent + "\"\n            NEW_DMG_FILE=\"" + convertedDmgFilePath + "\"\n\n            echo \"Update script for DMG started.\"\n            echo \"Will wait for process PID=" + (long)var1_1 + " to exit.\"\n\n            # 1) Wait for the old process to fully exit.\n            while kill -0 \"$OLD_PID\" 2>/dev/null; do\n              echo \"Waiting for old app process $OLD_PID to exit...\"\n              sleep 1\n            done\n\n            # 2) Convert the DMG to a CDR (UDTO format)\n            echo \"Converting DMG into CDR...\"\n            hdiutil convert \"$DMG_FILE\" -format UDTO -o \"$NEW_DMG_FILE\"\n\n            # 3) Mount the converted DMG\n            echo \"Mounting the DMG at $MOUNT_DIR ...\"\n            hdiutil attach \"${NEW_DMG_FILE}.cdr\" -nobrowse -noverify -noautoopen -mountpoint \"$MOUNT_DIR\"\n\n            # 4) Copy the updated .app from the DMG to the parent of the current .app\n            echo \"Copying updated app to $TARGET_PARENT ...\"\n            cp -R \"$MOUNT_DIR/$APP_NAME\" \"$TARGET_PARENT\"\n\n            # 5) Detach the DMG\n            echo \"Detaching the DMG...\"\n            hdiutil detach \"$MOUNT_DIR\" || echo \"Warning: failed to detach DMG.\"\n\n            # 6) Remove the com.apple.quarantine attribute\n            echo \"Removing quarantine...\"\n            xattr -r -d com.apple.quarantine \"$TARGET_PARENT/$APP_NAME\" || true\n\n            echo \"Cleaning up temporary mount directory...\"\n            rm -rf \"$MOUNT_DIR\"\n\n            # 7) Launch the newly copied app\n            echo \"Launching updated app: $TARGET_PARENT/$APP_NAME\"\n            open \"$TARGET_PARENT/$APP_NAME\"\n\n            echo \"Update script for DMG finished.\"\n        "));
    }

    /*
     * WARNING - void declaration
     */
    private final String generateShellScriptForZip(long oldPid, String zipFilePath, String unzipPath, String appName, String targetParent) {
        void var1_1;
        void var3_2;
        return StringsKt.trimIndent((String)("\n            #!/usr/bin/env bash\n            set -euo pipefail\n\n            OLD_PID=" + oldPid + "\n            ZIP_FILE=\"" + (String)var3_2 + "\"\n            UNZIP_DIR=\"" + unzipPath + "\"\n            APP_NAME=\"" + appName + "\"\n            TARGET_PARENT=\"" + targetParent + "\"\n\n            echo \"Update script for ZIP started.\"\n            echo \"Will wait for process PID=" + (long)var1_1 + " to exit.\"\n\n            # 1) Wait for the old process to fully exit.\n            while kill -0 \"$OLD_PID\" 2>/dev/null; do\n              echo \"Waiting for old app process $OLD_PID to exit...\"\n              sleep 1\n            done\n\n            # 2) Unzip the ZIP file into a temporary directory\n            echo \"Unzipping update file into $UNZIP_DIR ...\"\n            mkdir -p \"$UNZIP_DIR\"\n            unzip -q \"$ZIP_FILE\" -d \"$UNZIP_DIR\"\n\n            # 3) Within the unzipped folder, locate the .app folder\n            #    We'll assume the unzipped folder contains the correct .app we need, matching $APP_NAME\n            #    If the .zip file is structured differently, you'd adapt accordingly.\n            echo \"Looking for $APP_NAME inside $UNZIP_DIR ...\"\n            if [ ! -d \"$UNZIP_DIR/$APP_NAME\" ]; then\n              echo \"Error: Could not find $APP_NAME in the extracted zip.\"\n              exit 1\n            fi\n\n            # 4) Copy the updated .app to the parent of the current .app\n            echo \"Copying updated app to $TARGET_PARENT ...\"\n            cp -R \"$UNZIP_DIR/$APP_NAME\" \"$TARGET_PARENT\"\n\n            # 5) Remove the com.apple.quarantine attribute\n            echo \"Removing quarantine...\"\n            xattr -r -d com.apple.quarantine \"$TARGET_PARENT/$APP_NAME\" || true\n\n            # 6) Clean up the unzipped folder\n            echo \"Cleaning up temporary unzip directory...\"\n            rm -rf \"$UNZIP_DIR\"\n\n            # 7) Launch the newly copied app\n            echo \"Launching updated app: $TARGET_PARENT/$APP_NAME\"\n            open \"$TARGET_PARENT/$APP_NAME\"\n\n            echo \"Update script for ZIP finished.\"\n        "));
    }

    @Override
    public final void deleteOldUpdater() {
    }

    /*
     * WARNING - void declaration
     */
    private final InstallationResult.Failed failed(String message, InstallationFailureReason reason) {
        void var1_1;
        void var2_2;
        Logger logger = MacOSUpdateInstaller.logger;
        LoggerKt.error((Logger)logger, (String)message);
        InstallationFailureReason installationFailureReason = var2_2;
        if (installationFailureReason == null) {
            installationFailureReason = InstallationFailureReason.UNSUPPORTED_FILE_STRUCTURE;
        }
        return new InstallationResult.Failed(installationFailureReason, (String)var1_1);
    }

    static /* synthetic */ InstallationResult.Failed failed$default(MacOSUpdateInstaller macOSUpdateInstaller, String string, InstallationFailureReason installationFailureReason, int n, Object object) {
        if ((n & 2) != 0) {
            installationFailureReason = InstallationFailureReason.UNSUPPORTED_FILE_STRUCTURE;
        }
        return macOSUpdateInstaller.failed(string, installationFailureReason);
    }

    static {
        ILoggerFactory iLoggerFactory = LoggerFactory.getILoggerFactory();
        Intrinsics.checkNotNullExpressionValue((Object)iLoggerFactory, (String)"getILoggerFactory(...)");
        logger = LoggerKt_jvmKt.getLogger((ILoggerFactory)iLoggerFactory, MacOSUpdateInstaller.class);
        $stable = 8;
    }
}

