/*
 * Decompiled with CFR 0.152.
 */
package androidx.collection;

import androidx.collection.SparseArrayCompatKt;
import androidx.collection.internal.ContainerHelpersKt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001a\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0017\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0013\b\u0007\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010\n\u001a\u0004\u0018\u00018\u00002\u0006\u0010\t\u001a\u00020\u0003H\u0096\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\f\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u000f\u0010\rJ\u001f\u0010\u0012\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0006J!\u0010\u0015\u001a\u0004\u0018\u00018\u00002\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001c\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u000bR\u0016\u0010\u001e\u001a\u00020\u001d8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0016\u0010!\u001a\u00020 8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0016\u0010\u0017\u001a\u00020\u00038\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010#R\u001e\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010%0$8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010'"}, d2={"Landroidx/collection/SparseArrayCompat;", "E", "", "", "initialCapacity", "<init>", "(I)V", "clone", "()Landroidx/collection/SparseArrayCompat;", "key", "get", "(I)Ljava/lang/Object;", "indexOfKey", "(I)I", "index", "keyAt", "value", "", "put", "(ILjava/lang/Object;)V", "removeAt", "replace", "(ILjava/lang/Object;)Ljava/lang/Object;", "size", "()I", "", "toString", "()Ljava/lang/String;", "valueAt", "", "garbage", "Z", "", "keys", "[I", "I", "", "", "values", "[Ljava/lang/Object;"})
@SourceDebugExtension(value={"SMAP\nSparseArrayCompat.jvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SparseArrayCompat.jvm.kt\nandroidx/collection/SparseArrayCompat\n+ 2 SparseArrayCompat.kt\nandroidx/collection/SparseArrayCompatKt\n+ 3 CollectionPlatformUtils.jvm.kt\nandroidx/collection/CollectionPlatformUtils\n*L\n1#1,263:1\n250#2,9:264\n263#2,5:273\n271#2,5:278\n279#2,7:283\n294#2,9:290\n327#2,30:299\n360#2,2:329\n327#2,37:331\n367#2,3:368\n327#2,30:371\n371#2:401\n376#2,4:402\n383#2:406\n387#2,4:407\n395#2,5:411\n401#2:417\n406#2,5:418\n414#2,4:423\n422#2,9:427\n435#2:436\n440#2:437\n422#2,9:438\n445#2,8:447\n456#2,17:455\n476#2,21:472\n24#3:416\n*S KotlinDebug\n*F\n+ 1 SparseArrayCompat.jvm.kt\nandroidx/collection/SparseArrayCompat\n*L\n123#1:264,9\n126#1:273,5\n135#1:278,5\n144#1:283,7\n155#1:290,9\n161#1:299,30\n168#1:329,2\n168#1:331,37\n179#1:368,3\n179#1:371,30\n179#1:401\n182#1:402,4\n198#1:406\n204#1:407,4\n210#1:411,5\n210#1:417\n216#1:418,5\n226#1:423,4\n238#1:427,9\n241#1:436\n244#1:437\n244#1:438,9\n247#1:447,8\n253#1:455,17\n261#1:472,21\n210#1:416\n*E\n"})
public class SparseArrayCompat<E>
implements Cloneable {
    @JvmField
    public /* synthetic */ boolean garbage;
    @JvmField
    public /* synthetic */ int[] keys;
    @JvmField
    public /* synthetic */ Object[] values;
    @JvmField
    public /* synthetic */ int size;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public SparseArrayCompat(int initialCapacity) {
        void var1_1;
        if (initialCapacity == 0) {
            this.keys = ContainerHelpersKt.EMPTY_INTS;
            this.values = ContainerHelpersKt.EMPTY_OBJECTS;
            return;
        }
        int capacity = ContainerHelpersKt.idealIntArraySize(initialCapacity);
        this.keys = new int[capacity];
        this.values = new Object[var1_1];
    }

    public /* synthetic */ SparseArrayCompat(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        this(n);
    }

    /*
     * WARNING - void declaration
     */
    public SparseArrayCompat<E> clone() {
        void var1_1;
        Object object = super.clone();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type androidx.collection.SparseArrayCompat<E of androidx.collection.SparseArrayCompat>");
        SparseArrayCompat clone = (SparseArrayCompat)object;
        ((SparseArrayCompat)object).keys = (int[])this.keys.clone();
        clone.values = (Object[])this.values.clone();
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public E get(int key) {
        void var1_1;
        return SparseArrayCompatKt.commonGet(this, (int)var1_1);
    }

    public void removeAt(int index) {
        SparseArrayCompat $this$commonRemoveAt$iv = this;
        if ($this$commonRemoveAt$iv.values[index] != SparseArrayCompatKt.access$getDELETED$p()) {
            $this$commonRemoveAt$iv.values[var1_1] = SparseArrayCompatKt.access$getDELETED$p();
            var2_2.garbage = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    public E replace(int key, E value) {
        SparseArrayCompat $this$commonReplace$iv = this;
        int index$iv = $this$commonReplace$iv.indexOfKey(key);
        if (index$iv >= 0) {
            void var2_2;
            Object oldValue$iv = $this$commonReplace$iv.values[index$iv];
            var3_3.values[var1_1] = var2_2;
            return (E)oldValue$iv;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void put(int key, E value) {
        void var2_2;
        void var1_1;
        SparseArrayCompat $this$commonPut$iv = this;
        int i$iv = ContainerHelpersKt.binarySearch($this$commonPut$iv.keys, $this$commonPut$iv.size, key);
        if (i$iv >= 0) {
            $this$commonPut$iv.values[i$iv] = value;
            return;
        }
        if ((i$iv ^= 0xFFFFFFFF) < $this$commonPut$iv.size && $this$commonPut$iv.values[i$iv] == SparseArrayCompatKt.access$getDELETED$p()) {
            $this$commonPut$iv.keys[i$iv] = key;
            $this$commonPut$iv.values[i$iv] = value;
            return;
        }
        if ($this$commonPut$iv.garbage && $this$commonPut$iv.size >= $this$commonPut$iv.keys.length) {
            SparseArrayCompatKt.access$gc($this$commonPut$iv);
            i$iv = ~ContainerHelpersKt.binarySearch($this$commonPut$iv.keys, $this$commonPut$iv.size, key);
        }
        if ($this$commonPut$iv.size >= $this$commonPut$iv.keys.length) {
            int n$iv = ContainerHelpersKt.idealIntArraySize($this$commonPut$iv.size + 1);
            int[] nArray = Arrays.copyOf($this$commonPut$iv.keys, n$iv);
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
            $this$commonPut$iv.keys = nArray;
            Object[] objectArray = Arrays.copyOf($this$commonPut$iv.values, n$iv);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
            $this$commonPut$iv.values = objectArray;
        }
        if ($this$commonPut$iv.size - i$iv != 0) {
            ArraysKt.copyInto((int[])$this$commonPut$iv.keys, (int[])$this$commonPut$iv.keys, (int)(i$iv + 1), (int)i$iv, (int)$this$commonPut$iv.size);
            ArraysKt.copyInto((Object[])$this$commonPut$iv.values, (Object[])$this$commonPut$iv.values, (int)(i$iv + 1), (int)i$iv, (int)$this$commonPut$iv.size);
        }
        $this$commonPut$iv.keys[i$iv] = var1_1;
        $this$commonPut$iv.values[i$iv] = var2_2;
        int n = $this$commonPut$iv.size;
        var3_3.size = n + 1;
    }

    /*
     * WARNING - void declaration
     */
    public int size() {
        void var1_1;
        SparseArrayCompat $this$commonSize$iv = this;
        if ($this$commonSize$iv.garbage) {
            SparseArrayCompatKt.access$gc($this$commonSize$iv);
        }
        return var1_1.size;
    }

    /*
     * WARNING - void declaration
     */
    public int keyAt(int index) {
        void var1_1;
        void var2_2;
        SparseArrayCompat $this$commonKeyAt$iv = this;
        if ($this$commonKeyAt$iv.garbage) {
            SparseArrayCompatKt.access$gc($this$commonKeyAt$iv);
        }
        return var2_2.keys[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public E valueAt(int index) {
        void var1_1;
        void var2_2;
        SparseArrayCompat $this$commonValueAt$iv = this;
        if ($this$commonValueAt$iv.garbage) {
            SparseArrayCompatKt.access$gc($this$commonValueAt$iv);
        }
        if (index >= $this$commonValueAt$iv.values.length) {
            throw (IndexOutOfBoundsException)new ArrayIndexOutOfBoundsException();
        }
        return (E)var2_2.values[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public int indexOfKey(int key) {
        void var1_1;
        void var2_2;
        SparseArrayCompat $this$commonIndexOfKey$iv = this;
        if ($this$commonIndexOfKey$iv.garbage) {
            SparseArrayCompatKt.access$gc($this$commonIndexOfKey$iv);
        }
        return ContainerHelpersKt.binarySearch($this$commonIndexOfKey$iv.keys, var2_2.size, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var2_2;
        SparseArrayCompat $this$commonToString$iv = this;
        if ($this$commonToString$iv.size() <= 0) {
            return "{}";
        }
        StringBuilder buffer$iv = new StringBuilder($this$commonToString$iv.size * 28);
        buffer$iv.append('{');
        int n = $this$commonToString$iv.size;
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            if (i$iv > 0) {
                buffer$iv.append(", ");
            }
            int key$iv = $this$commonToString$iv.keyAt(i$iv);
            buffer$iv.append(key$iv);
            buffer$iv.append('=');
            E value$iv = $this$commonToString$iv.valueAt(i$iv);
            if (value$iv != $this$commonToString$iv) {
                buffer$iv.append(value$iv);
                continue;
            }
            buffer$iv.append("(this Map)");
        }
        buffer$iv.append('}');
        String string = var2_2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JvmOverloads
    public SparseArrayCompat() {
        this(0, 1, null);
    }
}

