/*
 * Decompiled with CFR 0.152.
 */
package androidx.collection;

import androidx.collection.internal.ContainerHelpersKt;
import androidx.collection.internal.RuntimeHelpersKt;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b(\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\b\u0017\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B\u0013\b\u0007\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u000eJ\u0017\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0007J\u001a\u0010\u0014\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u0096\u0002\u00a2\u0006\u0004\b\u0014\u0010\u000eJ\u001a\u0010\u0015\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u000b\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J!\u0010\u0018\u001a\u00028\u00012\b\u0010\u000b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0017\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001a\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001f\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u000f\u0010!\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b!\u0010\u001bJ\u0017\u0010#\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00028\u0001H\u0001\u00a2\u0006\u0004\b\"\u0010 J\u000f\u0010$\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b$\u0010%J\u0017\u0010'\u001a\u00028\u00002\u0006\u0010&\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b'\u0010(J!\u0010)\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b)\u0010\u0019J!\u0010*\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b*\u0010\u0019J\u0019\u0010+\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u000b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b+\u0010\u0016J\u001f\u0010+\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b+\u0010,J\u0017\u0010-\u001a\u00028\u00012\u0006\u0010&\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b-\u0010(J!\u0010.\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b.\u0010\u0019J'\u0010.\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010/\u001a\u00028\u00012\u0006\u00100\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b.\u00101J\u001f\u00102\u001a\u00028\u00012\u0006\u0010&\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b2\u00103J\u000f\u00104\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b4\u0010\u001bJ\u000f\u00106\u001a\u000205H\u0016\u00a2\u0006\u0004\b6\u00107J\u0017\u00108\u001a\u00028\u00012\u0006\u0010&\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b8\u0010(R\u001e\u0010:\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u0003098\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b:\u0010;R\u0016\u0010=\u001a\u00020<8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b=\u0010>R\u0016\u00104\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b4\u0010?"}, d2={"Landroidx/collection/SimpleArrayMap;", "K", "V", "", "", "capacity", "<init>", "(I)V", "", "clear", "()V", "key", "", "containsKey", "(Ljava/lang/Object;)Z", "value", "containsValue", "minimumCapacity", "ensureCapacity", "other", "equals", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "defaultValue", "getOrDefault", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "hashCode", "()I", "hash", "indexOf", "(Ljava/lang/Object;I)I", "indexOfKey", "(Ljava/lang/Object;)I", "indexOfNull", "__restricted$indexOfValue", "indexOfValue", "isEmpty", "()Z", "index", "keyAt", "(I)Ljava/lang/Object;", "put", "putIfAbsent", "remove", "(Ljava/lang/Object;Ljava/lang/Object;)Z", "removeAt", "replace", "oldValue", "newValue", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Z", "setValueAt", "(ILjava/lang/Object;)Ljava/lang/Object;", "size", "", "toString", "()Ljava/lang/String;", "valueAt", "", "array", "[Ljava/lang/Object;", "", "hashes", "[I", "I"})
@SourceDebugExtension(value={"SMAP\nSimpleArrayMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleArrayMap.kt\nandroidx/collection/SimpleArrayMap\n+ 2 RuntimeHelpers.kt\nandroidx/collection/internal/RuntimeHelpersKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,761:1\n299#1,5:762\n299#1,5:767\n59#2,5:772\n59#2,5:777\n59#2,5:782\n59#2,5:788\n1#3:787\n*S KotlinDebug\n*F\n+ 1 SimpleArrayMap.kt\nandroidx/collection/SimpleArrayMap\n*L\n278#1:762,5\n294#1:767,5\n315#1:772,5\n330#1:777,5\n346#1:782,5\n512#1:788,5\n*E\n"})
public class SimpleArrayMap<K, V> {
    private int[] hashes;
    private Object[] array;
    private int size;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public SimpleArrayMap(int capacity) {
        void var1_1;
        this.hashes = capacity == 0 ? ContainerHelpersKt.EMPTY_INTS : new int[capacity];
        this.array = capacity == 0 ? ContainerHelpersKt.EMPTY_OBJECTS : new Object[var1_1 << 1];
    }

    public /* synthetic */ SimpleArrayMap(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        this(n);
    }

    private final int indexOf(K key, int hash) {
        int end;
        int n = this.size;
        if (n == 0) {
            return -1;
        }
        int index = ContainerHelpersKt.binarySearch(this.hashes, n, hash);
        if (index < 0) {
            return index;
        }
        if (Intrinsics.areEqual(key, (Object)this.array[index << 1])) {
            return index;
        }
        for (end = index + 1; end < n && this.hashes[end] == hash; ++end) {
            if (!Intrinsics.areEqual(key, (Object)this.array[end << 1])) continue;
            return end;
        }
        for (int i = index - 1; i >= 0 && this.hashes[i] == hash; --i) {
            if (!Intrinsics.areEqual(key, (Object)this.array[i << 1])) continue;
            return i;
        }
        return ~end;
    }

    /*
     * WARNING - void declaration
     */
    private final int indexOfNull() {
        void var3_3;
        int n = this.size;
        if (n == 0) {
            return -1;
        }
        int index = ContainerHelpersKt.binarySearch(this.hashes, n, 0);
        if (index < 0) {
            return index;
        }
        if (this.array[index << 1] == null) {
            return index;
        }
        for (int end = index + 1; end < n && this.hashes[end] == 0; ++end) {
            if (this.array[end << 1] != null) continue;
            return end;
        }
        for (void i = var2_2 - true; i >= 0 && this.hashes[i] == 0; --i) {
            if (this.array[i << 1] != null) continue;
            return (int)i;
        }
        return (int)(~var3_3);
    }

    public void clear() {
        if (this.size > 0) {
            this.hashes = ContainerHelpersKt.EMPTY_INTS;
            this.array = ContainerHelpersKt.EMPTY_OBJECTS;
            this.size = 0;
        }
        if (this.size > 0) {
            throw new ConcurrentModificationException();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void ensureCapacity(int minimumCapacity) {
        void var2_2;
        int osize = this.size;
        if (this.hashes.length < minimumCapacity) {
            void var1_1;
            int[] nArray = Arrays.copyOf(this.hashes, minimumCapacity);
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
            this.hashes = nArray;
            Object[] objectArray = Arrays.copyOf(this.array, (int)(var1_1 << 1));
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
            this.array = objectArray;
        }
        if (this.size != var2_2) {
            throw new ConcurrentModificationException();
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean containsKey(K key) {
        void var1_1;
        return this.indexOfKey(var1_1) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    public int indexOfKey(K key) {
        void var1_1;
        if (key == null) {
            return this.indexOfNull();
        }
        void v0 = var1_1;
        return this.indexOf(v0, v0.hashCode());
    }

    @JvmName(name="__restricted$indexOfValue")
    public final int __restricted$indexOfValue(V value) {
        int n = this.size << 1;
        Object[] array = this.array;
        if (value == null) {
            for (int i = 1; i < n; i += 2) {
                if (array[i] != null) continue;
                return i >> 1;
            }
        } else {
            for (int i = 1; i < n; i += 2) {
                if (!Intrinsics.areEqual(value, (Object)array[i])) continue;
                return i >> 1;
            }
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean containsValue(V value) {
        void var1_1;
        return this.__restricted$indexOfValue(var1_1) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    public V get(K key) {
        SimpleArrayMap this_$iv = this;
        int index$iv = this_$iv.indexOfKey(key);
        if (index$iv >= 0) {
            void var1_2;
            void var2_3;
            return (V)var2_3.array[(var1_2 << 1) + true];
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public V getOrDefault(Object key, V defaultValue) {
        void var2_3;
        SimpleArrayMap this_$iv = this;
        int index$iv = this_$iv.indexOfKey(key);
        if (index$iv >= 0) {
            void var1_2;
            void var3_4;
            return (V)var3_4.array[(var1_2 << 1) + true];
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public K keyAt(int index) {
        void var1_1;
        boolean bl;
        boolean bl2 = index >= 0 ? index < this.size : (bl = false);
        if (!bl2) {
            RuntimeHelpersKt.throwIllegalArgumentException("Expected index to be within 0..size()-1, but was " + index);
        }
        return (K)this.array[var1_1 << 1];
    }

    /*
     * WARNING - void declaration
     */
    public V valueAt(int index) {
        void var1_1;
        boolean bl;
        boolean bl2 = index >= 0 ? index < this.size : (bl = false);
        if (!bl2) {
            RuntimeHelpersKt.throwIllegalArgumentException("Expected index to be within 0..size()-1, but was " + index);
        }
        return (V)this.array[(var1_1 << 1) + true];
    }

    /*
     * WARNING - void declaration
     */
    public V setValueAt(int index, V value) {
        void var1_2;
        void var2_3;
        int n;
        int n2 = index >= 0 ? (index < this.size ? 1 : 0) : (n = 0);
        if (n2 == 0) {
            RuntimeHelpersKt.throwIllegalArgumentException("Expected index to be within 0..size()-1, but was " + index);
        }
        int indexInArray = (index << 1) + 1;
        Object old = this.array[indexInArray];
        this.array[n] = var2_3;
        return var1_2;
    }

    public boolean isEmpty() {
        return this.size <= 0;
    }

    /*
     * WARNING - void declaration
     */
    public V put(K key, V value) {
        void var2_2;
        void var1_1;
        void var3_3;
        int index;
        int n;
        int osize = this.size;
        K k = key;
        int hash = k != null ? k.hashCode() : 0;
        K k2 = key;
        if (k2 != null) {
            K it = k2;
            n = this.indexOf(it, hash);
        } else {
            n = index = this.indexOfNull();
        }
        if (n >= 0) {
            index = (index << 1) + 1;
            Object old = this.array[index];
            this.array[index] = value;
            return (V)old;
        }
        index ^= 0xFFFFFFFF;
        if (osize >= this.hashes.length) {
            int n2;
            if (osize >= 8) {
                int n3 = osize;
                n2 = n3 + (n3 >> 1);
            } else {
                n2 = osize >= 4 ? 8 : 4;
            }
            int n4 = n2;
            int[] nArray = Arrays.copyOf(this.hashes, n4);
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
            this.hashes = nArray;
            Object[] objectArray = Arrays.copyOf(this.array, n4 << 1);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
            this.array = objectArray;
            if (osize != this.size) {
                throw new ConcurrentModificationException();
            }
        }
        if (index < osize) {
            ArraysKt.copyInto((int[])this.hashes, (int[])this.hashes, (int)(index + 1), (int)index, (int)osize);
            ArraysKt.copyInto((Object[])this.array, (Object[])this.array, (int)(index + 1 << 1), (int)(index << 1), (int)(this.size << 1));
        }
        if (var3_3 != this.size || index >= this.hashes.length) {
            throw new ConcurrentModificationException();
        }
        this.hashes[index] = hash;
        this.array[index << 1] = var1_1;
        this.array[(index << 1) + 1] = var2_2;
        int n5 = this.size;
        this.size = n5 + 1;
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public V putIfAbsent(K key, V value) {
        void var3_3;
        V mapValue = this.get(key);
        if (mapValue == null) {
            void var2_2;
            void var1_1;
            mapValue = this.put(var1_1, var2_2);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public V remove(K key) {
        int index = this.indexOfKey(key);
        if (index >= 0) {
            void var1_2;
            return this.removeAt((int)var1_2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public boolean remove(K key, V value) {
        int index = this.indexOfKey(key);
        if (index >= 0) {
            void var3_4;
            void var2_3;
            V mapValue = this.valueAt(index);
            if (Intrinsics.areEqual((Object)var2_3, (Object)var3_4)) {
                void var1_2;
                this.removeAt((int)var1_2);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public V removeAt(int index) {
        void var2_3;
        boolean bl;
        boolean bl2 = index >= 0 ? index < this.size : (bl = false);
        if (!bl2) {
            RuntimeHelpersKt.throwIllegalArgumentException("Expected index to be within 0..size()-1, but was " + index);
        }
        Object old = this.array[(index << 1) + 1];
        int osize = this.size;
        if (osize <= 1) {
            this.clear();
        } else {
            void var3_4;
            int nsize = osize - 1;
            if (this.hashes.length > 8 && osize < this.hashes.length / 3) {
                int n;
                if (osize > 8) {
                    int n2 = osize;
                    n = n2 + (n2 >> 1);
                } else {
                    n = 8;
                }
                int n3 = n;
                int[] ohashes = this.hashes;
                Object[] oarray = this.array;
                int[] nArray = Arrays.copyOf(this.hashes, n3);
                Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
                this.hashes = nArray;
                Object[] objectArray = Arrays.copyOf(this.array, n3 << 1);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
                this.array = objectArray;
                if (osize != this.size) {
                    throw new ConcurrentModificationException();
                }
                if (index > 0) {
                    ArraysKt.copyInto((int[])ohashes, (int[])this.hashes, (int)0, (int)0, (int)index);
                    ArraysKt.copyInto((Object[])oarray, (Object[])this.array, (int)0, (int)0, (int)(index << 1));
                }
                if (index < nsize) {
                    int n4 = index;
                    ArraysKt.copyInto((int[])ohashes, (int[])this.hashes, (int)n4, (int)(n4 + 1), (int)(nsize + 1));
                    ArraysKt.copyInto((Object[])oarray, (Object[])this.array, (int)(index << 1), (int)(index + 1 << 1), (int)(nsize + 1 << 1));
                }
            } else {
                if (index < nsize) {
                    void var1_1;
                    int n = index;
                    ArraysKt.copyInto((int[])this.hashes, (int[])this.hashes, (int)n, (int)(n + 1), (int)(nsize + 1));
                    ArraysKt.copyInto((Object[])this.array, (Object[])this.array, (int)(index << 1), (int)(var1_1 + true << 1), (int)(nsize + 1 << 1));
                }
                this.array[nsize << 1] = null;
                this.array[(nsize << 1) + 1] = null;
            }
            if (var3_4 != this.size) {
                throw new ConcurrentModificationException();
            }
            this.size = nsize;
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public V replace(K key, V value) {
        int index = this.indexOfKey(key);
        if (index >= 0) {
            void var2_3;
            void var1_2;
            return this.setValueAt((int)var1_2, var2_3);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public boolean replace(K key, V oldValue, V newValue) {
        V mapValue;
        void var2_3;
        int index = this.indexOfKey(key);
        if (index >= 0 && Intrinsics.areEqual((Object)var2_3, mapValue = this.valueAt(index))) {
            void var3_4;
            void var1_2;
            this.setValueAt((int)var1_2, var3_4);
            return true;
        }
        return false;
    }

    public int size() {
        return this.size;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        try {
            void var1_1;
            if (other instanceof SimpleArrayMap) {
                if (this.size() != ((SimpleArrayMap)other).size()) {
                    return false;
                }
                SimpleArrayMap otherSimpleArrayMap = (SimpleArrayMap)other;
                int n = this.size;
                for (int i = 0; i < n; ++i) {
                    K key = this.keyAt(i);
                    V mine = this.valueAt(i);
                    V theirs = otherSimpleArrayMap.get(key);
                    if (!(mine == null ? theirs != null || !otherSimpleArrayMap.containsKey(key) : !Intrinsics.areEqual(mine, (Object)var1_1))) continue;
                    return false;
                }
                return true;
            }
            if (var1_1 instanceof Map) {
                if (this.size() != ((Map)var1_1).size()) {
                    return false;
                }
                int n = this.size;
                for (int i = 0; i < n; ++i) {
                    K key = this.keyAt(i);
                    V mine = this.valueAt(i);
                    Object theirs = ((Map)var1_1).get(key);
                    if (!(mine == null ? theirs != null || !((Map)var1_1).containsKey(key) : !Intrinsics.areEqual(mine, theirs))) continue;
                    return false;
                }
                return true;
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ClassCastException classCastException) {}
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var3_3;
        int[] hashes = this.hashes;
        Object[] array = this.array;
        int result = 0;
        int i = 0;
        int v = 1;
        int s = this.size;
        while (i < s) {
            Object value = array[v];
            Object object = value;
            result += hashes[i] ^ (object != null ? object.hashCode() : 0);
            ++i;
            v += 2;
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var2_3;
        StringBuilder stringBuilder;
        if (this.isEmpty()) {
            return "{}";
        }
        int n = this.size * 28;
        StringBuilder $this$toString_u24lambda_u245 = stringBuilder = new StringBuilder(n);
        stringBuilder.append('{');
        int n2 = this.size;
        for (int i = 0; i < n2; ++i) {
            K key;
            if (i > 0) {
                $this$toString_u24lambda_u245.append(", ");
            }
            if ((key = this.keyAt(i)) != $this$toString_u24lambda_u245) {
                $this$toString_u24lambda_u245.append(key);
            } else {
                $this$toString_u24lambda_u245.append("(this Map)");
            }
            $this$toString_u24lambda_u245.append('=');
            V value = this.valueAt(i);
            if (value != $this$toString_u24lambda_u245) {
                $this$toString_u24lambda_u245.append(value);
                continue;
            }
            $this$toString_u24lambda_u245.append("(this Map)");
        }
        var2_3.append('}');
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JvmOverloads
    public SimpleArrayMap() {
        this(0, 1, null);
    }
}

