/*
 * Decompiled with CFR 0.152.
 */
package androidx.collection;

import androidx.collection.LongList;
import androidx.collection.internal.RuntimeHelpersKt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0005J\u0015\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001d\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\r\u0010\u001b\u001a\u00020\u0010\u00a2\u0006\u0004\b\u001b\u0010\u0012"}, d2={"Landroidx/collection/MutableLongList;", "Landroidx/collection/LongList;", "", "initialCapacity", "<init>", "(I)V", "", "element", "", "add", "(J)Z", "index", "", "elements", "addAll", "(I[J)Z", "", "clear", "()V", "capacity", "ensureCapacity", "removeAt", "(I)J", "start", "end", "removeRange", "(II)V", "sort"})
@SourceDebugExtension(value={"SMAP\nLongList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongList.kt\nandroidx/collection/MutableLongList\n+ 2 LongList.kt\nandroidx/collection/LongList\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,972:1\n557#1:974\n364#2:973\n70#2:975\n237#2,6:978\n70#2:984\n70#2:985\n70#2:992\n13337#3,2:976\n1675#3,6:986\n*S KotlinDebug\n*F\n+ 1 LongList.kt\nandroidx/collection/MutableLongList\n*L\n693#1:974\n629#1:973\n751#1:975\n764#1:978,6\n778#1:984\n824#1:985\n841#1:992\n759#1:976,2\n826#1:986,6\n*E\n"})
public final class MutableLongList
extends LongList {
    /*
     * WARNING - void declaration
     */
    public MutableLongList(int initialCapacity) {
        super((int)var1_1, null);
        void var1_1;
    }

    public /* synthetic */ MutableLongList(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 16;
        }
        this(n);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean add(long element) {
        void var1_1;
        MutableLongList mutableLongList = this;
        mutableLongList.ensureCapacity(mutableLongList._size + 1);
        this.content[this._size] = var1_1;
        int n = this._size;
        this._size = n + 1;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean addAll(int index, long[] elements) {
        void var2_2;
        void var1_1;
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        if (!(index >= 0 ? index <= this._size : false)) {
            RuntimeHelpersKt.throwIndexOutOfBoundsException("");
        }
        if (elements.length == 0) {
            return false;
        }
        MutableLongList mutableLongList = this;
        mutableLongList.ensureCapacity(mutableLongList._size + elements.length);
        long[] content = this.content;
        if (index != this._size) {
            ArraysKt.copyInto((long[])content, (long[])content, (int)(index + elements.length), (int)index, (int)this._size);
        }
        ArraysKt.copyInto$default((long[])elements, (long[])var3_3, (int)var1_1, (int)0, (int)0, (int)12, null);
        this._size += ((void)var2_2).length;
        return true;
    }

    public final void clear() {
        this._size = 0;
    }

    /*
     * WARNING - void declaration
     */
    public final void ensureCapacity(int capacity) {
        long[] oldContent = this.content;
        if (this.content.length < capacity) {
            void var1_1;
            void var2_2;
            int newSize = Math.max(capacity, oldContent.length * 3 / 2);
            long[] lArray = Arrays.copyOf((long[])var2_2, (int)var1_1);
            Intrinsics.checkNotNullExpressionValue((Object)lArray, (String)"copyOf(...)");
            this.content = lArray;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final long removeAt(int index) {
        void var3_3;
        if (!(index >= 0 ? index < this._size : false)) {
            RuntimeHelpersKt.throwIndexOutOfBoundsException("Index must be between 0 and size");
        }
        long[] content = this.content;
        long item = this.content[index];
        LongList longList = this;
        if (index != longList._size - 1) {
            void var1_1;
            void var2_2;
            void v0 = var2_2;
            void v1 = var1_1;
            ArraysKt.copyInto((long[])v0, (long[])v0, (int)v1, (int)(v1 + true), (int)this._size);
        }
        int n = this._size;
        this._size = n + -1;
        return (long)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final void removeRange(int start, int end) {
        block7: {
            block6: {
                boolean bl = start >= 0 ? start <= this._size : false;
                if (!bl) break block6;
                if (end >= 0 ? end <= this._size : false) break block7;
            }
            RuntimeHelpersKt.throwIndexOutOfBoundsException("Index must be between 0 and size");
        }
        if (end < start) {
            RuntimeHelpersKt.throwIllegalArgumentException("The end index must be < start index");
        }
        if (end != start) {
            void var1_1;
            void var2_2;
            if (end < this._size) {
                ArraysKt.copyInto((long[])this.content, (long[])this.content, (int)start, (int)end, (int)this._size);
            }
            this._size -= var2_2 - var1_1;
        }
    }

    public final void sort() {
        if (this._size == 0) {
            return;
        }
        ArraysKt.sort((long[])this.content, (int)0, (int)this._size);
    }

    public MutableLongList() {
        this(0, 1, null);
    }
}

