/*
 * Decompiled with CFR 0.152.
 */
package androidx.collection;

import androidx.collection.IntList;
import androidx.collection.internal.RuntimeHelpersKt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000e\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\b\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\fJ\r\u0010\r\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0005J\u0015\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0011\u0010\tJ\u0015\u0010\u0012\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001d\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0016\u0010\fJ \u0010\u0017\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0086\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\r\u0010\u0019\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0019\u0010\u000e"}, d2={"Landroidx/collection/MutableIntList;", "Landroidx/collection/IntList;", "", "initialCapacity", "<init>", "(I)V", "element", "", "add", "(I)Z", "index", "", "(II)V", "clear", "()V", "capacity", "ensureCapacity", "remove", "removeAt", "(I)I", "start", "end", "removeRange", "set", "(II)I", "sort"})
@SourceDebugExtension(value={"SMAP\nIntList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntList.kt\nandroidx/collection/MutableIntList\n+ 2 IntList.kt\nandroidx/collection/IntList\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,968:1\n556#1:970\n363#2:969\n70#2:971\n237#2,6:974\n70#2:980\n70#2:981\n70#2:988\n13330#3,2:972\n1663#3,6:982\n*S KotlinDebug\n*F\n+ 1 IntList.kt\nandroidx/collection/MutableIntList\n*L\n692#1:970\n628#1:969\n749#1:971\n762#1:974,6\n776#1:980\n822#1:981\n839#1:988\n757#1:972,2\n824#1:982,6\n*E\n"})
public final class MutableIntList
extends IntList {
    /*
     * WARNING - void declaration
     */
    public MutableIntList(int initialCapacity) {
        super((int)var1_1, null);
        void var1_1;
    }

    public /* synthetic */ MutableIntList(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 16;
        }
        this(n);
    }

    public final boolean add(int element) {
        int n;
        MutableIntList mutableIntList = this;
        mutableIntList.ensureCapacity(mutableIntList._size + 1);
        this.content[this._size] = n;
        n = this._size;
        this._size = n + 1;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void add(int index, int element) {
        void var2_2;
        if (!(index >= 0 ? index <= this._size : false)) {
            RuntimeHelpersKt.throwIndexOutOfBoundsException("Index must be between 0 and size");
        }
        MutableIntList mutableIntList = this;
        mutableIntList.ensureCapacity(mutableIntList._size + 1);
        int[] content = this.content;
        if (index != this._size) {
            ArraysKt.copyInto((int[])content, (int[])content, (int)(index + 1), (int)index, (int)this._size);
        }
        var3_3[n] = var2_2;
        int n = this._size;
        this._size = n + 1;
    }

    public final void clear() {
        this._size = 0;
    }

    /*
     * WARNING - void declaration
     */
    public final void ensureCapacity(int capacity) {
        int[] oldContent = this.content;
        if (this.content.length < capacity) {
            void var1_1;
            void var2_2;
            int newSize = Math.max(capacity, oldContent.length * 3 / 2);
            int[] nArray = Arrays.copyOf((int[])var2_2, (int)var1_1);
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
            this.content = nArray;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean remove(int element) {
        int index = this.indexOf(element);
        if (index >= 0) {
            void var1_1;
            this.removeAt((int)var1_1);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final int removeAt(int index) {
        void var3_3;
        if (!(index >= 0 ? index < this._size : false)) {
            RuntimeHelpersKt.throwIndexOutOfBoundsException("Index must be between 0 and size");
        }
        int[] content = this.content;
        int item = this.content[index];
        IntList intList = this;
        if (index != intList._size - 1) {
            void var1_1;
            void var2_2;
            void v0 = var2_2;
            void v1 = var1_1;
            ArraysKt.copyInto((int[])v0, (int[])v0, (int)v1, (int)(v1 + true), (int)this._size);
        }
        int n = this._size;
        this._size = n + -1;
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final void removeRange(int start, int end) {
        block7: {
            block6: {
                boolean bl = start >= 0 ? start <= this._size : false;
                if (!bl) break block6;
                if (end >= 0 ? end <= this._size : false) break block7;
            }
            RuntimeHelpersKt.throwIndexOutOfBoundsException("Index must be between 0 and size");
        }
        if (end < start) {
            RuntimeHelpersKt.throwIllegalArgumentException("The end index must be < start index");
        }
        if (end != start) {
            void var1_1;
            void var2_2;
            if (end < this._size) {
                ArraysKt.copyInto((int[])this.content, (int[])this.content, (int)start, (int)end, (int)this._size);
            }
            this._size -= var2_2 - var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int set(int index, int element) {
        void var2_2;
        if (!(index >= 0 ? index < this._size : false)) {
            RuntimeHelpersKt.throwIndexOutOfBoundsException("Index must be between 0 and size");
        }
        int[] content = this.content;
        int old = this.content[index];
        var3_3[var1_1] = var2_2;
        return old;
    }

    public final void sort() {
        if (this._size == 0) {
            return;
        }
        ArraysKt.sort((int[])this.content, (int)0, (int)this._size);
    }

    public MutableIntList() {
        this(0, 1, null);
    }
}

