/*
 * Decompiled with CFR 0.152.
 */
package androidx.collection;

import androidx.collection.internal.Lock;
import androidx.collection.internal.LruHashMap;
import androidx.collection.internal.RuntimeHelpersKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u0001*\b\b\u0001\u0010\u0003*\u00020\u00012\u00020\u0001B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0019\u0010\t\u001a\u0004\u0018\u00018\u00012\u0006\u0010\b\u001a\u00028\u0000H\u0014\u00a2\u0006\u0004\b\t\u0010\nJ1\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00028\u00002\u0006\u0010\r\u001a\u00028\u00012\b\u0010\u000e\u001a\u0004\u0018\u00018\u0001H\u0014\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u0012\u001a\u0004\u0018\u00018\u00012\u0006\u0010\b\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u0012\u0010\nJ\u001f\u0010\u0014\u001a\u0004\u0018\u00018\u00012\u0006\u0010\b\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00028\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0016\u001a\u0004\u0018\u00018\u00012\u0006\u0010\b\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0016\u0010\nJ\u001f\u0010\u0017\u001a\u00020\u00042\u0006\u0010\b\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00028\u0001H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001f\u0010\u0019\u001a\u00020\u00042\u0006\u0010\b\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00028\u0001H\u0014\u00a2\u0006\u0004\b\u0019\u0010\u0018J\u000f\u0010\u001b\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u0007R\u0016\u0010\u001e\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0016\u0010 \u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b \u0010\u001fR\u0016\u0010!\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010\u001fR\u0014\u0010#\u001a\u00020\"8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$R \u0010&\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010%8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u0016\u0010\u0005\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001fR\u0016\u0010(\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b(\u0010\u001fR\u0016\u0010)\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010\u001fR\u0016\u0010*\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b*\u0010\u001f"}, d2={"Landroidx/collection/LruCache;", "", "K", "V", "", "maxSize", "<init>", "(I)V", "key", "create", "(Ljava/lang/Object;)Ljava/lang/Object;", "", "evicted", "oldValue", "newValue", "", "entryRemoved", "(ZLjava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "get", "value", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "remove", "safeSizeOf", "(Ljava/lang/Object;Ljava/lang/Object;)I", "sizeOf", "", "toString", "()Ljava/lang/String;", "trimToSize", "createCount", "I", "evictionCount", "hitCount", "Landroidx/collection/internal/Lock;", "lock", "Landroidx/collection/internal/Lock;", "Landroidx/collection/internal/LruHashMap;", "map", "Landroidx/collection/internal/LruHashMap;", "missCount", "putCount", "size"})
@SourceDebugExtension(value={"SMAP\nLruCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LruCache.kt\nandroidx/collection/LruCache\n+ 2 RuntimeHelpers.kt\nandroidx/collection/internal/RuntimeHelpersKt\n+ 3 LockExt.kt\nandroidx/collection/internal/LockExtKt\n+ 4 Lock.jvm.kt\nandroidx/collection/internal/Lock\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,356:1\n59#2,5:357\n59#2,5:362\n45#2,5:382\n45#2,5:390\n26#3,2:367\n26#3,2:370\n26#3,2:373\n26#3,2:376\n26#3,2:379\n26#3,2:387\n26#3,2:395\n26#3,2:398\n26#3,2:401\n26#3,2:404\n26#3,2:407\n26#3,2:410\n26#3,2:413\n26#3,2:416\n26#3,2:421\n26#4:369\n26#4:372\n26#4:375\n26#4:378\n26#4:381\n26#4:389\n26#4:397\n26#4:400\n26#4:403\n26#4:406\n26#4:409\n26#4:412\n26#4:415\n26#4:418\n26#4:423\n1855#5,2:419\n*S KotlinDebug\n*F\n+ 1 LruCache.kt\nandroidx/collection/LruCache\n*L\n62#1:357,5\n83#1:362,5\n170#1:382,5\n245#1:390,5\n85#1:367,2\n96#1:370,2\n113#1:373,2\n140#1:376,2\n169#1:379,2\n198#1:387,2\n267#1:395,2\n274#1:398,2\n277#1:401,2\n280#1:404,2\n283#1:407,2\n286#1:410,2\n289#1:413,2\n298#1:416,2\n306#1:421,2\n85#1:369\n96#1:372\n113#1:375\n140#1:378\n169#1:381\n198#1:389\n267#1:397\n274#1:400\n277#1:403\n280#1:406\n283#1:409\n286#1:412\n289#1:415\n298#1:418\n306#1:423\n300#1:419,2\n*E\n"})
public class LruCache<K, V> {
    private int maxSize;
    private final LruHashMap<K, V> map;
    private final Lock lock;
    private int size;
    private int putCount;
    private int createCount;
    private int evictionCount;
    private int hitCount;
    private int missCount;

    public LruCache(int maxSize) {
        boolean bl;
        this.maxSize = bl;
        bl = this.maxSize > 0;
        if (!bl) {
            RuntimeHelpersKt.throwIllegalArgumentException("maxSize <= 0");
        }
        this.map = new LruHashMap(0, 0.75f);
        this.lock = new Lock();
    }

    /*
     * WARNING - void declaration
     */
    public final V get(K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Lock lock = this.lock;
        Lock lock2 = lock;
        Lock lock3 = lock;
        lock2 = lock;
        synchronized (lock) {
            Object mapValue222;
            block11: {
                mapValue222 = this.map.get(key);
                if (mapValue222 == null) break block11;
                int n = this.hitCount;
                this.hitCount = n + 1;
                key = mapValue222;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return (V)key;
            }
            int n = this.missCount;
            this.missCount = n + 1;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            V v = this.create(key);
            if (v == null) {
                return null;
            }
            V createdValue = v;
            Lock lock4 = this.lock;
            mapValue222 = lock4;
            mapValue222 = lock4;
            Lock lock5 = lock4;
            synchronized (lock4) {
                int mapValue222 = this.createCount;
                this.createCount = mapValue222 + 1;
                V mapValue222 = this.map.put(key, createdValue);
                if (mapValue222 != null) {
                    this.map.put(key, mapValue222);
                } else {
                    this.size += this.safeSizeOf(key, createdValue);
                }
                // ** MonitorExit[var4_10] (shouldn't be in output)
                if (mapValue222 != null) {
                    void var2_7;
                    void var1_1;
                    this.entryRemoved(false, var1_1, createdValue, mapValue222);
                    return var2_7;
                }
                LruCache lruCache = this;
                lruCache.trimToSize(lruCache.maxSize);
                return (V)lock2;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final V put(K key, V value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Lock lock = this.lock;
        Lock lock2 = lock;
        lock2 = lock;
        Lock lock3 = lock;
        synchronized (lock) {
            void var3_6;
            int n = this.putCount;
            this.putCount = n + 1;
            this.size += this.safeSizeOf(key, value);
            V previous = this.map.put(key, value);
            if (previous != null) {
                this.size -= this.safeSizeOf(key, previous);
            }
            // ** MonitorExit[var4_7] (shouldn't be in output)
            if (previous != null) {
                void var2_3;
                void var1_1;
                this.entryRemoved(false, var1_1, previous, var2_3);
            }
            LruCache lruCache = this;
            lruCache.trimToSize(lruCache.maxSize);
            return var3_6;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void trimToSize(int maxSize) {
        while (true) {
            void var3_3;
            Map.Entry toEvict;
            Lock lock = this.lock;
            Lock lock2 = lock;
            lock2 = lock;
            Lock lock3 = lock;
            // MONITORENTER : lock
            boolean bl = this.size >= 0 && (!this.map.isEmpty() || this.size == 0);
            if (!bl) {
                RuntimeHelpersKt.throwIllegalStateException("LruCache.sizeOf() is reporting inconsistent results!");
            }
            if (this.size <= maxSize || this.map.isEmpty()) {
                // MONITOREXIT : lock3
                return;
            }
            if ((Map.Entry)CollectionsKt.firstOrNull((Iterable)this.map.getEntries()) == null) {
                // MONITOREXIT : lock3
                return;
            }
            Object key = toEvict.getKey();
            Object value = toEvict.getValue();
            this.map.remove(key);
            this.size -= this.safeSizeOf(key, value);
            int n = this.evictionCount;
            this.evictionCount = n + 1;
            // MONITOREXIT : lock3
            this.entryRemoved(true, lock2, var3_3, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final V remove(K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Lock lock = this.lock;
        Lock lock2 = lock;
        lock2 = lock;
        Lock lock3 = lock;
        synchronized (lock) {
            V previous = this.map.remove(key);
            if (previous != null) {
                this.size -= this.safeSizeOf(key, previous);
            }
            // ** MonitorExit[var3_4] (shouldn't be in output)
            if (previous != null) {
                void var1_1;
                this.entryRemoved(false, var1_1, previous, null);
            }
            return (V)lock2;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void entryRemoved(boolean evicted, K key, V oldValue, V newValue) {
        void var3_3;
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"oldValue");
    }

    protected V create(K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final int safeSizeOf(K key, V value) {
        void var3_3;
        int result = this.sizeOf(key, value);
        boolean bl = result >= 0;
        if (!bl) {
            void var2_2;
            void var1_1;
            RuntimeHelpersKt.throwIllegalStateException("Negative size: " + var1_1 + '=' + var2_2);
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    protected int sizeOf(K key, V value) {
        void var2_2;
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"value");
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        Lock lock = this.lock;
        Lock lock2 = lock;
        lock2 = lock;
        lock2 = lock;
        synchronized (lock) {
            void var2_2;
            int accesses = this.hitCount + this.missCount;
            int hitPercent = accesses != 0 ? 100 * this.hitCount / accesses : 0;
            String string = "LruCache[maxSize=" + this.maxSize + ",hits=" + this.hitCount + ",misses=" + this.missCount + ",hitRate=" + (int)var2_2 + "%]";
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return string;
        }
    }
}

