/*
 * Decompiled with CFR 0.152.
 */
package androidx.collection;

import androidx.collection.LongSparseArrayKt;
import androidx.collection.internal.ContainerHelpersKt;
import androidx.collection.internal.RuntimeHelpersKt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001a\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0015\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0017\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0013\b\u0007\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001a\u0010\u0011\u001a\u0004\u0018\u00018\u00002\u0006\u0010\r\u001a\u00020\fH\u0096\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0013\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001f\u0010\u001b\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001f\u0010\u001e\u001a\u00020\u00072\u000e\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0000H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010 \u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b \u0010!J\u000f\u0010\"\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\"\u0010#J\u000f\u0010%\u001a\u00020$H\u0016\u00a2\u0006\u0004\b%\u0010&J\u0017\u0010'\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b'\u0010(R\u0016\u0010)\u001a\u00020\u000e8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u0016\u0010,\u001a\u00020+8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u0016\u0010\"\u001a\u00020\u00038\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010.R\u001e\u00101\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001000/8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0006\n\u0004\b1\u00102"}, d2={"Landroidx/collection/LongSparseArray;", "E", "", "", "initialCapacity", "<init>", "(I)V", "", "clear", "()V", "clone", "()Landroidx/collection/LongSparseArray;", "", "key", "", "containsKey", "(J)Z", "get", "(J)Ljava/lang/Object;", "indexOfKey", "(J)I", "isEmpty", "()Z", "index", "keyAt", "(I)J", "value", "put", "(JLjava/lang/Object;)V", "other", "putAll", "(Landroidx/collection/LongSparseArray;)V", "remove", "(J)V", "size", "()I", "", "toString", "()Ljava/lang/String;", "valueAt", "(I)Ljava/lang/Object;", "garbage", "Z", "", "keys", "[J", "I", "", "", "values", "[Ljava/lang/Object;"})
@SourceDebugExtension(value={"SMAP\nLongSparseArray.jvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongSparseArray.jvm.kt\nandroidx/collection/LongSparseArray\n+ 2 LongSparseArray.kt\nandroidx/collection/LongSparseArrayKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 RuntimeHelpers.kt\nandroidx/collection/internal/RuntimeHelpersKt\n*L\n1#1,243:1\n218#2:244\n229#2,5:245\n223#2,11:250\n239#2,8:261\n239#2,8:269\n250#2,9:277\n263#2,5:286\n271#2,7:291\n286#2,9:298\n320#2,12:307\n299#2,18:319\n334#2,21:337\n358#2,2:358\n360#2:361\n364#2,5:362\n373#2,2:367\n299#2,18:369\n376#2:387\n380#2:388\n384#2:389\n385#2:393\n388#2,2:395\n299#2,18:397\n391#2:415\n396#2:416\n397#2:420\n400#2,2:422\n299#2,18:424\n404#2:442\n409#2:443\n410#2:447\n413#2,2:449\n299#2,18:451\n416#2,2:469\n421#2,2:471\n299#2,18:473\n424#2:491\n429#2,2:492\n299#2,18:494\n432#2,6:512\n442#2:518\n447#2:519\n452#2,8:520\n463#2,6:528\n299#2,18:534\n470#2,10:552\n483#2,21:562\n1#3:360\n59#4,3:390\n63#4:394\n59#4,3:417\n63#4:421\n59#4,3:444\n63#4:448\n*S KotlinDebug\n*F\n+ 1 LongSparseArray.jvm.kt\nandroidx/collection/LongSparseArray\n*L\n92#1:244\n92#1:245,5\n99#1:250,11\n103#1:261,8\n106#1:269,8\n115#1:277,9\n118#1:286,5\n127#1:291,7\n138#1:298,9\n144#1:307,12\n144#1:319,18\n144#1:337,21\n150#1:358,2\n150#1:361\n161#1:362,5\n164#1:367,2\n164#1:369,18\n164#1:387\n171#1:388\n183#1:389\n183#1:393\n183#1:395,2\n183#1:397,18\n183#1:415\n195#1:416\n195#1:420\n195#1:422,2\n195#1:424,18\n195#1:442\n203#1:443\n203#1:447\n203#1:449,2\n203#1:451,18\n203#1:469,2\n209#1:471,2\n209#1:473,18\n209#1:491\n218#1:492,2\n218#1:494,18\n218#1:512,6\n221#1:518\n224#1:519\n227#1:520,8\n233#1:528,6\n233#1:534,18\n233#1:552,10\n241#1:562,21\n150#1:360\n183#1:390,3\n183#1:394\n195#1:417,3\n195#1:421\n203#1:444,3\n203#1:448\n*E\n"})
public class LongSparseArray<E>
implements Cloneable {
    @JvmField
    public /* synthetic */ boolean garbage;
    @JvmField
    public /* synthetic */ long[] keys;
    @JvmField
    public /* synthetic */ Object[] values;
    @JvmField
    public /* synthetic */ int size;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public LongSparseArray(int initialCapacity) {
        void var1_1;
        if (initialCapacity == 0) {
            this.keys = ContainerHelpersKt.EMPTY_LONGS;
            this.values = ContainerHelpersKt.EMPTY_OBJECTS;
            return;
        }
        int idealCapacity = ContainerHelpersKt.idealLongArraySize(initialCapacity);
        this.keys = new long[idealCapacity];
        this.values = new Object[var1_1];
    }

    public /* synthetic */ LongSparseArray(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        this(n);
    }

    /*
     * WARNING - void declaration
     */
    public LongSparseArray<E> clone() {
        void var1_1;
        Object object = super.clone();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type androidx.collection.LongSparseArray<E of androidx.collection.LongSparseArray>");
        LongSparseArray clone = (LongSparseArray)object;
        ((LongSparseArray)object).keys = (long[])this.keys.clone();
        clone.values = (Object[])this.values.clone();
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public E get(long key) {
        void var1_2;
        LongSparseArray longSparseArray;
        LongSparseArray $this$commonGetInternal$iv$iv = longSparseArray = this;
        int i$iv$iv = ContainerHelpersKt.binarySearch(longSparseArray.keys, $this$commonGetInternal$iv$iv.size, key);
        if (i$iv$iv < 0 || $this$commonGetInternal$iv$iv.values[i$iv$iv] == LongSparseArrayKt.access$getDELETED$p()) {
            return null;
        }
        return (E)longSparseArray.values[var1_2];
    }

    public void remove(long key) {
        LongSparseArray $this$commonRemove$iv = this;
        int i$iv = ContainerHelpersKt.binarySearch($this$commonRemove$iv.keys, $this$commonRemove$iv.size, key);
        if (i$iv >= 0 && $this$commonRemove$iv.values[i$iv] != LongSparseArrayKt.access$getDELETED$p()) {
            $this$commonRemove$iv.values[var1_2] = LongSparseArrayKt.access$getDELETED$p();
            var3_3.garbage = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void put(long key, E value) {
        void var3_2;
        void var1_1;
        int n;
        LongSparseArray $this$commonPut$iv = this;
        int index$iv = ContainerHelpersKt.binarySearch($this$commonPut$iv.keys, $this$commonPut$iv.size, key);
        if (index$iv >= 0) {
            $this$commonPut$iv.values[index$iv] = value;
            return;
        }
        if ((index$iv ^= 0xFFFFFFFF) < $this$commonPut$iv.size && $this$commonPut$iv.values[index$iv] == LongSparseArrayKt.access$getDELETED$p()) {
            $this$commonPut$iv.keys[index$iv] = key;
            $this$commonPut$iv.values[index$iv] = value;
            return;
        }
        if ($this$commonPut$iv.garbage && $this$commonPut$iv.size >= $this$commonPut$iv.keys.length) {
            LongSparseArray $this$commonGc$iv$iv = $this$commonPut$iv;
            int n$iv$iv = $this$commonGc$iv$iv.size;
            int newSize$iv$iv = 0;
            long[] keys$iv$iv = $this$commonGc$iv$iv.keys;
            Object[] values$iv$iv = $this$commonGc$iv$iv.values;
            for (int i$iv$iv = 0; i$iv$iv < n$iv$iv; ++i$iv$iv) {
                Object value$iv$iv = values$iv$iv[i$iv$iv];
                if (value$iv$iv == LongSparseArrayKt.access$getDELETED$p()) continue;
                if (i$iv$iv != newSize$iv$iv) {
                    keys$iv$iv[newSize$iv$iv] = keys$iv$iv[i$iv$iv];
                    values$iv$iv[newSize$iv$iv] = value$iv$iv;
                    values$iv$iv[i$iv$iv] = null;
                }
                ++newSize$iv$iv;
            }
            $this$commonGc$iv$iv.garbage = false;
            $this$commonGc$iv$iv.size = newSize$iv$iv;
            n = ~ContainerHelpersKt.binarySearch($this$commonPut$iv.keys, $this$commonPut$iv.size, key);
        }
        if ($this$commonPut$iv.size >= $this$commonPut$iv.keys.length) {
            int newSize$iv = ContainerHelpersKt.idealLongArraySize($this$commonPut$iv.size + 1);
            long[] lArray = Arrays.copyOf($this$commonPut$iv.keys, newSize$iv);
            Intrinsics.checkNotNullExpressionValue((Object)lArray, (String)"copyOf(...)");
            $this$commonPut$iv.keys = lArray;
            Object[] objectArray = Arrays.copyOf($this$commonPut$iv.values, newSize$iv);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
            $this$commonPut$iv.values = objectArray;
        }
        if ($this$commonPut$iv.size - n != 0) {
            ArraysKt.copyInto((long[])$this$commonPut$iv.keys, (long[])$this$commonPut$iv.keys, (int)(n + true), (int)n, (int)$this$commonPut$iv.size);
            ArraysKt.copyInto((Object[])$this$commonPut$iv.values, (Object[])$this$commonPut$iv.values, (int)(n + true), (int)n, (int)$this$commonPut$iv.size);
        }
        $this$commonPut$iv.keys[n] = var1_1;
        $this$commonPut$iv.values[n] = var3_2;
        int n2 = $this$commonPut$iv.size;
        $this$commonPut$iv.size = n2 + 1;
    }

    public void putAll(LongSparseArray<? extends E> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        LongSparseArray $this$commonPutAll$iv = this;
        int size$iv = other.size();
        int n = 0;
        while (n < size$iv) {
            int i$iv = n++;
            $this$commonPutAll$iv.put(other.keyAt(i$iv), other.valueAt(i$iv));
        }
    }

    /*
     * WARNING - void declaration
     */
    public int size() {
        void var1_1;
        LongSparseArray $this$commonSize$iv = this;
        if ($this$commonSize$iv.garbage) {
            LongSparseArray $this$commonGc$iv$iv = $this$commonSize$iv;
            int n$iv$iv = $this$commonGc$iv$iv.size;
            int newSize$iv$iv = 0;
            long[] keys$iv$iv = $this$commonGc$iv$iv.keys;
            Object[] values$iv$iv = $this$commonGc$iv$iv.values;
            for (int i$iv$iv = 0; i$iv$iv < n$iv$iv; ++i$iv$iv) {
                Object value$iv$iv = values$iv$iv[i$iv$iv];
                if (value$iv$iv == LongSparseArrayKt.access$getDELETED$p()) continue;
                if (i$iv$iv != newSize$iv$iv) {
                    keys$iv$iv[newSize$iv$iv] = keys$iv$iv[i$iv$iv];
                    values$iv$iv[newSize$iv$iv] = value$iv$iv;
                    values$iv$iv[i$iv$iv] = null;
                }
                ++newSize$iv$iv;
            }
            $this$commonGc$iv$iv.garbage = false;
            var2_2.size = newSize$iv$iv;
        }
        return var1_1.size;
    }

    public boolean isEmpty() {
        LongSparseArray longSparseArray = this;
        return longSparseArray.size() == 0;
    }

    /*
     * WARNING - void declaration
     */
    public long keyAt(int index) {
        void var1_1;
        void var2_2;
        boolean bl;
        LongSparseArray $this$commonKeyAt$iv = this;
        boolean bl2 = index >= 0 ? index < $this$commonKeyAt$iv.size : (bl = false);
        if (!bl2) {
            RuntimeHelpersKt.throwIllegalArgumentException("Expected index to be within 0..size()-1, but was " + index);
        }
        if ($this$commonKeyAt$iv.garbage) {
            LongSparseArray $this$commonGc$iv$iv = $this$commonKeyAt$iv;
            int n$iv$iv = $this$commonGc$iv$iv.size;
            int newSize$iv$iv = 0;
            long[] keys$iv$iv = $this$commonGc$iv$iv.keys;
            Object[] values$iv$iv = $this$commonGc$iv$iv.values;
            for (int i$iv$iv = 0; i$iv$iv < n$iv$iv; ++i$iv$iv) {
                Object value$iv$iv = values$iv$iv[i$iv$iv];
                if (value$iv$iv == LongSparseArrayKt.access$getDELETED$p()) continue;
                if (i$iv$iv != newSize$iv$iv) {
                    keys$iv$iv[newSize$iv$iv] = keys$iv$iv[i$iv$iv];
                    values$iv$iv[newSize$iv$iv] = value$iv$iv;
                    values$iv$iv[i$iv$iv] = null;
                }
                ++newSize$iv$iv;
            }
            $this$commonGc$iv$iv.garbage = false;
            var3_4.size = newSize$iv$iv;
        }
        return var2_2.keys[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public E valueAt(int index) {
        void var1_1;
        void var2_2;
        boolean bl;
        LongSparseArray $this$commonValueAt$iv = this;
        boolean bl2 = index >= 0 ? index < $this$commonValueAt$iv.size : (bl = false);
        if (!bl2) {
            RuntimeHelpersKt.throwIllegalArgumentException("Expected index to be within 0..size()-1, but was " + index);
        }
        if ($this$commonValueAt$iv.garbage) {
            LongSparseArray $this$commonGc$iv$iv = $this$commonValueAt$iv;
            int n$iv$iv = $this$commonGc$iv$iv.size;
            int newSize$iv$iv = 0;
            long[] keys$iv$iv = $this$commonGc$iv$iv.keys;
            Object[] values$iv$iv = $this$commonGc$iv$iv.values;
            for (int i$iv$iv = 0; i$iv$iv < n$iv$iv; ++i$iv$iv) {
                Object value$iv$iv = values$iv$iv[i$iv$iv];
                if (value$iv$iv == LongSparseArrayKt.access$getDELETED$p()) continue;
                if (i$iv$iv != newSize$iv$iv) {
                    keys$iv$iv[newSize$iv$iv] = keys$iv$iv[i$iv$iv];
                    values$iv$iv[newSize$iv$iv] = value$iv$iv;
                    values$iv$iv[i$iv$iv] = null;
                }
                ++newSize$iv$iv;
            }
            $this$commonGc$iv$iv.garbage = false;
            var3_4.size = newSize$iv$iv;
        }
        return (E)var2_2.values[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public int indexOfKey(long key) {
        void var1_1;
        void var3_2;
        LongSparseArray $this$commonIndexOfKey$iv = this;
        if ($this$commonIndexOfKey$iv.garbage) {
            LongSparseArray $this$commonGc$iv$iv = $this$commonIndexOfKey$iv;
            int n$iv$iv = $this$commonGc$iv$iv.size;
            int newSize$iv$iv = 0;
            long[] keys$iv$iv = $this$commonGc$iv$iv.keys;
            Object[] values$iv$iv = $this$commonGc$iv$iv.values;
            for (int i$iv$iv = 0; i$iv$iv < n$iv$iv; ++i$iv$iv) {
                Object value$iv$iv = values$iv$iv[i$iv$iv];
                if (value$iv$iv == LongSparseArrayKt.access$getDELETED$p()) continue;
                if (i$iv$iv != newSize$iv$iv) {
                    keys$iv$iv[newSize$iv$iv] = keys$iv$iv[i$iv$iv];
                    values$iv$iv[newSize$iv$iv] = value$iv$iv;
                    values$iv$iv[i$iv$iv] = null;
                }
                ++newSize$iv$iv;
            }
            $this$commonGc$iv$iv.garbage = false;
            $this$commonGc$iv$iv.size = newSize$iv$iv;
        }
        return ContainerHelpersKt.binarySearch($this$commonIndexOfKey$iv.keys, var3_2.size, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean containsKey(long key) {
        void var1_1;
        LongSparseArray longSparseArray = this;
        return longSparseArray.indexOfKey((long)var1_1) >= 0;
    }

    public void clear() {
        LongSparseArray $this$commonClear$iv = this;
        int n$iv = $this$commonClear$iv.size;
        Object[] values$iv = $this$commonClear$iv.values;
        for (int i$iv = 0; i$iv < n$iv; ++i$iv) {
            values$iv[i$iv] = null;
        }
        $this$commonClear$iv.size = 0;
        var1_1.garbage = false;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var3_4;
        StringBuilder stringBuilder;
        LongSparseArray $this$commonToString$iv = this;
        if ($this$commonToString$iv.size() <= 0) {
            return "{}";
        }
        int n = $this$commonToString$iv.size * 28;
        StringBuilder $this$commonToString_u24lambda_u245$iv = stringBuilder = new StringBuilder(n);
        stringBuilder.append('{');
        int n2 = $this$commonToString$iv.size;
        for (int i$iv = 0; i$iv < n2; ++i$iv) {
            if (i$iv > 0) {
                $this$commonToString_u24lambda_u245$iv.append(", ");
            }
            long key$iv = $this$commonToString$iv.keyAt(i$iv);
            $this$commonToString_u24lambda_u245$iv.append(key$iv);
            $this$commonToString_u24lambda_u245$iv.append('=');
            E value$iv = $this$commonToString$iv.valueAt(i$iv);
            if (value$iv != $this$commonToString_u24lambda_u245$iv) {
                $this$commonToString_u24lambda_u245$iv.append(value$iv);
                continue;
            }
            $this$commonToString_u24lambda_u245$iv.append("(this Map)");
        }
        var3_4.append('}');
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JvmOverloads
    public LongSparseArray() {
        this(0, 1, null);
    }
}

