/*
 * Decompiled with CFR 0.152.
 */
package androidx.collection;

import androidx.collection.IntSetKt;
import androidx.collection.internal.RuntimeHelpersKt;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\b7\u0018\u00002\u00020\u0001B\u0011\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J+\u0010\t\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00022\b\b\u0002\u0010\u0007\u001a\u00020\u00022\b\b\u0002\u0010\b\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0002H\u0086\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u000f\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0011\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0018\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0002H\u0086\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0012J\u0015\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0015JA\u0010\u001f\u001a\u00020\u001e2\b\b\u0002\u0010\u0019\u001a\u00020\u00182\b\b\u0002\u0010\u001a\u001a\u00020\u00182\b\b\u0002\u0010\u001b\u001a\u00020\u00182\b\b\u0002\u0010\u001c\u001a\u00020\u00022\b\b\u0002\u0010\u001d\u001a\u00020\u0018H\u0007\u00a2\u0006\u0004\b\u001f\u0010 J\r\u0010!\u001a\u00020\u0002\u00a2\u0006\u0004\b!\u0010\u0012J\u000f\u0010\"\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b\"\u0010#R\u0016\u0010$\u001a\u00020\u00028\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u0016\u0010'\u001a\u00020&8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0006\n\u0004\b'\u0010(R\u0012\u0010*\u001a\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0012\u0082\u0001\u0001+"}, d2={"Landroidx/collection/IntList;", "", "", "initialCapacity", "<init>", "(I)V", "element", "fromIndex", "toIndex", "binarySearch", "(III)I", "", "contains", "(I)Z", "other", "equals", "(Ljava/lang/Object;)Z", "first", "()I", "index", "get", "(I)I", "hashCode", "indexOf", "", "separator", "prefix", "postfix", "limit", "truncated", "", "joinToString", "(Ljava/lang/CharSequence;Ljava/lang/CharSequence;Ljava/lang/CharSequence;ILjava/lang/CharSequence;)Ljava/lang/String;", "last", "toString", "()Ljava/lang/String;", "_size", "I", "", "content", "[I", "getSize", "size", "Landroidx/collection/MutableIntList;"})
@SourceDebugExtension(value={"SMAP\nIntList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntList.kt\nandroidx/collection/IntList\n*L\n1#1,968:1\n363#1:969\n366#1:970\n237#1,6:971\n265#1,6:977\n237#1,6:983\n74#1:989\n237#1,6:990\n363#1:996\n237#1,6:997\n237#1,6:1003\n251#1,6:1009\n265#1,6:1015\n279#1,6:1021\n251#1,6:1027\n251#1,6:1033\n279#1,6:1039\n363#1:1045\n70#1:1046\n265#1,6:1047\n279#1,6:1053\n65#1:1059\n251#1,6:1060\n251#1,6:1066\n237#1,6:1072\n74#1:1078\n484#1,10:1079\n251#1,4:1089\n494#1,9:1093\n256#1:1102\n503#1,2:1103\n484#1,10:1105\n251#1,4:1115\n494#1,9:1119\n256#1:1128\n503#1,2:1129\n484#1,10:1131\n251#1,4:1141\n494#1,9:1145\n256#1:1154\n503#1,2:1155\n484#1,10:1157\n251#1,4:1167\n494#1,9:1171\n256#1:1180\n503#1,2:1181\n484#1,10:1183\n251#1,4:1193\n494#1,9:1197\n256#1:1206\n503#1,2:1207\n*S KotlinDebug\n*F\n+ 1 IntList.kt\nandroidx/collection/IntList\n*L\n78#1:969\n83#1:970\n89#1:971,6\n103#1:977,6\n113#1:983,6\n126#1:989\n143#1:990,6\n152#1:996\n166#1:997,6\n182#1:1003,6\n196#1:1009,6\n212#1:1015,6\n226#1:1021,6\n328#1:1027,6\n341#1:1033,6\n354#1:1039,6\n373#1:1045\n376#1:1046\n387#1:1047,6\n400#1:1053,6\n422#1:1059\n462#1:1060,6\n493#1:1066,6\n509#1:1072,6\n522#1:1078\n-1#1:1079,10\n-1#1:1089,4\n-1#1:1093,9\n-1#1:1102\n-1#1:1103,2\n-1#1:1105,10\n-1#1:1115,4\n-1#1:1119,9\n-1#1:1128\n-1#1:1129,2\n-1#1:1131,10\n-1#1:1141,4\n-1#1:1145,9\n-1#1:1154\n-1#1:1155,2\n-1#1:1157,10\n-1#1:1167,4\n-1#1:1171,9\n-1#1:1180\n-1#1:1181,2\n-1#1:1183,10\n-1#1:1193,4\n-1#1:1197,9\n-1#1:1206\n-1#1:1207,2\n*E\n"})
public abstract class IntList {
    @JvmField
    public int[] content;
    @JvmField
    public int _size;

    /*
     * WARNING - void declaration
     */
    private IntList(int initialCapacity) {
        void var1_1;
        this.content = initialCapacity == 0 ? IntSetKt.getEmptyIntArray() : new int[var1_1];
    }

    public final int getSize() {
        return this._size;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean contains(int element) {
        void var2_2;
        IntList this_$iv = this;
        int[] content$iv = this_$iv.content;
        int n = var2_2._size;
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            int n2 = content$iv[i$iv];
            if (n2 != element) continue;
            return true;
        }
        return false;
    }

    public final int first() {
        IntList intList = this;
        if (intList._size == 0) {
            RuntimeHelpersKt.throwNoSuchElementException("IntList is empty.");
        }
        return this.content[0];
    }

    /*
     * WARNING - void declaration
     */
    public final int get(int index) {
        void var1_1;
        if (!(index >= 0 ? index < this._size : false)) {
            RuntimeHelpersKt.throwIndexOutOfBoundsException("Index must be between 0 and size");
        }
        return this.content[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public final int indexOf(int element) {
        void var2_2;
        IntList this_$iv = this;
        int[] content$iv = this_$iv.content;
        int i$iv = 0;
        int n = var2_2._size;
        while (i$iv < n) {
            void item;
            int n2 = content$iv[i$iv];
            int i = i$iv++;
            if (element != item) continue;
            return i;
        }
        return -1;
    }

    public final int last() {
        IntList intList = this;
        if (intList._size == 0) {
            RuntimeHelpersKt.throwNoSuchElementException("IntList is empty.");
        }
        intList = this;
        return this.content[intList._size - 1];
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public final int binarySearch(int element, int fromIndex, int toIndex) {
        void var2_2;
        void low;
        if (fromIndex < 0 || fromIndex >= toIndex || toIndex > this._size) {
            RuntimeHelpersKt.throwIndexOutOfBoundsException("");
        }
        int high = toIndex - 1;
        while (low <= high) {
            void mid = low + high >>> 1;
            int midVal = this.content[mid];
            if (midVal < element) {
                low = mid + true;
                continue;
            }
            if (midVal > element) {
                high = mid - true;
                continue;
            }
            return (int)mid;
        }
        return (int)(-(var2_2 + true));
    }

    public static /* synthetic */ int binarySearch$default(IntList intList, int n, int n2, int n3, int n4, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: binarySearch");
        }
        if ((n4 & 2) != 0) {
            n2 = 0;
        }
        if ((n4 & 4) != 0) {
            IntList intList2 = intList;
            n3 = intList2._size;
        }
        return intList.binarySearch(n, n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public final String joinToString(CharSequence separator, CharSequence prefix, CharSequence postfix, int limit, CharSequence truncated) {
        StringBuilder stringBuilder;
        block3: {
            void var3_4;
            void var2_2;
            Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Intrinsics.checkNotNullParameter((Object)postfix, (String)"postfix");
            Intrinsics.checkNotNullParameter((Object)truncated, (String)"truncated");
            StringBuilder $this$joinToString_u24lambda_u2430 = stringBuilder = new StringBuilder();
            stringBuilder.append(prefix);
            IntList this_$iv = this;
            int[] content$iv = this_$iv.content;
            int n = var2_2._size;
            for (int i$iv = 0; i$iv < n; ++i$iv) {
                void element;
                int n2 = content$iv[i$iv];
                int index = i$iv;
                if (index == limit) {
                    $this$joinToString_u24lambda_u2430.append(truncated);
                    break block3;
                }
                if (index != 0) {
                    $this$joinToString_u24lambda_u2430.append(separator);
                }
                $this$joinToString_u24lambda_u2430.append((int)element);
            }
            $this$joinToString_u24lambda_u2430.append((CharSequence)var3_4);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String joinToString$default(IntList intList, CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, int n, CharSequence charSequence4, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: joinToString");
        }
        if ((n2 & 1) != 0) {
            charSequence = ", ";
        }
        if ((n2 & 2) != 0) {
            charSequence2 = "";
        }
        if ((n2 & 4) != 0) {
            charSequence3 = "";
        }
        if ((n2 & 8) != 0) {
            n = -1;
        }
        if ((n2 & 0x10) != 0) {
            charSequence4 = "...";
        }
        return intList.joinToString(charSequence, charSequence2, charSequence3, n, charSequence4);
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        void var2_2;
        int hashCode = 0;
        IntList this_$iv = this;
        int[] content$iv = this_$iv.content;
        int n = var2_2._size;
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            int element = content$iv[i$iv];
            hashCode += 31 * Integer.hashCode(element);
        }
        return (int)var1_1;
    }

    public boolean equals(Object other) {
        int n;
        if (!(other instanceof IntList) || ((IntList)other)._size != this._size) {
            return false;
        }
        int[] content = this.content;
        int[] otherContent = ((IntList)other).content;
        IntList this_$iv = this;
        IntRange intRange = RangesKt.until((int)0, (int)this_$iv._size);
        int i = intRange.getFirst();
        if (i <= (n = intRange.getLast())) {
            while (true) {
                if (content[i] != otherContent[i]) {
                    return false;
                }
                if (i == n) break;
                ++i;
            }
        }
        return true;
    }

    public String toString() {
        return IntList.joinToString$default(this, null, "[", "]", 0, null, 25, null);
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ IntList(int initialCapacity, DefaultConstructorMarker $constructor_marker) {
        this((int)var1_1);
        void var1_1;
    }
}

