/*
 * Decompiled with CFR 0.152.
 */
package androidx.collection;

import androidx.collection.FloatSetKt;
import androidx.collection.internal.RuntimeHelpersKt;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\b7\u0018\u00002\u00020\u0001B\u0011\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\b\u001a\u00020\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0002H\u0086\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011JA\u0010\u0019\u001a\u00020\u00182\b\b\u0002\u0010\u0013\u001a\u00020\u00122\b\b\u0002\u0010\u0014\u001a\u00020\u00122\b\b\u0002\u0010\u0015\u001a\u00020\u00122\b\b\u0002\u0010\u0016\u001a\u00020\u00022\b\b\u0002\u0010\u0017\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\r\u0010\u001b\u001a\u00020\n\u00a2\u0006\u0004\b\u001b\u0010\fJ\u000f\u0010\u001c\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u00020\u00028\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0016\u0010!\u001a\u00020 8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010\"\u0082\u0001\u0001#"}, d2={"Landroidx/collection/FloatList;", "", "", "initialCapacity", "<init>", "(I)V", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "first", "()F", "index", "get", "(I)F", "hashCode", "()I", "", "separator", "prefix", "postfix", "limit", "truncated", "", "joinToString", "(Ljava/lang/CharSequence;Ljava/lang/CharSequence;Ljava/lang/CharSequence;ILjava/lang/CharSequence;)Ljava/lang/String;", "last", "toString", "()Ljava/lang/String;", "_size", "I", "", "content", "[F", "Landroidx/collection/MutableFloatList;"})
@SourceDebugExtension(value={"SMAP\nFloatList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FloatList.kt\nandroidx/collection/FloatList\n*L\n1#1,976:1\n365#1:977\n368#1:978\n237#1,6:979\n265#1,6:985\n237#1,6:991\n74#1:997\n237#1,6:998\n365#1:1004\n237#1,6:1005\n237#1,6:1011\n251#1,6:1017\n265#1,6:1023\n279#1,6:1029\n251#1,6:1035\n251#1,6:1041\n279#1,6:1047\n365#1:1053\n70#1:1054\n265#1,6:1055\n279#1,6:1061\n65#1:1067\n251#1,6:1068\n251#1,6:1074\n237#1,6:1080\n74#1:1086\n486#1,10:1087\n251#1,4:1097\n496#1,9:1101\n256#1:1110\n505#1,2:1111\n486#1,10:1113\n251#1,4:1123\n496#1,9:1127\n256#1:1136\n505#1,2:1137\n486#1,10:1139\n251#1,4:1149\n496#1,9:1153\n256#1:1162\n505#1,2:1163\n486#1,10:1165\n251#1,4:1175\n496#1,9:1179\n256#1:1188\n505#1,2:1189\n486#1,10:1191\n251#1,4:1201\n496#1,9:1205\n256#1:1214\n505#1,2:1215\n*S KotlinDebug\n*F\n+ 1 FloatList.kt\nandroidx/collection/FloatList\n*L\n78#1:977\n83#1:978\n89#1:979,6\n103#1:985,6\n113#1:991,6\n126#1:997\n143#1:998,6\n152#1:1004\n166#1:1005,6\n182#1:1011,6\n196#1:1017,6\n212#1:1023,6\n226#1:1029,6\n328#1:1035,6\n342#1:1041,6\n356#1:1047,6\n375#1:1053\n378#1:1054\n389#1:1055,6\n402#1:1061,6\n424#1:1067\n464#1:1068,6\n495#1:1074,6\n511#1:1080,6\n524#1:1086\n-1#1:1087,10\n-1#1:1097,4\n-1#1:1101,9\n-1#1:1110\n-1#1:1111,2\n-1#1:1113,10\n-1#1:1123,4\n-1#1:1127,9\n-1#1:1136\n-1#1:1137,2\n-1#1:1139,10\n-1#1:1149,4\n-1#1:1153,9\n-1#1:1162\n-1#1:1163,2\n-1#1:1165,10\n-1#1:1175,4\n-1#1:1179,9\n-1#1:1188\n-1#1:1189,2\n-1#1:1191,10\n-1#1:1201,4\n-1#1:1205,9\n-1#1:1214\n-1#1:1215,2\n*E\n"})
public abstract class FloatList {
    @JvmField
    public float[] content;
    @JvmField
    public int _size;

    /*
     * WARNING - void declaration
     */
    private FloatList(int initialCapacity) {
        void var1_1;
        this.content = initialCapacity == 0 ? FloatSetKt.getEmptyFloatArray() : new float[var1_1];
    }

    public final float first() {
        FloatList floatList = this;
        if (floatList._size == 0) {
            RuntimeHelpersKt.throwNoSuchElementException("FloatList is empty.");
        }
        return this.content[0];
    }

    /*
     * WARNING - void declaration
     */
    public final float get(int index) {
        void var1_1;
        if (!(index >= 0 ? index < this._size : false)) {
            RuntimeHelpersKt.throwIndexOutOfBoundsException("Index must be between 0 and size");
        }
        return this.content[var1_1];
    }

    public final float last() {
        FloatList floatList = this;
        if (floatList._size == 0) {
            RuntimeHelpersKt.throwNoSuchElementException("FloatList is empty.");
        }
        floatList = this;
        return this.content[floatList._size - 1];
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public final String joinToString(CharSequence separator, CharSequence prefix, CharSequence postfix, int limit, CharSequence truncated) {
        StringBuilder stringBuilder;
        block3: {
            void var3_4;
            void var2_2;
            Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Intrinsics.checkNotNullParameter((Object)postfix, (String)"postfix");
            Intrinsics.checkNotNullParameter((Object)truncated, (String)"truncated");
            StringBuilder $this$joinToString_u24lambda_u2430 = stringBuilder = new StringBuilder();
            stringBuilder.append(prefix);
            FloatList this_$iv = this;
            float[] content$iv = this_$iv.content;
            int n = var2_2._size;
            for (int i$iv = 0; i$iv < n; ++i$iv) {
                void element;
                float f = content$iv[i$iv];
                int index = i$iv;
                if (index == limit) {
                    $this$joinToString_u24lambda_u2430.append(truncated);
                    break block3;
                }
                if (index != 0) {
                    $this$joinToString_u24lambda_u2430.append(separator);
                }
                $this$joinToString_u24lambda_u2430.append((float)element);
            }
            $this$joinToString_u24lambda_u2430.append((CharSequence)var3_4);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String joinToString$default(FloatList floatList, CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, int n, CharSequence charSequence4, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: joinToString");
        }
        if ((n2 & 1) != 0) {
            charSequence = ", ";
        }
        if ((n2 & 2) != 0) {
            charSequence2 = "";
        }
        if ((n2 & 4) != 0) {
            charSequence3 = "";
        }
        if ((n2 & 8) != 0) {
            n = -1;
        }
        if ((n2 & 0x10) != 0) {
            charSequence4 = "...";
        }
        return floatList.joinToString(charSequence, charSequence2, charSequence3, n, charSequence4);
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        void var2_2;
        int hashCode = 0;
        FloatList this_$iv = this;
        float[] content$iv = this_$iv.content;
        int n = var2_2._size;
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            float element = content$iv[i$iv];
            hashCode += 31 * Float.hashCode(element);
        }
        return (int)var1_1;
    }

    public boolean equals(Object other) {
        int n;
        if (!(other instanceof FloatList) || ((FloatList)other)._size != this._size) {
            return false;
        }
        float[] content = this.content;
        float[] otherContent = ((FloatList)other).content;
        FloatList this_$iv = this;
        IntRange intRange = RangesKt.until((int)0, (int)this_$iv._size);
        int i = intRange.getFirst();
        if (i <= (n = intRange.getLast())) {
            while (true) {
                if (!(content[i] == otherContent[i])) {
                    return false;
                }
                if (i == n) break;
                ++i;
            }
        }
        return true;
    }

    public String toString() {
        return FloatList.joinToString$default(this, null, "[", "]", 0, null, 25, null);
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ FloatList(int initialCapacity, DefaultConstructorMarker $constructor_marker) {
        this((int)var1_1);
        void var1_1;
    }
}

