/*
 * Decompiled with CFR 0.152.
 */
package androidx.collection;

import androidx.collection.internal.RuntimeHelpersKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0013\b\u0007\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\u000e\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\u0003H\u0086\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\r\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014J\r\u0010\u0015\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\u00020\u00038\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u001e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\u00020\u00038\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u0018R\u0016\u0010\u001d\u001a\u00020\u00038\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u0018"}, d2={"Landroidx/collection/CircularArray;", "E", "", "", "minCapacity", "<init>", "(I)V", "element", "", "addLast", "(Ljava/lang/Object;)V", "doubleCapacity", "()V", "index", "get", "(I)Ljava/lang/Object;", "", "isEmpty", "()Z", "popFirst", "()Ljava/lang/Object;", "size", "()I", "capacityBitmask", "I", "", "elements", "[Ljava/lang/Object;", "head", "tail"})
@SourceDebugExtension(value={"SMAP\nCircularArray.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CircularArray.kt\nandroidx/collection/CircularArray\n+ 2 RuntimeHelpers.kt\nandroidx/collection/internal/RuntimeHelpersKt\n+ 3 CollectionPlatformUtils.jvm.kt\nandroidx/collection/CollectionPlatformUtils\n*L\n1#1,266:1\n59#2,5:267\n59#2,5:272\n24#3:277\n24#3:278\n24#3:279\n24#3:280\n24#3:281\n24#3:282\n24#3:283\n*S KotlinDebug\n*F\n+ 1 CircularArray.kt\nandroidx/collection/CircularArray\n*L\n38#1:267,5\n39#1:272,5\n104#1:277\n121#1:278\n148#1:279\n183#1:280\n217#1:281\n231#1:282\n245#1:283\n*E\n"})
public final class CircularArray<E> {
    private E[] elements;
    private int head;
    private int tail;
    private int capacityBitmask;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public CircularArray(int minCapacity) {
        void var1_1;
        int n = minCapacity > 0 ? 1 : 0;
        if (n == 0) {
            RuntimeHelpersKt.throwIllegalArgumentException("capacity must be >= 1");
        }
        if ((n = minCapacity <= 0x40000000 ? 1 : 0) == 0) {
            RuntimeHelpersKt.throwIllegalArgumentException("capacity must be <= 2^30");
        }
        void arrayCapacity = Integer.bitCount(minCapacity) != 1 ? Integer.highestOneBit(minCapacity - 1) << 1 : var1_1;
        this.capacityBitmask = arrayCapacity - true;
        this.elements = new Object[n];
    }

    public /* synthetic */ CircularArray(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 8;
        }
        this(n);
    }

    /*
     * WARNING - void declaration
     */
    private final void doubleCapacity() {
        void var3_3;
        void var1_1;
        void var2_2;
        int n = this.elements.length;
        int r = n - this.head;
        int newCapacity = n << 1;
        if (newCapacity < 0) {
            throw new RuntimeException("Max array capacity exceeded");
        }
        Object[] a = new Object[newCapacity];
        ArraysKt.copyInto((Object[])this.elements, (Object[])a, (int)0, (int)this.head, (int)n);
        ArraysKt.copyInto((Object[])this.elements, (Object[])a, (int)var2_2, (int)0, (int)this.head);
        this.elements = a;
        this.head = 0;
        this.tail = var1_1;
        this.capacityBitmask = var3_3 - true;
    }

    /*
     * WARNING - void declaration
     */
    public final void addLast(E element) {
        void var1_1;
        this.elements[this.tail] = var1_1;
        this.tail = this.tail + 1 & this.capacityBitmask;
        if (this.tail == this.head) {
            this.doubleCapacity();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final E popFirst() {
        void var1_1;
        if (this.head == this.tail) {
            throw (IndexOutOfBoundsException)new ArrayIndexOutOfBoundsException();
        }
        E result = this.elements[this.head];
        this.elements[this.head] = null;
        this.head = this.head + 1 & this.capacityBitmask;
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final E get(int index) {
        void var1_1;
        if (index < 0 || index >= this.size()) {
            throw (IndexOutOfBoundsException)new ArrayIndexOutOfBoundsException();
        }
        E e = this.elements[this.head + var1_1 & this.capacityBitmask];
        Intrinsics.checkNotNull(e);
        return e;
    }

    public final int size() {
        return this.tail - this.head & this.capacityBitmask;
    }

    public final boolean isEmpty() {
        return this.head == this.tail;
    }

    @JvmOverloads
    public CircularArray() {
        this(0, 1, null);
    }
}

