/*
 * Decompiled with CFR 0.152.
 */
package androidx.collection;

import androidx.collection.ArraySetJvmUtil;
import androidx.collection.ArraySetKt;
import androidx.collection.IndexBasedArrayIterator;
import androidx.collection.internal.ContainerHelpersKt;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMutableCollection;
import kotlin.jvm.internal.markers.KMutableSet;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0010#\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0010)\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u0015\n\u0002\b\t\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u00022\b\u0012\u0004\u0012\u00028\u00000\u0003:\u0001EB\u0013\b\u0007\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\u000e\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\b\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0004\b\u0013\u0010\u000bJ\u001d\u0010\u0014\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u000fJ\u0015\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0016\u0010\u0007J\u001a\u0010\u0019\u001a\u00020\t2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0017H\u0096\u0002\u00a2\u0006\u0004\b\u0019\u0010\u000bJ\u000f\u0010\u001a\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001d\u001a\u00020\u00042\b\u0010\u001c\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010\u001f\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000!H\u0096\u0002\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010$\u001a\u00020\t2\u0006\u0010\b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b$\u0010\u000bJ\u001d\u0010%\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0016\u00a2\u0006\u0004\b%\u0010\u000fJ\u0015\u0010'\u001a\u00028\u00002\u0006\u0010&\u001a\u00020\u0004\u00a2\u0006\u0004\b'\u0010(J\u001d\u0010)\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0016\u00a2\u0006\u0004\b)\u0010\u000fJ\u0015\u0010+\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170*\u00a2\u0006\u0004\b+\u0010,J'\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00010*\"\u0004\b\u0001\u0010-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00028\u00010*\u00a2\u0006\u0004\b+\u0010/J\u000f\u00101\u001a\u000200H\u0016\u00a2\u0006\u0004\b1\u00102J\u0015\u00103\u001a\u00028\u00002\u0006\u0010&\u001a\u00020\u0004\u00a2\u0006\u0004\b3\u0010(R\"\u00104\u001a\u00020\u00048\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b4\u00105\u001a\u0004\b6\u0010\u001b\"\u0004\b7\u0010\u0007R*\u0010.\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170*8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b.\u00108\u001a\u0004\b9\u0010,\"\u0004\b:\u0010;R\"\u0010=\u001a\u00020<8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b=\u0010>\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR\u0014\u0010D\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bC\u0010\u001b"}, d2={"Landroidx/collection/ArraySet;", "E", "", "", "", "capacity", "<init>", "(I)V", "element", "", "add", "(Ljava/lang/Object;)Z", "", "elements", "addAll", "(Ljava/util/Collection;)Z", "", "clear", "()V", "contains", "containsAll", "minimumCapacity", "ensureCapacity", "", "other", "equals", "hashCode", "()I", "key", "indexOf", "(Ljava/lang/Object;)I", "isEmpty", "()Z", "", "iterator", "()Ljava/util/Iterator;", "remove", "removeAll", "index", "removeAt", "(I)Ljava/lang/Object;", "retainAll", "", "toArray", "()[Ljava/lang/Object;", "T", "array", "([Ljava/lang/Object;)[Ljava/lang/Object;", "", "toString", "()Ljava/lang/String;", "valueAt", "_size", "I", "get_size$collection", "set_size$collection", "[Ljava/lang/Object;", "getArray$collection", "setArray$collection", "([Ljava/lang/Object;)V", "", "hashes", "[I", "getHashes$collection", "()[I", "setHashes$collection", "([I)V", "getSize", "size", "ElementIterator"})
@SourceDebugExtension(value={"SMAP\nArraySet.jvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArraySet.jvm.kt\nandroidx/collection/ArraySet\n+ 2 ArraySet.kt\nandroidx/collection/ArraySetKt\n*L\n1#1,283:1\n288#2,10:284\n301#2,14:294\n318#2:308\n323#2:309\n328#2:310\n333#2:311\n338#2,61:312\n403#2,17:373\n423#2,6:390\n433#2,60:396\n501#2,9:456\n514#2,22:465\n540#2,7:487\n551#2,19:494\n574#2,6:513\n584#2,6:519\n594#2,5:525\n603#2,8:530\n*S KotlinDebug\n*F\n+ 1 ArraySet.jvm.kt\nandroidx/collection/ArraySet\n*L\n89#1:284,10\n98#1:294,14\n108#1:308\n118#1:309\n128#1:310\n133#1:311\n145#1:312,61\n155#1:373,17\n165#1:390,6\n176#1:396,60\n185#1:456,9\n210#1:465,22\n215#1:487,7\n223#1:494,19\n250#1:513,6\n259#1:519,6\n269#1:525,5\n280#1:530,8\n*E\n"})
public final class ArraySet<E>
implements Collection<E>,
Set<E>,
KMutableCollection,
KMutableSet {
    private int[] hashes;
    private Object[] array;
    private int _size;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public ArraySet(int capacity) {
        this.hashes = ContainerHelpersKt.EMPTY_INTS;
        this.array = ContainerHelpersKt.EMPTY_OBJECTS;
        if (capacity > 0) {
            void var1_1;
            ArraySetKt.allocArrays(this, (int)var1_1);
        }
    }

    public /* synthetic */ ArraySet(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        this(n);
    }

    public final int[] getHashes$collection() {
        return this.hashes;
    }

    /*
     * WARNING - void declaration
     */
    public final void setHashes$collection(int[] nArray) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.hashes = var1_1;
    }

    public final Object[] getArray$collection() {
        return this.array;
    }

    /*
     * WARNING - void declaration
     */
    public final void setArray$collection(Object[] objectArray) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)objectArray, (String)"<set-?>");
        this.array = var1_1;
    }

    public final int get_size$collection() {
        return this._size;
    }

    /*
     * WARNING - void declaration
     */
    public final void set_size$collection(int n) {
        void var1_1;
        this._size = var1_1;
    }

    public final int getSize() {
        return this._size;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void clear() {
        void var1_1;
        ArraySet $this$clearInternal$iv = this;
        if ($this$clearInternal$iv.get_size$collection() != 0) {
            $this$clearInternal$iv.setHashes$collection(ContainerHelpersKt.EMPTY_INTS);
            $this$clearInternal$iv.setArray$collection(ContainerHelpersKt.EMPTY_OBJECTS);
            $this$clearInternal$iv.set_size$collection(0);
        }
        if (var1_1.get_size$collection() != 0) {
            throw new ConcurrentModificationException();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void ensureCapacity(int minimumCapacity) {
        void var3_3;
        void var2_2;
        ArraySet $this$ensureCapacityInternal$iv = this;
        int oSize$iv = $this$ensureCapacityInternal$iv.get_size$collection();
        if ($this$ensureCapacityInternal$iv.getHashes$collection().length < minimumCapacity) {
            void var1_1;
            int[] ohashes$iv = $this$ensureCapacityInternal$iv.getHashes$collection();
            Object[] oarray$iv = $this$ensureCapacityInternal$iv.getArray$collection();
            ArraySetKt.allocArrays($this$ensureCapacityInternal$iv, (int)var1_1);
            if ($this$ensureCapacityInternal$iv.get_size$collection() > 0) {
                ArraysKt.copyInto$default((int[])ohashes$iv, (int[])$this$ensureCapacityInternal$iv.getHashes$collection(), (int)0, (int)0, (int)$this$ensureCapacityInternal$iv.get_size$collection(), (int)6, null);
                ArraysKt.copyInto$default((Object[])oarray$iv, (Object[])$this$ensureCapacityInternal$iv.getArray$collection(), (int)0, (int)0, (int)$this$ensureCapacityInternal$iv.get_size$collection(), (int)6, null);
            }
        }
        if (var2_2.get_size$collection() != var3_3) {
            throw new ConcurrentModificationException();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean contains(Object element) {
        void var1_1;
        ArraySet arraySet = this;
        return arraySet.indexOf(var1_1) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    public final int indexOf(Object key) {
        void var1_1;
        void var2_2;
        ArraySet $this$indexOfInternal$iv = this;
        Object object = key;
        if (object == null) {
            return ArraySetKt.indexOfNull($this$indexOfInternal$iv);
        }
        return ArraySetKt.indexOf(var2_2, object, var1_1.hashCode());
    }

    /*
     * WARNING - void declaration
     */
    public final E valueAt(int index) {
        void var1_1;
        ArraySet arraySet = this;
        return (E)arraySet.getArray$collection()[var1_1];
    }

    @Override
    public final boolean isEmpty() {
        ArraySet arraySet = this;
        return arraySet.get_size$collection() <= 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean add(E element) {
        void var2_2;
        void var1_1;
        void var3_3;
        int index$iv;
        int hash$iv;
        ArraySet $this$addInternal$iv = this;
        int oSize$iv = $this$addInternal$iv.get_size$collection();
        if (element == null) {
            hash$iv = 0;
            index$iv = ArraySetKt.indexOfNull($this$addInternal$iv);
        } else {
            hash$iv = element.hashCode();
            index$iv = ArraySetKt.indexOf($this$addInternal$iv, element, hash$iv);
        }
        if (index$iv >= 0) {
            return false;
        }
        index$iv ^= 0xFFFFFFFF;
        if (oSize$iv >= $this$addInternal$iv.getHashes$collection().length) {
            int n;
            if (oSize$iv >= 8) {
                int n2 = oSize$iv;
                n = n2 + (n2 >> 1);
            } else {
                n = oSize$iv >= 4 ? 8 : 4;
            }
            int n$iv = n;
            int[] ohashes$iv = $this$addInternal$iv.getHashes$collection();
            Object[] oarray$iv = $this$addInternal$iv.getArray$collection();
            ArraySetKt.allocArrays($this$addInternal$iv, n$iv);
            if (oSize$iv != $this$addInternal$iv.get_size$collection()) {
                throw new ConcurrentModificationException();
            }
            if (!($this$addInternal$iv.getHashes$collection().length == 0)) {
                ArraysKt.copyInto$default((int[])ohashes$iv, (int[])$this$addInternal$iv.getHashes$collection(), (int)0, (int)0, (int)ohashes$iv.length, (int)6, null);
                ArraysKt.copyInto$default((Object[])oarray$iv, (Object[])$this$addInternal$iv.getArray$collection(), (int)0, (int)0, (int)oarray$iv.length, (int)6, null);
            }
        }
        if (index$iv < oSize$iv) {
            ArraysKt.copyInto((int[])$this$addInternal$iv.getHashes$collection(), (int[])$this$addInternal$iv.getHashes$collection(), (int)(index$iv + 1), (int)index$iv, (int)oSize$iv);
            ArraysKt.copyInto((Object[])$this$addInternal$iv.getArray$collection(), (Object[])$this$addInternal$iv.getArray$collection(), (int)(index$iv + 1), (int)index$iv, (int)oSize$iv);
        }
        if (var3_3 != $this$addInternal$iv.get_size$collection() || index$iv >= $this$addInternal$iv.getHashes$collection().length) {
            throw new ConcurrentModificationException();
        }
        $this$addInternal$iv.getHashes$collection()[index$iv] = hash$iv;
        $this$addInternal$iv.getArray$collection()[index$iv] = var1_1;
        int n = $this$addInternal$iv.get_size$collection();
        var2_2.set_size$collection(n + 1);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean remove(Object element) {
        ArraySet $this$removeInternal$iv = this;
        int index$iv = $this$removeInternal$iv.indexOf(element);
        if (index$iv >= 0) {
            void var1_2;
            void var2_3;
            var2_3.removeAt((int)var1_2);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final E removeAt(int index) {
        ArraySet $this$removeAtInternal$iv = this;
        int oSize$iv = $this$removeAtInternal$iv.get_size$collection();
        Object old$iv = $this$removeAtInternal$iv.getArray$collection()[index];
        if (oSize$iv <= 1) {
            $this$removeAtInternal$iv.clear();
        } else {
            void var2_2;
            void var3_3;
            int nSize$iv = oSize$iv - 1;
            if ($this$removeAtInternal$iv.getHashes$collection().length > 8 && $this$removeAtInternal$iv.get_size$collection() < $this$removeAtInternal$iv.getHashes$collection().length / 3) {
                int n$iv = $this$removeAtInternal$iv.get_size$collection() > 8 ? $this$removeAtInternal$iv.get_size$collection() + ($this$removeAtInternal$iv.get_size$collection() >> 1) : 8;
                int[] ohashes$iv = $this$removeAtInternal$iv.getHashes$collection();
                Object[] oarray$iv = $this$removeAtInternal$iv.getArray$collection();
                ArraySetKt.allocArrays($this$removeAtInternal$iv, n$iv);
                if (index > 0) {
                    ArraysKt.copyInto$default((int[])ohashes$iv, (int[])$this$removeAtInternal$iv.getHashes$collection(), (int)0, (int)0, (int)index, (int)6, null);
                    ArraysKt.copyInto$default((Object[])oarray$iv, (Object[])$this$removeAtInternal$iv.getArray$collection(), (int)0, (int)0, (int)index, (int)6, null);
                }
                if (index < nSize$iv) {
                    int n = index;
                    ArraysKt.copyInto((int[])ohashes$iv, (int[])$this$removeAtInternal$iv.getHashes$collection(), (int)n, (int)(n + 1), (int)(nSize$iv + 1));
                    int n2 = index;
                    ArraysKt.copyInto((Object[])oarray$iv, (Object[])$this$removeAtInternal$iv.getArray$collection(), (int)n2, (int)(n2 + 1), (int)(nSize$iv + 1));
                }
            } else {
                if (index < nSize$iv) {
                    void var1_1;
                    int n = index;
                    ArraysKt.copyInto((int[])$this$removeAtInternal$iv.getHashes$collection(), (int[])$this$removeAtInternal$iv.getHashes$collection(), (int)n, (int)(n + 1), (int)(nSize$iv + 1));
                    void v3 = var1_1;
                    ArraysKt.copyInto((Object[])$this$removeAtInternal$iv.getArray$collection(), (Object[])$this$removeAtInternal$iv.getArray$collection(), (int)v3, (int)(v3 + true), (int)(nSize$iv + 1));
                }
                $this$removeAtInternal$iv.getArray$collection()[nSize$iv] = null;
            }
            if (var3_3 != $this$removeAtInternal$iv.get_size$collection()) {
                throw new ConcurrentModificationException();
            }
            var2_2.set_size$collection(nSize$iv);
        }
        return (E)old$iv;
    }

    @Override
    public final Object[] toArray() {
        Object[] objectArray = this.array;
        int n = this._size;
        return ArraysKt.copyOfRange((Object[])objectArray, (int)0, (int)n);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> T[] toArray(T[] array) {
        void var1_1;
        Intrinsics.checkNotNullParameter(array, (String)"array");
        Object[] result = ArraySetJvmUtil.resizeForToArray(array, this._size);
        ArraysKt.copyInto((Object[])this.array, (Object[])result, (int)0, (int)0, (int)this._size);
        Intrinsics.checkNotNull((Object)result);
        return var1_1;
    }

    @Override
    public final boolean equals(Object other) {
        block7: {
            ArraySet $this$equalsInternal$iv = this;
            if ($this$equalsInternal$iv == other) {
                return true;
            }
            if (other instanceof Set) {
                if ($this$equalsInternal$iv.size() != ((Set)other).size()) {
                    return false;
                }
                try {
                    int n = $this$equalsInternal$iv.get_size$collection();
                    for (int i$iv = 0; i$iv < n; ++i$iv) {
                        E mine$iv = $this$equalsInternal$iv.valueAt(i$iv);
                        if (((Set)other).contains(mine$iv)) continue;
                        return false;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    break block7;
                }
                catch (ClassCastException classCastException) {
                    break block7;
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int hashCode() {
        void var3_4;
        ArraySet $this$hashCodeInternal$iv = this;
        int[] hashes$iv = $this$hashCodeInternal$iv.getHashes$collection();
        int s$iv = $this$hashCodeInternal$iv.get_size$collection();
        int result$iv = 0;
        for (int i$iv = 0; i$iv < s$iv; ++i$iv) {
            result$iv += hashes$iv[i$iv];
        }
        return (int)var3_4;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var3_4;
        StringBuilder stringBuilder;
        ArraySet $this$toStringInternal$iv = this;
        if ($this$toStringInternal$iv.isEmpty()) {
            return "{}";
        }
        int n = $this$toStringInternal$iv.get_size$collection() * 14;
        StringBuilder $this$toStringInternal_u24lambda_u240$iv = stringBuilder = new StringBuilder(n);
        stringBuilder.append('{');
        int n2 = $this$toStringInternal$iv.get_size$collection();
        for (int i$iv = 0; i$iv < n2; ++i$iv) {
            E value$iv;
            if (i$iv > 0) {
                $this$toStringInternal_u24lambda_u240$iv.append(", ");
            }
            if ((value$iv = $this$toStringInternal$iv.valueAt(i$iv)) != $this$toStringInternal$iv) {
                $this$toStringInternal_u24lambda_u240$iv.append(value$iv);
                continue;
            }
            $this$toStringInternal_u24lambda_u240$iv.append("(this Set)");
        }
        var3_4.append('}');
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    public final Iterator<E> iterator() {
        return new ElementIterator();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean containsAll(Collection<? extends Object> elements) {
        Iterator iterator2;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        ArraySet $this$containsAllInternal$iv = this;
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            void var3_3;
            Object item$iv = iterator2.next();
            if ($this$containsAllInternal$iv.contains(var3_3)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean addAll(Collection<? extends E> elements) {
        void var3_3;
        Iterator iterator2;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        ArraySet $this$addAllInternal$iv = this;
        $this$addAllInternal$iv.ensureCapacity($this$addAllInternal$iv.get_size$collection() + elements.size());
        boolean added$iv = false;
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            Object value$iv = iterator2.next();
            added$iv = $this$addAllInternal$iv.add(value$iv) | added$iv;
        }
        return (boolean)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean removeAll(Collection<? extends Object> elements) {
        void var3_3;
        Iterator iterator2;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        ArraySet $this$removeAllInternal$iv = this;
        boolean removed$iv = false;
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            Object value$iv = iterator2.next();
            removed$iv |= $this$removeAllInternal$iv.remove(value$iv);
        }
        return (boolean)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean retainAll(Collection<? extends Object> elements) {
        void var3_3;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        ArraySet $this$retainAllInternal$iv = this;
        boolean removed$iv = false;
        for (int i$iv = $this$retainAllInternal$iv.get_size$collection() - 1; i$iv >= 0; --i$iv) {
            if (CollectionsKt.contains((Iterable)elements, (Object)$this$retainAllInternal$iv.getArray$collection()[i$iv])) continue;
            $this$retainAllInternal$iv.removeAt(i$iv);
            removed$iv = true;
        }
        return (boolean)var3_3;
    }

    @JvmOverloads
    public ArraySet() {
        this(0, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0006\u001a\u00028\u00002\u0006\u0010\u0005\u001a\u00020\u0004H\u0014\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0014\u00a2\u0006\u0004\b\t\u0010\n"}, d2={"Landroidx/collection/ArraySet$ElementIterator;", "Landroidx/collection/IndexBasedArrayIterator;", "<init>", "(Landroidx/collection/ArraySet;)V", "", "index", "elementAt", "(I)Ljava/lang/Object;", "", "removeAt", "(I)V"})
    private final class ElementIterator
    extends IndexBasedArrayIterator<E> {
        /*
         * WARNING - void declaration
         */
        public ElementIterator() {
            void var1_1;
            super(var1_1.get_size$collection());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final E elementAt(int index) {
            void var1_1;
            return ArraySet.this.valueAt((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void removeAt(int index) {
            void var1_1;
            ArraySet.this.removeAt((int)var1_1);
        }
    }
}

