/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io.files;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.io.JvmCoreKt;
import kotlinx.io.RawSink;
import kotlinx.io.RawSource;
import kotlinx.io.files.FileMetadata;
import kotlinx.io.files.FileSystem;
import kotlinx.io.files.Mover;
import kotlinx.io.files.NioMover;
import kotlinx.io.files.Path;
import kotlinx.io.files.PathsJvmKt;
import kotlinx.io.files.PathsKt;
import kotlinx.io.files.SystemFileSystemImpl;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\"\u0015\u0010\u0003\u001a\u00020\u00008BX\u0082\u0084\u0002\u00a2\u0006\u0006\n\u0004\b\u0001\u0010\u0002\"\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006\"\u0014\u0010\b\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\t\"\u0014\u0010\u000b\u001a\u00020\n8\u0000X\u0081\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\f*\n\u0010\u000e\"\u00020\r2\u00020\r"}, d2={"Lkotlinx/io/files/Mover;", "mover$delegate", "Lkotlin/Lazy;", "mover", "Lkotlinx/io/files/FileSystem;", "SystemFileSystem", "Lkotlinx/io/files/FileSystem;", "Lkotlinx/io/files/Path;", "SystemTemporaryDirectory", "Lkotlinx/io/files/Path;", "", "isWindows", "Z", "Ljava/io/FileNotFoundException;", "FileNotFoundException"})
public final class FileSystemJvmKt {
    private static final Lazy mover$delegate = LazyKt.lazy(FileSystemJvmKt::mover_delegate$lambda$0);
    @JvmField
    public static final FileSystem SystemFileSystem = new SystemFileSystemImpl(){

        /*
         * WARNING - void declaration
         */
        public final boolean exists(Path path) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return var1_1.getFile$kotlinx_io_core().exists();
        }

        /*
         * WARNING - void declaration
         */
        public final void delete(Path path, boolean mustExist) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            if (!this.exists(path)) {
                void var2_2;
                if (var2_2 != false) {
                    throw new FileNotFoundException("File does not exist: " + path.getFile$kotlinx_io_core());
                }
                return;
            }
            if (!var1_1.getFile$kotlinx_io_core().delete()) {
                throw new IOException("Deletion failed");
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void createDirectories(Path path, boolean mustCreate) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            if (!path.getFile$kotlinx_io_core().mkdirs()) {
                void var2_2;
                if (var2_2 != false) {
                    throw new IOException("Path already exist: " + path);
                }
                if (path.getFile$kotlinx_io_core().isFile()) {
                    void var1_1;
                    throw new IOException("Path already exists and it's a file: " + var1_1);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        public final FileMetadata metadataOrNull(Path path) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            if (!path.getFile$kotlinx_io_core().exists()) {
                return null;
            }
            return new FileMetadata(path.getFile$kotlinx_io_core().isFile(), path.getFile$kotlinx_io_core().isDirectory(), path.getFile$kotlinx_io_core().isFile() ? var1_1.getFile$kotlinx_io_core().length() : -1L);
        }

        /*
         * WARNING - void declaration
         */
        public final RawSource source(Path path) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return JvmCoreKt.asSource(new FileInputStream(var1_1.getFile$kotlinx_io_core()));
        }

        /*
         * WARNING - void declaration
         */
        public final RawSink sink(Path path, boolean append) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return JvmCoreKt.asSink(new FileOutputStream(var1_1.getFile$kotlinx_io_core(), (boolean)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public final Path resolve(Path path) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            if (!path.getFile$kotlinx_io_core().exists()) {
                throw new FileNotFoundException(path.getFile$kotlinx_io_core().getAbsolutePath());
            }
            File file = var1_1.getFile$kotlinx_io_core().getCanonicalFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getCanonicalFile(...)");
            return new Path(file);
        }

        public final Collection<Path> list(Path directory) {
            List list;
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            File file = directory.getFile$kotlinx_io_core();
            if (!file.exists()) {
                throw new FileNotFoundException(file.getAbsolutePath());
            }
            if (!file.isDirectory()) {
                throw new IOException("Not a directory: " + file.getAbsolutePath());
            }
            List $this$list_u24lambda_u241 = list = CollectionsKt.createListBuilder();
            String[] stringArray = file.list();
            if (stringArray != null) {
                String[] $this$forEach$iv = stringArray;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    String string;
                    String childName = string = $this$forEach$iv[i];
                    String[] stringArray2 = new String[1];
                    String[] stringArray3 = stringArray2;
                    stringArray2[0] = childName;
                    $this$list_u24lambda_u241.add(PathsKt.Path(directory, stringArray3));
                }
            }
            return CollectionsKt.build((List)list);
        }
    };
    @JvmField
    public static final Path SystemTemporaryDirectory;
    public static final boolean isWindows;

    private static final Mover mover_delegate$lambda$0() {
        Mover mover2;
        try {
            Class.forName("java.nio.file.Files");
            mover2 = new NioMover();
        }
        catch (ClassNotFoundException classNotFoundException) {
            mover2 = new Mover(){};
        }
        return mover2;
    }

    static {
        String string = System.getProperty("java.io.tmpdir");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        SystemTemporaryDirectory = PathsJvmKt.Path(string);
        String string2 = System.getProperty("os.name");
        isWindows = string2 != null ? StringsKt.startsWith$default((String)string2, (String)"Windows", (boolean)false, (int)2, null) : false;
    }
}

