/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io;

import java.io.EOFException;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.CoreKt;
import kotlinx.io.PeekSource;
import kotlinx.io.RawSink;
import kotlinx.io.RawSource;
import kotlinx.io.Source;
import kotlinx.io._UtilKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\n\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\n\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\n\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0012\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J'\u0010\n\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\n\u0010\u001bJ\u001f\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010\u001f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u000f\u0010\"\u001a\u00020!H\u0016\u00a2\u0006\u0004\b\"\u0010#J\u000f\u0010$\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b$\u0010%J\u000f\u0010&\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b&\u0010'J\u000f\u0010(\u001a\u00020\u0001H\u0016\u00a2\u0006\u0004\b(\u0010)J\u000f\u0010*\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b*\u0010+J\u000f\u0010-\u001a\u00020,H\u0016\u00a2\u0006\u0004\b-\u0010.R\u0014\u0010\u0003\u001a\u00020\u00028\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010/R\u0016\u00100\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b0\u00101R\u0014\u00102\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b2\u00103R\u0014\u00106\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105"}, d2={"Lkotlinx/io/RealSource;", "Lkotlinx/io/Source;", "Lkotlinx/io/RawSource;", "source", "<init>", "(Lkotlinx/io/RawSource;)V", "Lkotlinx/io/Buffer;", "sink", "", "byteCount", "readAtMostTo", "(Lkotlinx/io/Buffer;J)J", "", "exhausted", "()Z", "", "require", "(J)V", "request", "(J)Z", "", "readByte", "()B", "", "", "startIndex", "endIndex", "([BII)I", "Lkotlinx/io/RawSink;", "readTo", "(Lkotlinx/io/RawSink;J)V", "transferTo", "(Lkotlinx/io/RawSink;)J", "", "readShort", "()S", "readInt", "()I", "readLong", "()J", "peek", "()Lkotlinx/io/Source;", "close", "()V", "", "toString", "()Ljava/lang/String;", "Lkotlinx/io/RawSource;", "closed", "Z", "bufferField", "Lkotlinx/io/Buffer;", "getBuffer", "()Lkotlinx/io/Buffer;", "buffer"})
@SourceDebugExtension(value={"SMAP\nRealSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealSource.kt\nkotlinx/io/RealSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 -Util.kt\nkotlinx/io/_UtilKt\n*L\n1#1,162:1\n159#1:163\n160#1:165\n159#1:167\n160#1:169\n159#1:170\n160#1:172\n159#1:176\n160#1:178\n159#1:180\n160#1:182\n1#2:164\n1#2:166\n1#2:168\n1#2:171\n1#2:173\n1#2:177\n1#2:179\n1#2:181\n1#2:183\n38#3:174\n110#3:175\n*S KotlinDebug\n*F\n+ 1 RealSource.kt\nkotlinx/io/RealSource\n*L\n38#1:163\n38#1:165\n51#1:167\n51#1:169\n60#1:170\n60#1:172\n127#1:176\n127#1:178\n144#1:180\n144#1:182\n38#1:164\n51#1:168\n60#1:171\n127#1:177\n144#1:181\n74#1:174\n80#1:175\n*E\n"})
public final class RealSource
implements Source {
    public final RawSource source;
    @JvmField
    public boolean closed;
    private final Buffer bufferField;

    /*
     * WARNING - void declaration
     */
    public RealSource(RawSource source) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = var1_1;
        this.bufferField = new Buffer();
    }

    @Override
    public final Buffer getBuffer() {
        return this.bufferField;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long readAtMostTo(Buffer sink, long byteCount) {
        void var1_1;
        void var2_2;
        long l;
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        RealSource realSource = this;
        if (!(!realSource.closed)) {
            sink = "Source is closed.";
            throw new IllegalStateException(sink.toString());
        }
        if (!(byteCount >= 0L)) {
            String string = "byteCount: " + byteCount;
            throw new IllegalArgumentException(string.toString());
        }
        if (this.bufferField.getSize() == 0L && (l = this.source.readAtMostTo(this.bufferField, 8192L)) == -1L) {
            return -1L;
        }
        long toRead = Math.min((long)var2_2, this.bufferField.getSize());
        return this.bufferField.readAtMostTo((Buffer)var1_1, toRead);
    }

    @Override
    public final boolean exhausted() {
        Object object = this;
        if (!(!((RealSource)object).closed)) {
            object = "Source is closed.";
            throw new IllegalStateException(object.toString());
        }
        return this.bufferField.exhausted() && this.source.readAtMostTo(this.bufferField, 8192L) == -1L;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void require(long byteCount) {
        if (!this.request(byteCount)) {
            void var1_1;
            throw new EOFException("Source doesn't contain required number of bytes (" + (long)var1_1 + ").");
        }
    }

    @Override
    public final boolean request(long byteCount22) {
        long byteCount22;
        RealSource realSource = this;
        if (!(!realSource.closed)) {
            String byteCount22 = "Source is closed.";
            throw new IllegalStateException(byteCount22.toString());
        }
        if (!(byteCount22 >= 0L)) {
            String byteCount22 = "byteCount: " + byteCount22;
            throw new IllegalArgumentException(byteCount22.toString());
        }
        while (this.bufferField.getSize() < byteCount22) {
            if (this.source.readAtMostTo(this.bufferField, 8192L) != -1L) continue;
            return false;
        }
        return true;
    }

    @Override
    public final byte readByte() {
        this.require(1L);
        return this.bufferField.readByte();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int readAtMostTo(byte[] sink, int startIndex, int endIndex) {
        void var1_1;
        void var2_2;
        void a$iv;
        void var3_3;
        long l;
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        int n = sink.length;
        _UtilKt.checkBounds(n, startIndex, endIndex);
        if (this.bufferField.getSize() == 0L && (l = this.source.readAtMostTo(this.bufferField, 8192L)) == -1L) {
            return -1;
        }
        void var5_6 = var3_3 - startIndex;
        long b$iv = this.bufferField.getSize();
        int toRead = (int)Math.min((long)a$iv, b$iv);
        void v0 = var2_2;
        return this.bufferField.readAtMostTo((byte[])var1_1, (int)v0, (int)(v0 + toRead));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void readTo(RawSink sink, long byteCount) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        try {
            this.require(byteCount);
        }
        catch (EOFException e) {
            void var2_3;
            sink.write(this.bufferField, this.bufferField.getSize());
            throw var2_3;
        }
        this.bufferField.readTo((RawSink)var1_1, (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long transferTo(RawSink sink) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        long totalBytesWritten = 0L;
        while (this.source.readAtMostTo(this.bufferField, 8192L) != -1L) {
            long emitByteCount = this.bufferField.completeSegmentByteCount$kotlinx_io_core();
            if (emitByteCount <= 0L) continue;
            totalBytesWritten += emitByteCount;
            sink.write(this.bufferField, emitByteCount);
        }
        if (this.bufferField.getSize() > 0L) {
            void var1_1;
            totalBytesWritten += this.bufferField.getSize();
            var1_1.write(this.bufferField, this.bufferField.getSize());
        }
        return (long)var2_2;
    }

    @Override
    public final short readShort() {
        this.require(2L);
        return this.bufferField.readShort();
    }

    @Override
    public final int readInt() {
        this.require(4L);
        return this.bufferField.readInt();
    }

    @Override
    public final long readLong() {
        this.require(8L);
        return this.bufferField.readLong();
    }

    @Override
    public final Source peek() {
        Object object = this;
        if (!(!((RealSource)object).closed)) {
            object = "Source is closed.";
            throw new IllegalStateException(object.toString());
        }
        return CoreKt.buffered(new PeekSource(this));
    }

    @Override
    public final void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.source.close();
        this.bufferField.clear();
    }

    public final String toString() {
        return "buffered(" + this.source + ')';
    }
}

