/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io;

import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.JvmCoreKt;
import kotlinx.io.RawSource;
import kotlinx.io.Segment;
import kotlinx.io.SegmentKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0013\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\n\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0012"}, d2={"Lkotlinx/io/InputStreamSource;", "Lkotlinx/io/RawSource;", "Ljava/io/InputStream;", "input", "<init>", "(Ljava/io/InputStream;)V", "Lkotlinx/io/Buffer;", "sink", "", "byteCount", "readAtMostTo", "(Lkotlinx/io/Buffer;J)J", "", "close", "()V", "", "toString", "()Ljava/lang/String;", "Ljava/io/InputStream;"})
@SourceDebugExtension(value={"SMAP\nJvmCore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmCore.kt\nkotlinx/io/InputStreamSource\n+ 2 -Util.kt\nkotlinx/io/_UtilKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 UnsafeBufferOperations.kt\nkotlinx/io/unsafe/UnsafeBufferOperations\n*L\n1#1,112:1\n52#2:113\n53#2:115\n107#2:122\n1#3:114\n195#4,6:116\n203#4,20:123\n*S KotlinDebug\n*F\n+ 1 JvmCore.kt\nkotlinx/io/InputStreamSource\n*L\n80#1:113\n80#1:115\n84#1:122\n80#1:114\n83#1:116,6\n83#1:123,20\n*E\n"})
class InputStreamSource
implements RawSource {
    private final InputStream input;

    /*
     * WARNING - void declaration
     */
    public InputStreamSource(InputStream input) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.input = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long readAtMostTo(Buffer sink, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        if (byteCount == 0L) {
            return 0L;
        }
        if (!(byteCount >= 0L)) {
            sink = "byteCount (" + byteCount + ") < 0";
            throw new IllegalArgumentException(sink.toString());
        }
        try {
            void pos;
            void limit;
            Segment tail$iv = ((Buffer)sink).writableSegment(1);
            byte[] data$iv = tail$iv.dataAsByteArray(false);
            int n = data$iv.length;
            int n2 = tail$iv.getLimit();
            byte[] data = data$iv;
            void b$iv = limit - pos;
            int maxToCopy = (int)Math.min(byteCount, (long)b$iv);
            long readTotal = this.input.read(data, (int)pos, maxToCopy);
            int bytesWritten$iv = readTotal == -1L ? 0 : (int)readTotal;
            if (bytesWritten$iv == 1) {
                tail$iv.writeBackData(data$iv, bytesWritten$iv);
                Segment segment = tail$iv;
                segment.setLimit(segment.getLimit() + bytesWritten$iv);
                Object object = sink;
                ((Buffer)object).setSizeMut(((Buffer)object).getSizeMut() + (long)bytesWritten$iv);
            } else {
                if (!(bytesWritten$iv >= 0 ? bytesWritten$iv <= tail$iv.getRemainingCapacity() : false)) {
                    sink = "Invalid number of bytes written: " + bytesWritten$iv + ". Should be in 0.." + tail$iv.getRemainingCapacity();
                    throw new IllegalStateException(sink.toString());
                }
                if (bytesWritten$iv != 0) {
                    void var2_3;
                    tail$iv.writeBackData(data$iv, bytesWritten$iv);
                    Segment segment = tail$iv;
                    segment.setLimit(segment.getLimit() + bytesWritten$iv);
                    Object object = sink;
                    ((Buffer)object).setSizeMut(((Buffer)object).getSizeMut() + (long)var2_3);
                } else if (SegmentKt.isEmpty(tail$iv)) {
                    ((Buffer)sink).recycleTail();
                }
            }
            return readTotal;
        }
        catch (AssertionError assertionError) {
            void var1_1;
            AssertionError e = assertionError;
            if (JvmCoreKt.isAndroidGetsocknameError(assertionError)) {
                throw new IOException((Throwable)((Object)e));
            }
            throw var1_1;
        }
    }

    @Override
    public void close() {
        this.input.close();
    }

    public String toString() {
        return "RawSource(" + this.input + ')';
    }
}

