/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.Segment;
import kotlinx.io.SegmentKt;
import kotlinx.io.Sink;
import kotlinx.io.Source;
import kotlinx.io.SourcesKt;
import kotlinx.io._UtilKt;
import kotlinx.io.bytestring.ByteString;
import kotlinx.io.bytestring.unsafe.UnsafeByteStringOperations;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a-\u0010\u0007\u001a\u00020\u0006*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\b\u001a\u0011\u0010\n\u001a\u00020\u0001*\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000b\u001a\u0019\u0010\n\u001a\u00020\u0001*\u00020\t2\u0006\u0010\f\u001a\u00020\u0003\u00a2\u0006\u0004\b\n\u0010\r"}, d2={"Lkotlinx/io/Sink;", "Lkotlinx/io/bytestring/ByteString;", "byteString", "", "startIndex", "endIndex", "", "write", "(Lkotlinx/io/Sink;Lkotlinx/io/bytestring/ByteString;II)V", "Lkotlinx/io/Source;", "readByteString", "(Lkotlinx/io/Source;)Lkotlinx/io/bytestring/ByteString;", "byteCount", "(Lkotlinx/io/Source;I)Lkotlinx/io/bytestring/ByteString;"})
@SourceDebugExtension(value={"SMAP\nByteStrings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteStrings.kt\nkotlinx/io/ByteStringsKt\n+ 2 -Util.kt\nkotlinx/io/_UtilKt\n+ 3 Sinks.kt\nkotlinx/io/SinksKt\n+ 4 UnsafeByteStringOperations.kt\nkotlinx/io/bytestring/unsafe/UnsafeByteStringOperations\n+ 5 UnsafeBufferOperations.kt\nkotlinx/io/unsafe/UnsafeBufferOperations\n+ 6 Buffer.kt\nkotlinx/io/BufferKt\n*L\n1#1,183:1\n38#2:184\n374#3:185\n375#3,2:216\n42#4:186\n43#4:215\n42#4:218\n43#4:244\n195#5,28:187\n659#6,25:219\n*S KotlinDebug\n*F\n+ 1 ByteStrings.kt\nkotlinx/io/ByteStringsKt\n*L\n32#1:184\n37#1:185\n37#1:216,2\n40#1:186\n40#1:215\n144#1:218\n144#1:244\n43#1:187,28\n145#1:219,25\n*E\n"})
public final class ByteStringsKt {
    /*
     * WARNING - void declaration
     */
    public static final void write(Sink $this$write, ByteString byteString, int startIndex, int endIndex) {
        void offset;
        Intrinsics.checkNotNullParameter((Object)$this$write, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)byteString, (String)"byteString");
        int n = byteString.getSize();
        _UtilKt.checkBounds(n, startIndex, endIndex);
        if (endIndex == startIndex) {
            return;
        }
        Sink $this$writeToInternalBuffer$iv = $this$write;
        Object buffer = $this$writeToInternalBuffer$iv.getBuffer();
        byte[] data = byteString.getBackingArrayReference();
        while (offset < endIndex) {
            void pos;
            void limit;
            Segment tail$iv = ((Buffer)buffer).writableSegment(1);
            byte[] data$iv = tail$iv.dataAsByteArray(false);
            int n2 = data$iv.length;
            int n3 = tail$iv.getLimit();
            byte[] segData = data$iv;
            int written = Math.min(endIndex - offset, (int)(limit - pos));
            void v0 = offset;
            ArraysKt.copyInto((byte[])data, (byte[])segData, (int)pos, (int)v0, (int)(v0 + written));
            int bytesWritten$iv = written;
            if (bytesWritten$iv == 1) {
                tail$iv.writeBackData(data$iv, bytesWritten$iv);
                Segment segment = tail$iv;
                segment.setLimit(segment.getLimit() + bytesWritten$iv);
                Sink sink = buffer;
                ((Buffer)sink).setSizeMut(((Buffer)sink).getSizeMut() + (long)bytesWritten$iv);
            } else {
                if (!(bytesWritten$iv >= 0 ? bytesWritten$iv <= tail$iv.getRemainingCapacity() : false)) {
                    buffer = "Invalid number of bytes written: " + bytesWritten$iv + ". Should be in 0.." + tail$iv.getRemainingCapacity();
                    throw new IllegalStateException(buffer.toString());
                }
                if (bytesWritten$iv != 0) {
                    tail$iv.writeBackData(data$iv, bytesWritten$iv);
                    Segment segment = tail$iv;
                    segment.setLimit(segment.getLimit() + bytesWritten$iv);
                    Object object = buffer;
                    ((Buffer)object).setSizeMut(((Buffer)object).getSizeMut() + (long)bytesWritten$iv);
                } else if (SegmentKt.isEmpty(tail$iv)) {
                    ((Buffer)buffer).recycleTail();
                }
            }
            offset += written;
        }
        $this$writeToInternalBuffer$iv.hintEmit();
    }

    public static /* synthetic */ void write$default(Sink sink, ByteString byteString, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byteString.getSize();
        }
        ByteStringsKt.write(sink, byteString, n, n2);
    }

    public static final ByteString readByteString(Source $this$readByteString) {
        Source source;
        Intrinsics.checkNotNullParameter((Object)$this$readByteString, (String)"<this>");
        return UnsafeByteStringOperations.INSTANCE.wrapUnsafe(SourcesKt.readByteArray(source));
    }

    /*
     * WARNING - void declaration
     */
    public static final ByteString readByteString(Source $this$readByteString, int byteCount) {
        void var1_1;
        Source source;
        Intrinsics.checkNotNullParameter((Object)$this$readByteString, (String)"<this>");
        return UnsafeByteStringOperations.INSTANCE.wrapUnsafe(SourcesKt.readByteArray(source, (int)var1_1));
    }
}

