/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.collections.immutable.implementations.immutableList;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.collections.immutable.PersistentList;
import kotlinx.collections.immutable.implementations.immutableList.AbstractPersistentList;
import kotlinx.collections.immutable.implementations.immutableList.BufferIterator;
import kotlinx.collections.immutable.implementations.immutableList.PersistentVector;
import kotlinx.collections.immutable.implementations.immutableList.PersistentVectorBuilder;
import kotlinx.collections.immutable.implementations.immutableList.UtilsKt;
import kotlinx.collections.immutable.internal.CommonFunctionsKt;
import kotlinx.collections.immutable.internal.ListImplementation;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010*\n\u0002\b\t\b\u0001\u0018\u0000 $*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u00022\b\u0012\u0004\u0012\u00028\u00000\u0003:\u0001$B\u0017\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\u0006\u0010\t\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ#\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0018\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\u0014H\u0096\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0018\u001a\u00020\u00142\u0006\u0010\t\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001a\u001a\u00020\u00142\u0006\u0010\t\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u0019J\u001d\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001b2\u0006\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001d\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\u0006\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u001c\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010 R\u0014\u0010#\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\""}, d2={"Lkotlinx/collections/immutable/implementations/immutableList/SmallPersistentVector;", "E", "Lkotlinx/collections/immutable/ImmutableList;", "Lkotlinx/collections/immutable/implementations/immutableList/AbstractPersistentList;", "", "", "buffer", "<init>", "([Ljava/lang/Object;)V", "element", "Lkotlinx/collections/immutable/PersistentList;", "add", "(Ljava/lang/Object;)Lkotlinx/collections/immutable/PersistentList;", "", "elements", "addAll", "(Ljava/util/Collection;)Lkotlinx/collections/immutable/PersistentList;", "Lkotlinx/collections/immutable/PersistentList$Builder;", "builder", "()Lkotlinx/collections/immutable/PersistentList$Builder;", "", "index", "get", "(I)Ljava/lang/Object;", "indexOf", "(Ljava/lang/Object;)I", "lastIndexOf", "", "listIterator", "(I)Ljava/util/ListIterator;", "removeAt", "(I)Lkotlinx/collections/immutable/PersistentList;", "[Ljava/lang/Object;", "getSize", "()I", "size", "Companion"})
@SourceDebugExtension(value={"SMAP\nSmallPersistentVector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SmallPersistentVector.kt\nkotlinx/collections/immutable/implementations/immutableList/SmallPersistentVector\n+ 2 extensions.kt\nkotlinx/collections/immutable/ExtensionsKt\n+ 3 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,165:1\n41#2:166\n41#2:167\n26#3:168\n*S KotlinDebug\n*F\n+ 1 SmallPersistentVector.kt\nkotlinx/collections/immutable/implementations/immutableList/SmallPersistentVector\n*L\n49#1:166\n95#1:167\n163#1:168\n*E\n"})
public final class SmallPersistentVector<E>
extends AbstractPersistentList<E> {
    public static final Companion Companion = new Companion(null);
    private final Object[] buffer;
    private static final SmallPersistentVector EMPTY = new SmallPersistentVector(new Object[0]);

    /*
     * WARNING - void declaration
     */
    public SmallPersistentVector(Object[] buffer) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.buffer = var1_1;
        CommonFunctionsKt.assert(this.buffer.length <= 32);
    }

    public final int getSize() {
        return this.buffer.length;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final PersistentList<E> add(E element) {
        void var2_3;
        void var1_1;
        if (this.size() < 32) {
            Object[] objectArray = Arrays.copyOf(this.buffer, this.size() + 1);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
            Object[] newBuffer = objectArray;
            objectArray[this.size()] = element;
            return new SmallPersistentVector<E>(newBuffer);
        }
        Object[] tail = UtilsKt.presizedBufferWith(var1_1);
        return new PersistentVector(this.buffer, (Object[])var2_3, this.size() + 1, 0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final PersistentList<E> addAll(Collection<? extends E> elements) {
        void var1_1;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (elements.isEmpty()) {
            return this;
        }
        if (this.size() + elements.size() <= 32) {
            void var2_2;
            Object[] objectArray = Arrays.copyOf(this.buffer, this.size() + elements.size());
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
            Object[] newBuffer = objectArray;
            int index = this.size();
            for (E element : elements) {
                newBuffer[index++] = element;
            }
            return new SmallPersistentVector<E>((Object[])var2_2);
        }
        PersistentList persistentList = this;
        PersistentList.Builder builder = persistentList.builder();
        List list = builder;
        list.addAll(var1_1);
        return builder.build();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final PersistentList<E> removeAt(int index) {
        void var2_2;
        void var1_1;
        ListImplementation.checkElementIndex$kotlinx_collections_immutable(index, this.size());
        if (this.size() == 1) {
            return EMPTY;
        }
        Object[] objectArray = Arrays.copyOf(this.buffer, this.size() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
        Object[] newBuffer = objectArray;
        void v1 = var1_1;
        ArraysKt.copyInto((Object[])this.buffer, (Object[])newBuffer, (int)v1, (int)(v1 + true), (int)this.size());
        return new SmallPersistentVector<E>((Object[])var2_2);
    }

    @Override
    public final PersistentList.Builder<E> builder() {
        return new PersistentVectorBuilder(this, null, this.buffer, 0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int indexOf(Object element) {
        void var1_1;
        return ArraysKt.indexOf((Object[])this.buffer, (Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int lastIndexOf(Object element) {
        void var1_1;
        return ArraysKt.lastIndexOf((Object[])this.buffer, (Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ListIterator<E> listIterator(int index) {
        void var1_1;
        ListImplementation.checkPositionIndex$kotlinx_collections_immutable(index, this.size());
        return new BufferIterator<Object>(this.buffer, (int)var1_1, this.size());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final E get(int index) {
        void var1_1;
        ListImplementation.checkElementIndex$kotlinx_collections_immutable(index, this.size());
        return (E)this.buffer[var1_1];
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\t"}, d2={"Lkotlinx/collections/immutable/implementations/immutableList/SmallPersistentVector$Companion;", "", "<init>", "()V", "Lkotlinx/collections/immutable/implementations/immutableList/SmallPersistentVector;", "", "EMPTY", "Lkotlinx/collections/immutable/implementations/immutableList/SmallPersistentVector;", "getEMPTY", "()Lkotlinx/collections/immutable/implementations/immutableList/SmallPersistentVector;"})
    public static final class Companion {
        private Companion() {
        }

        public final SmallPersistentVector getEMPTY() {
            return EMPTY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

