/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.collections.immutable.implementations.immutableList;

import java.util.Arrays;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.collections.immutable.PersistentList;
import kotlinx.collections.immutable.implementations.immutableList.AbstractPersistentList;
import kotlinx.collections.immutable.implementations.immutableList.ObjectRef;
import kotlinx.collections.immutable.implementations.immutableList.PersistentVectorBuilder;
import kotlinx.collections.immutable.implementations.immutableList.PersistentVectorIterator;
import kotlinx.collections.immutable.implementations.immutableList.SmallPersistentVector;
import kotlinx.collections.immutable.implementations.immutableList.UtilsKt;
import kotlinx.collections.immutable.internal.CommonFunctionsKt;
import kotlinx.collections.immutable.internal.ListImplementation;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010*\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0015\b\u0001\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u00022\b\u0012\u0004\u0012\u00028\u00000\u0003B7\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001d\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010\r\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0006\u0010\u0010\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0018\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\bH\u0096\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001d\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u00182\u0006\u0010\u0010\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJA\u0010\u001e\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u00042\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ5\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0006\u0010 \u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b!\u0010\"JE\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u000e\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u000e\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004H\u0002\u00a2\u0006\u0004\b%\u0010&JA\u0010'\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0010\u0010\u0006\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u00042\u0006\u0010\u001b\u001a\u00020\b2\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004H\u0002\u00a2\u0006\u0004\b'\u0010(J\u001d\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010\u0010\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b)\u0010*J?\u0010+\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002\u00a2\u0006\u0004\b+\u0010\u001fJ=\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0006\u0010 \u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b,\u0010-J\u000f\u0010 \u001a\u00020\bH\u0002\u00a2\u0006\u0004\b \u0010.R\u001c\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010/R\u0014\u0010\n\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u00100R\u001a\u0010\t\u001a\u00020\b8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\t\u00100\u001a\u0004\b1\u0010.R\u001c\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010/"}, d2={"Lkotlinx/collections/immutable/implementations/immutableList/PersistentVector;", "E", "Lkotlinx/collections/immutable/PersistentList;", "Lkotlinx/collections/immutable/implementations/immutableList/AbstractPersistentList;", "", "", "root", "tail", "", "size", "rootShift", "<init>", "([Ljava/lang/Object;[Ljava/lang/Object;II)V", "element", "add", "(Ljava/lang/Object;)Lkotlinx/collections/immutable/PersistentList;", "index", "bufferFor", "(I)[Ljava/lang/Object;", "Lkotlinx/collections/immutable/implementations/immutableList/PersistentVectorBuilder;", "builder", "()Lkotlinx/collections/immutable/implementations/immutableList/PersistentVectorBuilder;", "get", "(I)Ljava/lang/Object;", "", "listIterator", "(I)Ljava/util/ListIterator;", "shift", "Lkotlinx/collections/immutable/implementations/immutableList/ObjectRef;", "tailCarry", "pullLastBuffer", "([Ljava/lang/Object;IILkotlinx/collections/immutable/implementations/immutableList/ObjectRef;)[Ljava/lang/Object;", "rootSize", "pullLastBufferFromRoot", "([Ljava/lang/Object;II)Lkotlinx/collections/immutable/PersistentList;", "filledTail", "newTail", "pushFilledTail", "([Ljava/lang/Object;[Ljava/lang/Object;[Ljava/lang/Object;)Lkotlinx/collections/immutable/implementations/immutableList/PersistentVector;", "pushTail", "([Ljava/lang/Object;I[Ljava/lang/Object;)[Ljava/lang/Object;", "removeAt", "(I)Lkotlinx/collections/immutable/PersistentList;", "removeFromRootAt", "removeFromTailAt", "([Ljava/lang/Object;III)Lkotlinx/collections/immutable/PersistentList;", "()I", "[Ljava/lang/Object;", "I", "getSize"})
@SourceDebugExtension(value={"SMAP\nPersistentVector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PersistentVector.kt\nkotlinx/collections/immutable/implementations/immutableList/PersistentVector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,325:1\n1#2:326\n*E\n"})
public final class PersistentVector<E>
extends AbstractPersistentList<E> {
    private final Object[] root;
    private final Object[] tail;
    private final int size;
    private final int rootShift;

    /*
     * WARNING - void declaration
     */
    public PersistentVector(Object[] root, Object[] tail, int size, int rootShift) {
        void var3_3;
        void var2_2;
        String string;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)tail, (String)"tail");
        this.root = string;
        this.tail = var2_2;
        this.size = var3_3;
        this.rootShift = rootShift;
        if (!(this.size() > 32)) {
            string = "Trie-based persistent vector should have at least 33 elements, got " + this.size();
            throw new IllegalArgumentException(string.toString());
        }
        CommonFunctionsKt.assert(this.size() - UtilsKt.rootSize(this.size()) <= RangesKt.coerceAtMost((int)this.tail.length, (int)32));
    }

    public final int getSize() {
        return this.size;
    }

    private final int rootSize() {
        return UtilsKt.rootSize(this.size());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final PersistentList<E> add(E element) {
        void var3_4;
        void var1_1;
        int tailSize = this.size() - this.rootSize();
        if (tailSize < 32) {
            Object[] objectArray = Arrays.copyOf(this.tail, 32);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
            Object[] newTail = objectArray;
            objectArray[var2_2] = element;
            return new PersistentVector<E>(this.root, newTail, this.size() + 1, this.rootShift);
        }
        Object[] newTail = UtilsKt.presizedBufferWith(var1_1);
        PersistentVector persistentVector = this;
        return persistentVector.pushFilledTail(persistentVector.root, this.tail, (Object[])var3_4);
    }

    /*
     * WARNING - void declaration
     */
    private final PersistentVector<E> pushFilledTail(Object[] root, Object[] filledTail, Object[] newTail) {
        void var3_3;
        void var1_1;
        void var2_2;
        Object[] newRoot;
        if (this.size() >> 5 > 1 << this.rootShift) {
            newRoot = UtilsKt.presizedBufferWith(root);
            int newRootShift = this.rootShift + 5;
            newRoot = this.pushTail(newRoot, newRootShift, filledTail);
            return new PersistentVector<E>(newRoot, newTail, this.size() + 1, newRootShift);
        }
        newRoot = this.pushTail(newRoot, this.rootShift, (Object[])var2_2);
        return new PersistentVector<E>((Object[])var1_1, (Object[])var3_3, this.size() + 1, this.rootShift);
    }

    /*
     * WARNING - void declaration
     */
    private final Object[] pushTail(Object[] root, int shift, Object[] tail) {
        void var1_1;
        void var3_3;
        void var2_2;
        Object[] objectArray;
        int bufferIndex;
        block3: {
            block2: {
                bufferIndex = UtilsKt.indexSegment(this.size() - 1, shift);
                objectArray = root;
                if (root == null) break block2;
                Object[] objectArray2 = Arrays.copyOf(objectArray, 32);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"copyOf(...)");
                objectArray = objectArray2;
                if (objectArray2 != null) break block3;
            }
            objectArray = new Object[32];
        }
        Object[] newRootNode = objectArray;
        newRootNode[bufferIndex] = shift == 5 ? tail : this.pushTail((Object[])newRootNode[bufferIndex], (int)(var2_2 - 5), (Object[])var3_3);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final PersistentList<E> removeAt(int index) {
        void var2_3;
        void var1_2;
        ListImplementation.checkElementIndex$kotlinx_collections_immutable(index, this.size());
        int rootSize = this.rootSize();
        if (index >= rootSize) {
            PersistentVector persistentVector = this;
            return persistentVector.removeFromTailAt(persistentVector.root, rootSize, this.rootShift, index - rootSize);
        }
        PersistentVector persistentVector = this;
        Object[] newRoot = persistentVector.removeFromRootAt(persistentVector.root, this.rootShift, index, new ObjectRef(this.tail[0]));
        return this.removeFromTailAt((Object[])var1_2, (int)var2_3, this.rootShift, 0);
    }

    /*
     * WARNING - void declaration
     */
    private final PersistentList<E> removeFromTailAt(Object[] root, int rootSize, int shift, int index) {
        void var3_3;
        void var2_2;
        void var1_1;
        int tailSize = this.size() - rootSize;
        CommonFunctionsKt.assert(index < tailSize);
        if (tailSize == 1) {
            return this.pullLastBufferFromRoot(root, rootSize, shift);
        }
        Object[] objectArray = Arrays.copyOf(this.tail, 32);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
        Object[] newTail = objectArray;
        if (index < tailSize - 1) {
            int n = index;
            ArraysKt.copyInto((Object[])this.tail, (Object[])newTail, (int)n, (int)(n + 1), (int)tailSize);
        }
        newTail[tailSize - 1] = null;
        return new PersistentVector<E>((Object[])var1_1, newTail, (int)(var2_2 + tailSize - true), (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private final PersistentList<E> pullLastBufferFromRoot(Object[] root, int rootSize, int shift) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (shift == 0) {
            Object[] objectArray;
            if (root.length == 33) {
                Object[] objectArray2 = Arrays.copyOf(root, 32);
                objectArray = objectArray2;
                Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"copyOf(...)");
            } else {
                objectArray = root;
            }
            Object[] buffer = objectArray;
            return new SmallPersistentVector(buffer);
        }
        ObjectRef tailCarry = new ObjectRef(null);
        Object[] objectArray = this.pullLastBuffer(root, shift, rootSize - 1, tailCarry);
        Intrinsics.checkNotNull((Object)objectArray);
        Object[] newRoot = objectArray;
        Object object = tailCarry.getValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
        Object[] newTail = (Object[])object;
        if (newRoot[1] == null) {
            Object object2 = newRoot[0];
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
            Object[] lowerLevelRoot = (Object[])object2;
            return new PersistentVector<E>((Object[])var1_1, newTail, rootSize, shift - 5);
        }
        return new PersistentVector<E>((Object[])var1_1, newTail, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private final Object[] pullLastBuffer(Object[] root, int shift, int index, ObjectRef tailCarry) {
        void var1_1;
        void var2_3;
        Object[] objectArray;
        int bufferIndex = UtilsKt.indexSegment(index, shift);
        if (shift == 5) {
            tailCarry.setValue(root[bufferIndex]);
            objectArray = null;
        } else {
            void var3_4;
            Object[] newBufferAtIndex;
            Object object = root[bufferIndex];
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
            objectArray = newBufferAtIndex = this.pullLastBuffer((Object[])object, shift - 5, (int)var3_4, tailCarry);
        }
        if (objectArray == null && bufferIndex == 0) {
            return null;
        }
        Object[] objectArray2 = Arrays.copyOf(root, 32);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"copyOf(...)");
        Object[] newRoot = objectArray2;
        objectArray2[bufferIndex] = var2_3;
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private final Object[] removeFromRootAt(Object[] root, int shift, int index, ObjectRef tailCarry) {
        void var1_1;
        void var3_3;
        void var2_2;
        int bufferIndex = UtilsKt.indexSegment(index, shift);
        if (shift == 0) {
            Object[] objectArray;
            if (bufferIndex == 0) {
                objectArray = new Object[32];
            } else {
                Object[] objectArray2 = Arrays.copyOf(root, 32);
                objectArray = objectArray2;
                Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"copyOf(...)");
            }
            Object[] newRoot = objectArray;
            int n = bufferIndex;
            ArraysKt.copyInto((Object[])root, (Object[])newRoot, (int)n, (int)(n + 1), (int)32);
            newRoot[31] = tailCarry.getValue();
            tailCarry.setValue(root[bufferIndex]);
            return newRoot;
        }
        int bufferLastIndex = 31;
        if (root[31] == null) {
            bufferLastIndex = UtilsKt.indexSegment(this.rootSize() - 1, shift);
        }
        Object[] objectArray = Arrays.copyOf(root, 32);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
        Object[] newRoot = objectArray;
        int lowerLevelShift = shift - 5;
        int i = bufferLastIndex;
        int n = bufferIndex + 1;
        if (n <= i) {
            while (true) {
                Object object = newRoot[i];
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
                newRoot[i] = this.removeFromRootAt((Object[])object, lowerLevelShift, 0, tailCarry);
                if (i == n) break;
                --i;
            }
        }
        Object object = newRoot[bufferIndex];
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
        newRoot[bufferIndex] = this.removeFromRootAt((Object[])object, (int)var2_2, (int)var3_3, tailCarry);
        return var1_1;
    }

    @Override
    public final PersistentVectorBuilder<E> builder() {
        return new PersistentVectorBuilder(this, this.root, this.tail, this.rootShift);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ListIterator<E> listIterator(int index) {
        void var1_1;
        ListImplementation.checkPositionIndex$kotlinx_collections_immutable(index, this.size());
        return new PersistentVectorIterator<Object>(this.root, this.tail, (int)var1_1, this.size(), this.rootShift / 5 + 1);
    }

    /*
     * WARNING - void declaration
     */
    private final Object[] bufferFor(int index) {
        void var2_2;
        if (this.rootSize() <= index) {
            return this.tail;
        }
        Object[] buffer = this.root;
        for (int shift = this.rootShift; shift > 0; shift -= 5) {
            Object object = buffer[UtilsKt.indexSegment(index, shift)];
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
            buffer = (Object[])object;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final E get(int index) {
        void var1_1;
        ListImplementation.checkElementIndex$kotlinx_collections_immutable(index, this.size());
        Object[] objectArray = this.bufferFor(index);
        return (E)objectArray[var1_1 & 0x1F];
    }
}

