/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.util;

import io.sentry.ILogger;
import io.sentry.SentryLevel;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.regex.Pattern;

public final class StringUtils {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Pattern PATTERN_WORD_SNAKE_CASE = Pattern.compile("[\\W_]+");

    public static String capitalize(String str) {
        String string;
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.substring(0, 1).toUpperCase(Locale.ROOT) + string.substring(1).toLowerCase(Locale.ROOT);
    }

    /*
     * WARNING - void declaration
     */
    public static String camelCase(String str) {
        void var1_1;
        String[] stringArray;
        if (str == null || str.isEmpty()) {
            return str;
        }
        String[] words = PATTERN_WORD_SNAKE_CASE.split(str, -1);
        StringBuilder builder = new StringBuilder();
        for (String w : stringArray) {
            builder.append(StringUtils.capitalize(w));
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String removeSurrounding(String str, String delimiter) {
        String string;
        if (str != null && delimiter != null && str.startsWith(delimiter) && str.endsWith(delimiter)) {
            void var1_1;
            return str.substring(delimiter.length(), str.length() - var1_1.length());
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static String calculateStringHash(String str, ILogger logger) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            byte[] messageDigest2 = messageDigest.digest(str.getBytes(UTF_8));
            Comparable<BigInteger> no = new BigInteger(1, messageDigest2);
            no = new StringBuilder(no.toString(16));
            return ((StringBuilder)no).toString();
        }
        catch (NoSuchAlgorithmException e) {
            logger.log(SentryLevel.INFO, "SHA-1 isn't available to calculate the hash.", e);
        }
        catch (Throwable e) {
            String string;
            void var2_4;
            void var1_1;
            var1_1.log(SentryLevel.INFO, "string: %s could not calculate its hash", var2_4, string);
        }
        return null;
    }

    public static String normalizeUUID(String uuidString) {
        String string;
        if (uuidString.equals("0000-0000")) {
            return "00000000-0000-0000-0000-000000000000";
        }
        return string;
    }

    public static String toString(Object object) {
        Object object2;
        if (object == null) {
            return null;
        }
        return object2.toString();
    }
}

