/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.util;

import io.sentry.ISentryLifecycleToken;
import io.sentry.util.AutoClosableReentrantLock;

public final class LazyEvaluator<T> {
    private volatile T value = null;
    private final Evaluator<T> evaluator;
    private final AutoClosableReentrantLock lock = new AutoClosableReentrantLock();

    /*
     * WARNING - void declaration
     */
    public LazyEvaluator(Evaluator<T> evaluator) {
        void var1_1;
        this.evaluator = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final T getValue() {
        if (this.value == null) {
            ISentryLifecycleToken ignored = this.lock.acquire();
            try {
                if (this.value == null) {
                    this.value = this.evaluator.evaluate();
                }
                if (ignored != null) {
                    ignored.close();
                }
            }
            catch (Throwable throwable) {
                if (ignored != null) {
                    try {
                        void var1_1;
                        var1_1.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        return this.value;
    }

    /*
     * WARNING - void declaration
     */
    public final void resetValue() {
        ISentryLifecycleToken ignored = this.lock.acquire();
        try {
            this.value = null;
            if (ignored != null) {
                ignored.close();
                return;
            }
        }
        catch (Throwable throwable) {
            if (ignored != null) {
                try {
                    void var1_1;
                    var1_1.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    public static interface Evaluator<T> {
        public T evaluate();
    }
}

