/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.util;

import io.sentry.ManifestVersionDetector;
import io.sentry.NoopVersionDetector;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.util.Platform;

public final class InitUtil {
    /*
     * WARNING - void declaration
     */
    public static boolean shouldInit(SentryOptions previousOptions, SentryOptions newOptions, boolean isEnabled) {
        void var1_1;
        void var2_2;
        String string;
        if (Platform.isJvm() && newOptions.getVersionDetector() instanceof NoopVersionDetector) {
            newOptions.setVersionDetector(new ManifestVersionDetector(newOptions));
        }
        if (newOptions.getVersionDetector().checkForMixedVersions()) {
            newOptions.getLogger().log(SentryLevel.ERROR, "Not initializing Sentry because mixed SDK versions have been detected.", new Object[0]);
            String docsUrl = Platform.isAndroid() ? "https://docs.sentry.io/platforms/android/troubleshooting/mixed-versions" : "https://docs.sentry.io/platforms/java/troubleshooting/mixed-versions";
            throw new IllegalStateException("Sentry SDK has detected a mix of versions. This is not supported and likely leads to crashes. Please always use the same version of all SDK modules (dependencies). See " + (String)string + " for more details.");
        }
        if (var2_2 == false) {
            return true;
        }
        if (string == null) {
            return true;
        }
        if (newOptions.isForceInit()) {
            return true;
        }
        return ((SentryOptions)((Object)string)).getInitPriority().ordinal() <= var1_1.getInitPriority().ordinal();
    }
}

