/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.util;

import io.sentry.FilterString;
import io.sentry.SentryEvent;
import io.sentry.protocol.Message;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public final class ErrorUtils {
    public static boolean isIgnored(List<FilterString> ignoredErrors, SentryEvent event) {
        Object object;
        Throwable throwable;
        Iterator<FilterString> iterator;
        if (event == null || ignoredErrors == null || ignoredErrors.isEmpty()) {
            return false;
        }
        HashSet<Object> possibleMessages = new HashSet<Object>();
        Message eventMessage = event.getMessage();
        if (eventMessage != null) {
            String formattedMessage;
            String string = eventMessage.getMessage();
            if (string != null) {
                possibleMessages.add(string);
            }
            if ((formattedMessage = eventMessage.getFormatted()) != null) {
                possibleMessages.add(iterator);
            }
        }
        if ((throwable = event.getThrowable()) != null) {
            possibleMessages.add(throwable.toString());
        }
        for (FilterString filter : ignoredErrors) {
            if (!possibleMessages.contains(filter.getFilterString())) continue;
            return true;
        }
        iterator = object.iterator();
        while (iterator.hasNext()) {
            FilterString filter;
            filter = iterator.next();
            for (String string : possibleMessages) {
                if (!filter.matches(string)) continue;
                return true;
            }
        }
        return false;
    }
}

