/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.util;

import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public final class DebugMetaPropertiesApplier {
    public static String DEBUG_META_PROPERTIES_FILENAME = "sentry-debug-meta.properties";

    /*
     * WARNING - void declaration
     */
    public static void applyToOptions(SentryOptions options, List<Properties> debugMetaProperties) {
        if (debugMetaProperties != null) {
            void var1_1;
            SentryOptions sentryOptions;
            DebugMetaPropertiesApplier.applyBundleIds(options, debugMetaProperties);
            DebugMetaPropertiesApplier.applyProguardUuid(sentryOptions, (List<Properties>)var1_1);
        }
    }

    private static void applyBundleIds(SentryOptions options, List<Properties> debugMetaProperties) {
        if (options.getBundleIds().isEmpty()) {
            Iterator iterator;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                String[] stringArray = (String[])iterator.next();
                String bundleIdStrings = stringArray.getProperty("io.sentry.bundle-ids");
                options.getLogger().log(SentryLevel.DEBUG, "Bundle IDs found: %s", bundleIdStrings);
                if (bundleIdStrings == null) continue;
                String[] stringArray2 = stringArray.split(",", -1);
                stringArray = stringArray2;
                stringArray = stringArray2;
                int n = stringArray2.length;
                for (int i = 0; i < n; ++i) {
                    String bundleId = stringArray[i];
                    options.addBundleId(bundleId);
                }
            }
        }
    }

    private static void applyProguardUuid(SentryOptions options, List<Properties> debugMetaProperties) {
        if (options.getProguardUuid() == null) {
            Iterator iterator;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Properties properties = (Properties)iterator.next();
                String proguardUuid = DebugMetaPropertiesApplier.getProguardUuid(properties);
                if (proguardUuid == null) continue;
                options.getLogger().log(SentryLevel.DEBUG, "Proguard UUID found: %s", proguardUuid);
                options.setProguardUuid((String)((Object)properties));
                return;
            }
        }
    }

    public static String getProguardUuid(Properties debugMetaProperties) {
        return debugMetaProperties.getProperty("io.sentry.ProguardUuids");
    }
}

