/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.transport;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public final class ReusableCountLatch {
    private final Sync sync;

    /*
     * WARNING - void declaration
     */
    public ReusableCountLatch(int initialCount) {
        void var1_1;
        if (initialCount < 0) {
            throw new IllegalArgumentException("negative initial count '" + initialCount + "' is not allowed");
        }
        this.sync = new Sync((int)var1_1);
    }

    public ReusableCountLatch() {
        this(0);
    }

    public final int getCount() {
        return this.sync.getCount();
    }

    public final void decrement() {
        this.sync.decrement();
    }

    public final void increment() {
        this.sync.increment();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean waitTillZero(long timeout, TimeUnit unit) throws InterruptedException {
        void var1_1;
        void var3_2;
        return this.sync.tryAcquireSharedNanos(1, var3_2.toNanos((long)var1_1));
    }

    private static final class Sync
    extends AbstractQueuedSynchronizer {
        /*
         * WARNING - void declaration
         */
        Sync(int count) {
            void var1_1;
            this.setState((int)var1_1);
        }

        private int getCount() {
            return this.getState();
        }

        /*
         * WARNING - void declaration
         */
        private void increment() {
            void var2_2;
            void var1_1;
            do {
                int oldCount = this.getState();
                int newCount = oldCount + 1;
            } while (!this.compareAndSetState((int)var1_1, (int)var2_2));
        }

        private void decrement() {
            this.releaseShared(1);
        }

        @Override
        public final int tryAcquireShared(int acquires) {
            if (this.getState() == 0) {
                return 1;
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean tryReleaseShared(int releases) {
            void var2_2;
            int oldCount;
            int newCount;
            void var1_1;
            do {
                if ((oldCount = this.getState()) != 0) continue;
                return false;
            } while (!this.compareAndSetState((int)var1_1, newCount = oldCount - 1));
            return var2_2 == false;
        }
    }
}

