/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.transport;

import io.sentry.DataCategory;
import io.sentry.Hint;
import io.sentry.ISentryLifecycleToken;
import io.sentry.SentryEnvelope;
import io.sentry.SentryEnvelopeItem;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.clientreport.DiscardReason;
import io.sentry.hints.DiskFlushNotification;
import io.sentry.hints.Retryable;
import io.sentry.hints.SubmissionResult;
import io.sentry.transport.CurrentDateProvider;
import io.sentry.transport.ICurrentDateProvider;
import io.sentry.util.AutoClosableReentrantLock;
import io.sentry.util.HintUtils;
import io.sentry.util.StringUtils;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public final class RateLimiter
implements Closeable {
    private final ICurrentDateProvider currentDateProvider;
    private final SentryOptions options;
    private final Map<DataCategory, Date> sentryRetryAfterLimit = new ConcurrentHashMap<DataCategory, Date>();
    private final List<IRateLimitObserver> rateLimitObservers = new CopyOnWriteArrayList<IRateLimitObserver>();
    private Timer timer = null;
    private final AutoClosableReentrantLock timerLock = new AutoClosableReentrantLock();

    /*
     * WARNING - void declaration
     */
    public RateLimiter(ICurrentDateProvider currentDateProvider, SentryOptions options) {
        void var2_2;
        void var1_1;
        this.currentDateProvider = var1_1;
        this.options = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public RateLimiter(SentryOptions options) {
        this(CurrentDateProvider.getInstance(), (SentryOptions)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final SentryEnvelope filter(SentryEnvelope envelope, Hint hint) {
        void var1_1;
        ArrayList<SentryEnvelopeItem> dropItems = null;
        for (SentryEnvelopeItem item : envelope.getItems()) {
            if (!this.isRetryAfter(item.getHeader().getType().getItemType())) continue;
            if (dropItems == null) {
                dropItems = new ArrayList<SentryEnvelopeItem>();
            }
            dropItems.add(item);
            this.options.getClientReportRecorder().recordLostEnvelopeItem(DiscardReason.RATELIMIT_BACKOFF, item);
        }
        if (dropItems != null) {
            this.options.getLogger().log(SentryLevel.WARNING, "%d envelope items will be dropped due rate limiting.", dropItems.size());
            ArrayList<SentryEnvelopeItem> toSend = new ArrayList<SentryEnvelopeItem>();
            for (SentryEnvelopeItem item : envelope.getItems()) {
                if (dropItems.contains(item)) continue;
                toSend.add(item);
            }
            if (toSend.isEmpty()) {
                void var2_2;
                this.options.getLogger().log(SentryLevel.WARNING, "Envelope discarded due all items rate limited.", new Object[0]);
                this.markHintWhenSendingFailed((Hint)var2_2, false);
                return null;
            }
            return new SentryEnvelope(envelope.getHeader(), toSend);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isActiveForCategory(DataCategory dataCategory) {
        void var3_3;
        Date currentDate = new Date(this.currentDateProvider.getCurrentTimeMillis());
        Date dateAllCategories = this.sentryRetryAfterLimit.get((Object)DataCategory.All);
        if (dateAllCategories != null && !currentDate.after((Date)var3_3)) {
            return true;
        }
        if (DataCategory.Unknown.equals((Object)dataCategory)) {
            return false;
        }
        Date dateCategory = this.sentryRetryAfterLimit.get((Object)dataCategory);
        if (dateCategory != null) {
            void var1_1;
            void var2_2;
            return !var2_2.after((Date)var1_1);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isAnyRateLimitActive() {
        Date currentDate = new Date(this.currentDateProvider.getCurrentTimeMillis());
        for (DataCategory dataCategory : this.sentryRetryAfterLimit.keySet()) {
            void var3_3;
            Date dateCategory = this.sentryRetryAfterLimit.get((Object)dataCategory);
            if (dateCategory == null || currentDate.after((Date)var3_3)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void markHintWhenSendingFailed(Hint hint, boolean retry) {
        void var1_1;
        void var2_2;
        HintUtils.runIfHasType(hint, SubmissionResult.class, result -> result.setResult(false));
        HintUtils.runIfHasType(hint, Retryable.class, arg_0 -> RateLimiter.lambda$markHintWhenSendingFailed$1((boolean)var2_2, arg_0));
        HintUtils.runIfHasType((Hint)var1_1, DiskFlushNotification.class, diskFlushNotification -> {
            diskFlushNotification.markFlushed();
            this.options.getLogger().log(SentryLevel.DEBUG, "Disk flush envelope fired due to rate limit", new Object[0]);
        });
    }

    /*
     * WARNING - void declaration
     */
    private boolean isRetryAfter(String itemType) {
        void var1_1;
        DataCategory dataCategory = this.getCategoryFromItemType(itemType);
        return this.isActiveForCategory((DataCategory)var1_1);
    }

    private DataCategory getCategoryFromItemType(String itemType) {
        switch (itemType) {
            case "event": {
                return DataCategory.Error;
            }
            case "session": {
                return DataCategory.Session;
            }
            case "attachment": {
                return DataCategory.Attachment;
            }
            case "profile": {
                return DataCategory.Profile;
            }
            case "profile_chunk": {
                return DataCategory.ProfileChunk;
            }
            case "transaction": {
                return DataCategory.Transaction;
            }
            case "check_in": {
                return DataCategory.Monitor;
            }
            case "replay_video": {
                return DataCategory.Replay;
            }
        }
        return DataCategory.Unknown;
    }

    /*
     * WARNING - void declaration
     */
    public final void updateRetryAfterLimits(String sentryRateLimitHeader, String retryAfterHeader2, int errorCode) {
        void var3_4;
        String[] stringArray;
        if (sentryRateLimitHeader != null) {
            for (String retryAfterHeader2 : sentryRateLimitHeader.split(",", -1)) {
                void var3_5;
                String[] rateLimit = (retryAfterHeader2 = retryAfterHeader2.replace(" ", "")).split(":", -1);
                if (rateLimit.length <= 0) continue;
                String retryAfter = rateLimit[0];
                long retryAfterMillis = this.parseRetryAfterOrDefault(retryAfter);
                if (rateLimit.length <= 1) continue;
                String allCategories = rateLimit[1];
                Date date = new Date(this.currentDateProvider.getCurrentTimeMillis() + retryAfterMillis);
                if (allCategories != null && !allCategories.isEmpty()) {
                    String[] stringArray2 = stringArray.split(";", -1);
                    stringArray = stringArray2;
                    stringArray = stringArray2;
                    int n = stringArray2.length;
                    for (int i = 0; i < n; ++i) {
                        String catItem = stringArray[i];
                        DataCategory dataCategory = DataCategory.Unknown;
                        try {
                            String catItemCapitalized = StringUtils.camelCase(catItem);
                            if (catItemCapitalized != null) {
                                dataCategory = DataCategory.valueOf(catItemCapitalized);
                            } else {
                                this.options.getLogger().log(SentryLevel.ERROR, "Couldn't capitalize: %s", catItem);
                            }
                        }
                        catch (IllegalArgumentException e) {
                            this.options.getLogger().log(SentryLevel.INFO, e, "Unknown category: %s", catItem);
                        }
                        if (DataCategory.Unknown.equals((Object)dataCategory)) continue;
                        this.applyRetryAfterOnlyIfLonger(dataCategory, date);
                    }
                    continue;
                }
                this.applyRetryAfterOnlyIfLonger(DataCategory.All, (Date)var3_5);
            }
            return;
        }
        if (var3_4 == 429) {
            void var1_1;
            long retryAfterMillis = this.parseRetryAfterOrDefault((String)stringArray);
            Date date = new Date(this.currentDateProvider.getCurrentTimeMillis() + retryAfterMillis);
            this.applyRetryAfterOnlyIfLonger(DataCategory.All, (Date)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void applyRetryAfterOnlyIfLonger(DataCategory dataCategory, Date date) {
        void var3_5;
        Date oldDate = this.sentryRetryAfterLimit.get((Object)dataCategory);
        if (oldDate == null || date.after((Date)var3_5)) {
            this.sentryRetryAfterLimit.put(dataCategory, date);
            this.notifyRateLimitObservers();
            ISentryLifecycleToken ignored = this.timerLock.acquire();
            try {
                void var2_3;
                if (this.timer == null) {
                    this.timer = new Timer(true);
                }
                this.timer.schedule(new TimerTask(this){
                    final /* synthetic */ RateLimiter this$0;
                    {
                        void var1_1;
                        this.this$0 = var1_1;
                    }

                    @Override
                    public void run() {
                        this.this$0.notifyRateLimitObservers();
                    }
                }, (Date)var2_3);
                if (ignored != null) {
                    ignored.close();
                    return;
                }
            }
            catch (Throwable throwable) {
                if (ignored != null) {
                    try {
                        void var1_1;
                        var1_1.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private long parseRetryAfterOrDefault(String retryAfterHeader) {
        void var2_2;
        long retryAfterMillis = 60000L;
        if (retryAfterHeader != null) {
            try {
                void var1_1;
                retryAfterMillis = (long)(Double.parseDouble((String)var1_1) * 1000.0);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return (long)var2_2;
    }

    private void notifyRateLimitObservers() {
        for (IRateLimitObserver iRateLimitObserver : this.rateLimitObservers) {
            iRateLimitObserver.onRateLimitChanged(this);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void close() throws IOException {
        ISentryLifecycleToken ignored = this.timerLock.acquire();
        try {
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
            if (ignored != null) {
                ignored.close();
            }
        }
        catch (Throwable throwable) {
            if (ignored != null) {
                try {
                    void var1_1;
                    var1_1.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
        this.rateLimitObservers.clear();
    }

    private static /* synthetic */ void lambda$markHintWhenSendingFailed$1(boolean retry, Retryable retryable) {
        boolean bl;
        retryable.setRetry(bl);
    }

    public static interface IRateLimitObserver {
        public void onRateLimitChanged(RateLimiter var1);
    }
}

